/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.proxy;

import javax.baja.driver.point.BPointFolder;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Lonworks implementation of PointFolder
 *                      
 * @author    Robert Adams
 * @creation  1 Jul 04
 * @version   $Revision: 1$ $Date: 6/29/2004 4:30:18 PM$
 * @since     Niagara 3.0
 */
public class BLonPointFolder
  extends BPointFolder
{                           

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonPointFolder.class);
 
  public boolean isParentLegal(BComponent parent)
  {
    return ( parent.getType().is(BLonPointDeviceExt.TYPE) ||
             parent.getType().is(BLonPointFolder.TYPE) );
  }
  
  public boolean isChildLegal(BComponent child)
  {
    if( child.getType().is(BPointFolder.TYPE) &&
        !child.getType().is(BLonPointFolder.TYPE) )
    {
      return false;
    }    
    return true;
  }
  
}
