/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.proxy;

import javax.baja.agent.AgentList;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BPointFolder;
import javax.baja.lonworks.BLonDevice;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BLonPointDeviceExt is the lighweight container for LonProxyPoints.
 *
 * @author    Robert Adams
 * @creation  19 Dec 01
 * @version   $Revision: 4$ $Date: 10/18/01 2:56:42 PM$
 * @since     Niagara 3.0
 */
public class BLonPointDeviceExt
  extends BPointDeviceExt
{
  /*-
  class BLonPointDeviceExt
  {
    properties
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.proxy.BLonPointDeviceExt(2009017307)1.0$ @*/
/* Generated Mon Jun 28 11:53:03 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonPointDeviceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * BLonPointDeviceExt can only be contained in a BLonDevice.
   */
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BLonDevice;
  }
  
  /**
   * BLonPointDeviceExt can only contain a BPointFolder of type BLonPointFolder
   */
  public boolean isChildLegal(BComponent child)
  {
    if( child.getType().is(BPointFolder.TYPE) &&
        !child.getType().is(BLonPointFolder.TYPE) )
    {
      return false;
    }    
    return true;
  }
  
  /**
   * Get the parent device Type.
   */
  public Type getDeviceType() { return BLonDevice.TYPE; }

  /**
   * Get the Type of point folder for this device.
   */
  public Type getPointFolderType() { return BLonPointFolder.TYPE; }      
  

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * Return BLonProxyExt Type for this device.
   */
  public Type getProxyExtType() { return BLonProxyExt.TYPE; }     

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  /**
   * Get the agent list.  Remove Device Manager and Network Summary.
   */
  public AgentList getAgents(Context cx)
  {
    AgentList agents = super.getAgents(cx);
    agents.remove("driver:PointManager");
    agents.remove("driver:PointSummary");
    return agents;
  }


////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////


}
