/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.enums.BLonRailAudioSensorTypeEnum;
import javax.baja.lonworks.enums.BLonRailAudioTypeEnum;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_rac_req.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  10 Nov 06
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonRacReq
  extends BLonData
{  
  /*
 <RacReq type="XTypeDef">
  <elem n="destDef                    " qual="ub byt=0 bit=7 len=1"/>
  <elem n="destP2P                    " qual="ub byt=0 bit=6 len=1"/>
  <elem n="reserved                   " qual="ub byt=0 bit=0 len=6"/>
  <elem n="audioType                  " qual="e8                         " enumDef="RailAudioTypeT"/>
  <elem n="addrInitUnitId             " qual="ub byt=2 bit=4 len=4"/>
  <elem n="addrInitLocation           " qual="ub byt=2 bit=0 len=4"/>
  <elem n="addrInitCarId              " qual="ub byt=3 bit=3 len=5"/>
  <elem n="addrInitReserved           " qual="ub byt=3 bit=0 len=3"/>
  <elem n="addrInitAudioSensorType    " qual="e8                         " enumDef="RailAudioSensorTypeT"/>
  <elem n="addrDestP2PUnitId          " qual="ub byt=5 bit=4 len=4"/>
  <elem n="addrDestP2PLocation        " qual="ub byt=5 bit=0 len=4"/>
  <elem n="addrDestP2PCarId           " qual="ub byt=6 bit=3 len=5"/>
  <elem n="addrDestP2PReserved        " qual="ub byt=6 bit=0 len=3"/>
  <elem n="addrDestP2PAudioSensorType " qual="e8                         " enumDef="RailAudioSensorTypeT"/>
  <elem n="addrDestP2MMaskUnit        " qual="u8 byt=5"/>
  <elem n="addrDestP2MMaskCar         " qual="st len=4"/>
  <elem n="addrDestP2MMaskLocation    " qual="st len=2"/>
  <elem n="addrDestP2MMaskAudio       " qual="st len=3"/>
  <typeScope v="0,182"/>
 </RacReq>
  */

  /*-

  class BLonRacReq
  {
    properties
    {
      destDef                    : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 7, 1, null) ]}
      destP2P                    : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 6, 1, null) ]}
      reserved                   : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 0, 0, 6, null) ]}
      audioType                  : BLonEnum     default{[ BLonEnum.make(BLonRailAudioTypeEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      addrInitUnitId             : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 4, 4, null) ]}
      addrInitLocation           : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 8, 1F, 0F, true, 2, 0, false, 0F, 4, null) ]}
      addrInitCarId              : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 3, 5, null) ]}
      addrInitReserved           : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 3, null) ]}
      addrInitAudioSensorType    : BLonEnum     default{[ BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      addrDestP2PUnitId          : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 4, 4, null) ]}
      addrDestP2PLocation        : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 0, 4, null) ]}
      addrDestP2PCarId           : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 3, 5, null) ]}
      addrDestP2PReserved        : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 0, 3, null) ]}
      addrDestP2PAudioSensorType : BLonEnum     default{[ BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      addrDestP2MMaskUnit        : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 5, null) ]}
      addrDestP2MMaskCar         : BLonString   default{[ BLonString .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.st, 4, null) ]}
      addrDestP2MMaskLocation    : BLonString   default{[ BLonString .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.st, 2, null) ]}
      addrDestP2MMaskAudio       : BLonString   default{[ BLonString .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.st, 3, null) ]}
    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonRacReq(3651151555)1.0$ @*/
/* Generated Wed Jan 27 16:28:24 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "destDef"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>destDef</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getDestDef
   * @see javax.baja.lonworks.londata.BLonRacReq#setDestDef
   */
  public static final Property destDef = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 7, 1, null));
  
  /**
   * Get the <code>destDef</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#destDef
   */
  public BLonBoolean getDestDef() { return (BLonBoolean)get(destDef); }
  
  /**
   * Set the <code>destDef</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#destDef
   */
  public void setDestDef(BLonBoolean v) { set(destDef,v,null); }

////////////////////////////////////////////////////////////////
// Property "destP2P"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>destP2P</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getDestP2P
   * @see javax.baja.lonworks.londata.BLonRacReq#setDestP2P
   */
  public static final Property destP2P = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 6, 1, null));
  
  /**
   * Get the <code>destP2P</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#destP2P
   */
  public BLonBoolean getDestP2P() { return (BLonBoolean)get(destP2P); }
  
  /**
   * Set the <code>destP2P</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#destP2P
   */
  public void setDestP2P(BLonBoolean v) { set(destP2P,v,null); }

////////////////////////////////////////////////////////////////
// Property "reserved"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>reserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getReserved
   * @see javax.baja.lonworks.londata.BLonRacReq#setReserved
   */
  public static final Property reserved = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 0, 0, 6, null));
  
  /**
   * Get the <code>reserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#reserved
   */
  public BLonFloat getReserved() { return (BLonFloat)get(reserved); }
  
  /**
   * Set the <code>reserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#reserved
   */
  public void setReserved(BLonFloat v) { set(reserved,v,null); }

////////////////////////////////////////////////////////////////
// Property "audioType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>audioType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAudioType
   * @see javax.baja.lonworks.londata.BLonRacReq#setAudioType
   */
  public static final Property audioType = newProperty(0, BLonEnum.make(BLonRailAudioTypeEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null));
  
  /**
   * Get the <code>audioType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#audioType
   */
  public BLonEnum getAudioType() { return (BLonEnum)get(audioType); }
  
  /**
   * Set the <code>audioType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#audioType
   */
  public void setAudioType(BLonEnum v) { set(audioType,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitUnitId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrInitUnitId
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrInitUnitId
   */
  public static final Property addrInitUnitId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 4, 4, null));
  
  /**
   * Get the <code>addrInitUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitUnitId
   */
  public BLonFloat getAddrInitUnitId() { return (BLonFloat)get(addrInitUnitId); }
  
  /**
   * Set the <code>addrInitUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitUnitId
   */
  public void setAddrInitUnitId(BLonFloat v) { set(addrInitUnitId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitLocation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrInitLocation
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrInitLocation
   */
  public static final Property addrInitLocation = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 8, 1F, 0F, true, 2, 0, false, 0F, 4, null));
  
  /**
   * Get the <code>addrInitLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitLocation
   */
  public BLonFloat getAddrInitLocation() { return (BLonFloat)get(addrInitLocation); }
  
  /**
   * Set the <code>addrInitLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitLocation
   */
  public void setAddrInitLocation(BLonFloat v) { set(addrInitLocation,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitCarId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrInitCarId
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrInitCarId
   */
  public static final Property addrInitCarId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 3, 5, null));
  
  /**
   * Get the <code>addrInitCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitCarId
   */
  public BLonFloat getAddrInitCarId() { return (BLonFloat)get(addrInitCarId); }
  
  /**
   * Set the <code>addrInitCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitCarId
   */
  public void setAddrInitCarId(BLonFloat v) { set(addrInitCarId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitReserved"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrInitReserved
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrInitReserved
   */
  public static final Property addrInitReserved = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 3, null));
  
  /**
   * Get the <code>addrInitReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitReserved
   */
  public BLonFloat getAddrInitReserved() { return (BLonFloat)get(addrInitReserved); }
  
  /**
   * Set the <code>addrInitReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitReserved
   */
  public void setAddrInitReserved(BLonFloat v) { set(addrInitReserved,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitAudioSensorType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrInitAudioSensorType
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrInitAudioSensorType
   */
  public static final Property addrInitAudioSensorType = newProperty(0, BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null));
  
  /**
   * Get the <code>addrInitAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitAudioSensorType
   */
  public BLonEnum getAddrInitAudioSensorType() { return (BLonEnum)get(addrInitAudioSensorType); }
  
  /**
   * Set the <code>addrInitAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrInitAudioSensorType
   */
  public void setAddrInitAudioSensorType(BLonEnum v) { set(addrInitAudioSensorType,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PUnitId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2PUnitId
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2PUnitId
   */
  public static final Property addrDestP2PUnitId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 4, 4, null));
  
  /**
   * Get the <code>addrDestP2PUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PUnitId
   */
  public BLonFloat getAddrDestP2PUnitId() { return (BLonFloat)get(addrDestP2PUnitId); }
  
  /**
   * Set the <code>addrDestP2PUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PUnitId
   */
  public void setAddrDestP2PUnitId(BLonFloat v) { set(addrDestP2PUnitId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PLocation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2PLocation
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2PLocation
   */
  public static final Property addrDestP2PLocation = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 0, 4, null));
  
  /**
   * Get the <code>addrDestP2PLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PLocation
   */
  public BLonFloat getAddrDestP2PLocation() { return (BLonFloat)get(addrDestP2PLocation); }
  
  /**
   * Set the <code>addrDestP2PLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PLocation
   */
  public void setAddrDestP2PLocation(BLonFloat v) { set(addrDestP2PLocation,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PCarId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2PCarId
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2PCarId
   */
  public static final Property addrDestP2PCarId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 3, 5, null));
  
  /**
   * Get the <code>addrDestP2PCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PCarId
   */
  public BLonFloat getAddrDestP2PCarId() { return (BLonFloat)get(addrDestP2PCarId); }
  
  /**
   * Set the <code>addrDestP2PCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PCarId
   */
  public void setAddrDestP2PCarId(BLonFloat v) { set(addrDestP2PCarId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PReserved"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2PReserved
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2PReserved
   */
  public static final Property addrDestP2PReserved = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 0, 3, null));
  
  /**
   * Get the <code>addrDestP2PReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PReserved
   */
  public BLonFloat getAddrDestP2PReserved() { return (BLonFloat)get(addrDestP2PReserved); }
  
  /**
   * Set the <code>addrDestP2PReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PReserved
   */
  public void setAddrDestP2PReserved(BLonFloat v) { set(addrDestP2PReserved,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PAudioSensorType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2PAudioSensorType
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2PAudioSensorType
   */
  public static final Property addrDestP2PAudioSensorType = newProperty(0, BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null));
  
  /**
   * Get the <code>addrDestP2PAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PAudioSensorType
   */
  public BLonEnum getAddrDestP2PAudioSensorType() { return (BLonEnum)get(addrDestP2PAudioSensorType); }
  
  /**
   * Set the <code>addrDestP2PAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2PAudioSensorType
   */
  public void setAddrDestP2PAudioSensorType(BLonEnum v) { set(addrDestP2PAudioSensorType,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskUnit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskUnit</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2MMaskUnit
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2MMaskUnit
   */
  public static final Property addrDestP2MMaskUnit = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 5, null));
  
  /**
   * Get the <code>addrDestP2MMaskUnit</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskUnit
   */
  public BLonFloat getAddrDestP2MMaskUnit() { return (BLonFloat)get(addrDestP2MMaskUnit); }
  
  /**
   * Set the <code>addrDestP2MMaskUnit</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskUnit
   */
  public void setAddrDestP2MMaskUnit(BLonFloat v) { set(addrDestP2MMaskUnit,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskCar"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskCar</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2MMaskCar
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2MMaskCar
   */
  public static final Property addrDestP2MMaskCar = newProperty(0, BLonString .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.st, 4, null));
  
  /**
   * Get the <code>addrDestP2MMaskCar</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskCar
   */
  public BLonString getAddrDestP2MMaskCar() { return (BLonString)get(addrDestP2MMaskCar); }
  
  /**
   * Set the <code>addrDestP2MMaskCar</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskCar
   */
  public void setAddrDestP2MMaskCar(BLonString v) { set(addrDestP2MMaskCar,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskLocation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2MMaskLocation
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2MMaskLocation
   */
  public static final Property addrDestP2MMaskLocation = newProperty(0, BLonString .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.st, 2, null));
  
  /**
   * Get the <code>addrDestP2MMaskLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskLocation
   */
  public BLonString getAddrDestP2MMaskLocation() { return (BLonString)get(addrDestP2MMaskLocation); }
  
  /**
   * Set the <code>addrDestP2MMaskLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskLocation
   */
  public void setAddrDestP2MMaskLocation(BLonString v) { set(addrDestP2MMaskLocation,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskAudio"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskAudio</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#getAddrDestP2MMaskAudio
   * @see javax.baja.lonworks.londata.BLonRacReq#setAddrDestP2MMaskAudio
   */
  public static final Property addrDestP2MMaskAudio = newProperty(0, BLonString .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.st, 3, null));
  
  /**
   * Get the <code>addrDestP2MMaskAudio</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskAudio
   */
  public BLonString getAddrDestP2MMaskAudio() { return (BLonString)get(addrDestP2MMaskAudio); }
  
  /**
   * Set the <code>addrDestP2MMaskAudio</code> property.
   * @see javax.baja.lonworks.londata.BLonRacReq#addrDestP2MMaskAudio
   */
  public void setAddrDestP2MMaskAudio(BLonString v) { set(addrDestP2MMaskAudio,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonRacReq.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(destDef                   , out);
    primitiveToOutputStream(destP2P                   , out);
    primitiveToOutputStream(reserved                  , out);
    primitiveToOutputStream(audioType                 , out);
    primitiveToOutputStream(addrInitUnitId            , out);
    primitiveToOutputStream(addrInitLocation          , out);
    primitiveToOutputStream(addrInitCarId             , out);
    primitiveToOutputStream(addrInitReserved          , out);
    primitiveToOutputStream(addrInitAudioSensorType   , out);

    if(getDestP2P().getBoolean()) // This is just a quess - can't find any documentation
    {
      primitiveToOutputStream(addrDestP2PUnitId          , out);
      primitiveToOutputStream(addrDestP2PLocation        , out);
      primitiveToOutputStream(addrDestP2PCarId           , out);
      primitiveToOutputStream(addrDestP2PReserved        , out);
      primitiveToOutputStream(addrDestP2PAudioSensorType , out);
    }  
    else
    {
      primitiveToOutputStream(addrDestP2MMaskUnit         , out);
      primitiveToOutputStream(addrDestP2MMaskCar          , out);
      primitiveToOutputStream(addrDestP2MMaskLocation     , out);
      primitiveToOutputStream(addrDestP2MMaskAudio        , out);
    }  
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(destDef                   , in);
    primitiveFromInputStream(destP2P                   , in);
    primitiveFromInputStream(reserved                  , in);
    primitiveFromInputStream(audioType                 , in);
    primitiveFromInputStream(addrInitUnitId            , in);
    primitiveFromInputStream(addrInitLocation          , in);
    primitiveFromInputStream(addrInitCarId             , in);
    primitiveFromInputStream(addrInitReserved          , in);
    primitiveFromInputStream(addrInitAudioSensorType   , in);
    
    if(getDestP2P().getBoolean())
    {
      primitiveFromInputStream(addrDestP2PUnitId          , in);
      primitiveFromInputStream(addrDestP2PLocation        , in);
      primitiveFromInputStream(addrDestP2PCarId           , in);
      primitiveFromInputStream(addrDestP2PReserved        , in);
      primitiveFromInputStream(addrDestP2PAudioSensorType , in);
    }
    else
    {
      primitiveFromInputStream(addrDestP2MMaskUnit        , in);
      primitiveFromInputStream(addrDestP2MMaskCar         , in);
      primitiveFromInputStream(addrDestP2MMaskLocation    , in);
      primitiveFromInputStream(addrDestP2MMaskAudio       , in);
    }
  }  


}      