/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.enums.BLonFileStatusEnum;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_file_status.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  4 Sept 01
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:44 AM$
 * @since     Niagara 3.0
 */
public class BLonFileStatus
  extends BLonData
{  
  /*-

  class BLonFileStatus
  {
    properties
    {
      fileStatus : BLonEnum
        default {[ BLonEnum.make(BLonFileStatusEnum.DEFAULT) ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      numberOfFiles : BLonInteger
        default {[ BLonInteger.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementQualifiers.UNSIGNED_LONG1, null) ]}
      selectedFile : BLonInteger
        default {[ BLonInteger.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementQualifiers.UNSIGNED_LONG1, null) ]}
      fileInfo : BLonString
        default {[ BLonString.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.st,16,null) ]}
      size : BLonInteger
        default {[ BLonInteger.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.s32, null) ]}
      fileType : BLonInteger
        default {[ BLonInteger.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementQualifiers.UNSIGNED_LONG1, null) ]}
      domainId : BLonByteArray
        default {[ BLonByteArray.make(6) ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.na,6,null) ]}
      domainLength : BLonInteger
        default {[ BLonInteger.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 6, 1, null) ]}
      subnet : BLonInteger
        default {[ BLonInteger.make(1) ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 255, 1, null) ]}
      node : BLonInteger
        default {[ BLonInteger.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 1, 127, 1, null) ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonFileStatus(3317302189)1.0$ @*/
/* Generated Tue Apr 06 10:08:42 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "fileStatus"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fileStatus</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getFileStatus
   * @see javax.baja.lonworks.londata.BLonFileStatus#setFileStatus
   */
  public static final Property fileStatus = newProperty(0, BLonEnum.make(BLonFileStatusEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>fileStatus</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#fileStatus
   */
  public BLonEnum getFileStatus() { return (BLonEnum)get(fileStatus); }
  
  /**
   * Set the <code>fileStatus</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#fileStatus
   */
  public void setFileStatus(BLonEnum v) { set(fileStatus,v,null); }

////////////////////////////////////////////////////////////////
// Property "numberOfFiles"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numberOfFiles</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getNumberOfFiles
   * @see javax.baja.lonworks.londata.BLonFileStatus#setNumberOfFiles
   */
  public static final Property numberOfFiles = newProperty(0, BLonInteger.DEFAULT,LonFacetsUtil.makeFacets(BLonElementQualifiers.UNSIGNED_LONG1, null) );
  
  /**
   * Get the <code>numberOfFiles</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#numberOfFiles
   */
  public BLonInteger getNumberOfFiles() { return (BLonInteger)get(numberOfFiles); }
  
  /**
   * Set the <code>numberOfFiles</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#numberOfFiles
   */
  public void setNumberOfFiles(BLonInteger v) { set(numberOfFiles,v,null); }

////////////////////////////////////////////////////////////////
// Property "selectedFile"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selectedFile</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getSelectedFile
   * @see javax.baja.lonworks.londata.BLonFileStatus#setSelectedFile
   */
  public static final Property selectedFile = newProperty(0, BLonInteger.DEFAULT,LonFacetsUtil.makeFacets(BLonElementQualifiers.UNSIGNED_LONG1, null) );
  
  /**
   * Get the <code>selectedFile</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#selectedFile
   */
  public BLonInteger getSelectedFile() { return (BLonInteger)get(selectedFile); }
  
  /**
   * Set the <code>selectedFile</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#selectedFile
   */
  public void setSelectedFile(BLonInteger v) { set(selectedFile,v,null); }

////////////////////////////////////////////////////////////////
// Property "fileInfo"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fileInfo</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getFileInfo
   * @see javax.baja.lonworks.londata.BLonFileStatus#setFileInfo
   */
  public static final Property fileInfo = newProperty(0, BLonString.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.st,16,null) );
  
  /**
   * Get the <code>fileInfo</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#fileInfo
   */
  public BLonString getFileInfo() { return (BLonString)get(fileInfo); }
  
  /**
   * Set the <code>fileInfo</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#fileInfo
   */
  public void setFileInfo(BLonString v) { set(fileInfo,v,null); }

////////////////////////////////////////////////////////////////
// Property "size"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>size</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getSize
   * @see javax.baja.lonworks.londata.BLonFileStatus#setSize
   */
  public static final Property size = newProperty(0, BLonInteger.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.s32, null) );
  
  /**
   * Get the <code>size</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#size
   */
  public BLonInteger getSize() { return (BLonInteger)get(size); }
  
  /**
   * Set the <code>size</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#size
   */
  public void setSize(BLonInteger v) { set(size,v,null); }

////////////////////////////////////////////////////////////////
// Property "fileType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fileType</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getFileType
   * @see javax.baja.lonworks.londata.BLonFileStatus#setFileType
   */
  public static final Property fileType = newProperty(0, BLonInteger.DEFAULT,LonFacetsUtil.makeFacets(BLonElementQualifiers.UNSIGNED_LONG1, null) );
  
  /**
   * Get the <code>fileType</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#fileType
   */
  public BLonInteger getFileType() { return (BLonInteger)get(fileType); }
  
  /**
   * Set the <code>fileType</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#fileType
   */
  public void setFileType(BLonInteger v) { set(fileType,v,null); }

////////////////////////////////////////////////////////////////
// Property "domainId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>domainId</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getDomainId
   * @see javax.baja.lonworks.londata.BLonFileStatus#setDomainId
   */
  public static final Property domainId = newProperty(0, BLonByteArray.make(6),LonFacetsUtil.makeFacets(BLonElementType.na,6,null) );
  
  /**
   * Get the <code>domainId</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#domainId
   */
  public BLonByteArray getDomainId() { return (BLonByteArray)get(domainId); }
  
  /**
   * Set the <code>domainId</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#domainId
   */
  public void setDomainId(BLonByteArray v) { set(domainId,v,null); }

////////////////////////////////////////////////////////////////
// Property "domainLength"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>domainLength</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getDomainLength
   * @see javax.baja.lonworks.londata.BLonFileStatus#setDomainLength
   */
  public static final Property domainLength = newProperty(0, BLonInteger.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 6, 1, null) );
  
  /**
   * Get the <code>domainLength</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#domainLength
   */
  public BLonInteger getDomainLength() { return (BLonInteger)get(domainLength); }
  
  /**
   * Set the <code>domainLength</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#domainLength
   */
  public void setDomainLength(BLonInteger v) { set(domainLength,v,null); }

////////////////////////////////////////////////////////////////
// Property "subnet"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>subnet</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getSubnet
   * @see javax.baja.lonworks.londata.BLonFileStatus#setSubnet
   */
  public static final Property subnet = newProperty(0, BLonInteger.make(1),LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 255, 1, null) );
  
  /**
   * Get the <code>subnet</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#subnet
   */
  public BLonInteger getSubnet() { return (BLonInteger)get(subnet); }
  
  /**
   * Set the <code>subnet</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#subnet
   */
  public void setSubnet(BLonInteger v) { set(subnet,v,null); }

////////////////////////////////////////////////////////////////
// Property "node"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>node</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#getNode
   * @see javax.baja.lonworks.londata.BLonFileStatus#setNode
   */
  public static final Property node = newProperty(0, BLonInteger.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 1, 127, 1, null) );
  
  /**
   * Get the <code>node</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#node
   */
  public BLonInteger getNode() { return (BLonInteger)get(node); }
  
  /**
   * Set the <code>node</code> property.
   * @see javax.baja.lonworks.londata.BLonFileStatus#node
   */
  public void setNode(BLonInteger v) { set(node,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonFileStatus.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   *  Converts data to network byte format
   **/
  
  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(fileStatus, out);
    primitiveToOutputStream(numberOfFiles, out);
    primitiveToOutputStream(selectedFile, out);
    
    int st = getFileStatus().getEnum().getOrdinal();
    if(st == BLonFileStatusEnum.FS_LOOKUP_OK )
    {
      primitiveToOutputStream(fileInfo, out);
      primitiveToOutputStream(size, out);
      primitiveToOutputStream(fileType, out);
    }
    else
    {
      primitiveToOutputStream(domainId, out);
      primitiveToOutputStream(domainLength, out);
      primitiveToOutputStream(subnet, out);
      primitiveToOutputStream(node, out);
    }
  }
  
  /**
   *  Translates from network bytes. 
   */
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(fileStatus, in);
    primitiveFromInputStream(numberOfFiles, in);
    primitiveFromInputStream(selectedFile, in);
    
    int st = getFileStatus().getEnum().getOrdinal();
    if(st == BLonFileStatusEnum.FS_LOOKUP_OK )
    {
      primitiveFromInputStream(fileInfo, in);
      primitiveFromInputStream(size, in);
      primitiveFromInputStream(fileType, in);
    }
    else
    {
      primitiveFromInputStream(domainId, in);
      primitiveFromInputStream(domainLength, in);
      primitiveFromInputStream(subnet, in);
      primitiveFromInputStream(node, in);
    }
    
  }

}