/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonDeviceSelectEnum;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_dev_status.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  4 Sept 01
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonDevStatus
  extends BLonData
{  
  /*
 <DevStatus type="XTypeDef">
  <elem n="deviceSelect" qual="e8" enumDef="DeviceSelectT"/>
  <elem n="pumpCtrlDeviceFault      " qual="ub byt=1 bit=7 len=1"/>
  <elem n="pumpCtrlSupplyFault      " qual="ub byt=1 bit=6 len=1"/>
  <elem n="pumpCtrlReserved12       " qual="ub byt=1 bit=5 len=1"/>
  <elem n="pumpCtrlSpeedLow         " qual="ub byt=1 bit=4 len=1"/>
  <elem n="pumpCtrlSpeedHigh        " qual="ub byt=1 bit=3 len=1"/>
  <elem n="pumpCtrlReserved15       " qual="ub byt=1 bit=2 len=1"/>
  <elem n="pumpCtrlSetptOutOfRange  " qual="ub byt=1 bit=1 len=1"/>
  <elem n="pumpCtrlReserved17       " qual="ub byt=1 bit=0 len=1"/>
  <elem n="pumpCtrlLocalControl     " qual="ub byt=2 bit=7 len=1"/>
  <elem n="pumpCtrlReserved21       " qual="ub byt=2 bit=6 len=1"/>
  <elem n="pumpCtrlRunning          " qual="ub byt=2 bit=5 len=1"/>
  <elem n="pumpCtrlReserved23       " qual="ub byt=2 bit=4 len=1"/>
  <elem n="pumpCtrlRemotePress      " qual="ub byt=2 bit=3 len=1"/>
  <elem n="pumpCtrlRemoteFlow       " qual="ub byt=2 bit=2 len=1"/>
  <elem n="pumpCtrlRemoteTemp       " qual="ub byt=2 bit=1 len=1"/>
  <elem n="pumpCtrlReserved27       " qual="ub byt=2 bit=0 len=1"/>
  <elem n="pumpCtrlReserved307      " qual="ub byt=3 bit=0 len=8"/>
  <elem n="valvePosRunning          " qual="ub byt=1 bit=7 len=1"/>
  <elem n="valvePosAdapting         " qual="ub byt=1 bit=6 len=1"/>
  <elem n="valvePosInitializing     " qual="ub byt=1 bit=5 len=1"/>
  <elem n="valvePosLocalControl     " qual="ub byt=1 bit=4 len=1"/>
  <elem n="valvePosSetptOutOfRange  " qual="ub byt=1 bit=3 len=1"/>
  <elem n="valvePosRemoteCtrlSignal " qual="ub byt=1 bit=2 len=1"/>
  <elem n="valvePosReserved167      " qual="ub byt=1 bit=0 len=2 max=1.0"/>
  <elem n="valvePosHwEmergency      " qual="ub byt=2 bit=7 len=1"/>
  <elem n="valvePosSwEmergency      " qual="ub byt=2 bit=6 len=1"/>
  <elem n="valvePosReserved227      " qual="ub byt=2 bit=0 len=6 max=1.0"/>
  <elem n="valvePosReserved307      " qual="ub byt=3 bit=0 len=8"/>
  <typeScope v="0,173"/>
 </DevStatus>
  */

  /*-

  class BLonDevStatus
  {
    properties
    {
      deviceSelect     : BLonEnum   default {[ BLonEnum.make(BLonDeviceSelectEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      pumpCtrlDeviceFault     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) ]}
      pumpCtrlSupplyFault     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) ]}
      pumpCtrlReserved12      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) ]}
      pumpCtrlSpeedLow        : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) ]}
      pumpCtrlSpeedHigh       : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) ]}
      pumpCtrlReserved15      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) ]}
      pumpCtrlSetptOutOfRange : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) ]}
      pumpCtrlReserved17      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) ]}
      pumpCtrlLocalControl    : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 7, 1, null) ]}
      pumpCtrlReserved21      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 6, 1, null) ]}
      pumpCtrlRunning         : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 5, 1, null) ]}
      pumpCtrlReserved23      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 4, 1, null) ]}
      pumpCtrlRemotePress     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 3, 1, null) ]}
      pumpCtrlRemoteFlow      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 2, 1, null) ]}
      pumpCtrlRemoteTemp      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 1, 1, null) ]}
      pumpCtrlReserved27      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 0, 1, null) ]}
      pumpCtrlReserved307     : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) ]}

      valvePosRunning          : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) ]}
      valvePosAdapting         : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) ]}
      valvePosInitializing     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) ]}
      valvePosLocalControl     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) ]}
      valvePosSetptOutOfRange  : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) ]}
      valvePosRemoteCtrlSignal : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) ]}
      valvePosReserved167      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 1, 0, false, 0F, 2, null) ]}
      valvePosHwEmergency      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 7, 1, null) ]}
      valvePosSwEmergency      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 6, 1, null) ]}
      valvePosReserved227      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 2, 0, false, 0F, 6, null) ]}
      valvePosReserved307      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) ]}


    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonDevStatus(945735718)1.0$ @*/
/* Generated Thu Nov 09 16:15:08 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceSelect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getDeviceSelect
   * @see javax.baja.lonworks.londata.BLonDevStatus#setDeviceSelect
   */
  public static final Property deviceSelect = newProperty(0, BLonEnum.make(BLonDeviceSelectEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#deviceSelect
   */
  public BLonEnum getDeviceSelect() { return (BLonEnum)get(deviceSelect); }
  
  /**
   * Set the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#deviceSelect
   */
  public void setDeviceSelect(BLonEnum v) { set(deviceSelect,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDeviceFault"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDeviceFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlDeviceFault
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlDeviceFault
   */
  public static final Property pumpCtrlDeviceFault = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDeviceFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlDeviceFault
   */
  public BLonBoolean getPumpCtrlDeviceFault() { return (BLonBoolean)get(pumpCtrlDeviceFault); }
  
  /**
   * Set the <code>pumpCtrlDeviceFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlDeviceFault
   */
  public void setPumpCtrlDeviceFault(BLonBoolean v) { set(pumpCtrlDeviceFault,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSupplyFault"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSupplyFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlSupplyFault
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlSupplyFault
   */
  public static final Property pumpCtrlSupplyFault = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSupplyFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSupplyFault
   */
  public BLonBoolean getPumpCtrlSupplyFault() { return (BLonBoolean)get(pumpCtrlSupplyFault); }
  
  /**
   * Set the <code>pumpCtrlSupplyFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSupplyFault
   */
  public void setPumpCtrlSupplyFault(BLonBoolean v) { set(pumpCtrlSupplyFault,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved12"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved12</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlReserved12
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlReserved12
   */
  public static final Property pumpCtrlReserved12 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) );
  
  /**
   * Get the <code>pumpCtrlReserved12</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved12
   */
  public BLonBoolean getPumpCtrlReserved12() { return (BLonBoolean)get(pumpCtrlReserved12); }
  
  /**
   * Set the <code>pumpCtrlReserved12</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved12
   */
  public void setPumpCtrlReserved12(BLonBoolean v) { set(pumpCtrlReserved12,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSpeedLow"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSpeedLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlSpeedLow
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlSpeedLow
   */
  public static final Property pumpCtrlSpeedLow = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSpeedLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSpeedLow
   */
  public BLonBoolean getPumpCtrlSpeedLow() { return (BLonBoolean)get(pumpCtrlSpeedLow); }
  
  /**
   * Set the <code>pumpCtrlSpeedLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSpeedLow
   */
  public void setPumpCtrlSpeedLow(BLonBoolean v) { set(pumpCtrlSpeedLow,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSpeedHigh"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSpeedHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlSpeedHigh
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlSpeedHigh
   */
  public static final Property pumpCtrlSpeedHigh = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSpeedHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSpeedHigh
   */
  public BLonBoolean getPumpCtrlSpeedHigh() { return (BLonBoolean)get(pumpCtrlSpeedHigh); }
  
  /**
   * Set the <code>pumpCtrlSpeedHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSpeedHigh
   */
  public void setPumpCtrlSpeedHigh(BLonBoolean v) { set(pumpCtrlSpeedHigh,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved15"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved15</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlReserved15
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlReserved15
   */
  public static final Property pumpCtrlReserved15 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) );
  
  /**
   * Get the <code>pumpCtrlReserved15</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved15
   */
  public BLonBoolean getPumpCtrlReserved15() { return (BLonBoolean)get(pumpCtrlReserved15); }
  
  /**
   * Set the <code>pumpCtrlReserved15</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved15
   */
  public void setPumpCtrlReserved15(BLonBoolean v) { set(pumpCtrlReserved15,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSetptOutOfRange"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSetptOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlSetptOutOfRange
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlSetptOutOfRange
   */
  public static final Property pumpCtrlSetptOutOfRange = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSetptOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSetptOutOfRange
   */
  public BLonBoolean getPumpCtrlSetptOutOfRange() { return (BLonBoolean)get(pumpCtrlSetptOutOfRange); }
  
  /**
   * Set the <code>pumpCtrlSetptOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlSetptOutOfRange
   */
  public void setPumpCtrlSetptOutOfRange(BLonBoolean v) { set(pumpCtrlSetptOutOfRange,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved17"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlReserved17
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlReserved17
   */
  public static final Property pumpCtrlReserved17 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) );
  
  /**
   * Get the <code>pumpCtrlReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved17
   */
  public BLonBoolean getPumpCtrlReserved17() { return (BLonBoolean)get(pumpCtrlReserved17); }
  
  /**
   * Set the <code>pumpCtrlReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved17
   */
  public void setPumpCtrlReserved17(BLonBoolean v) { set(pumpCtrlReserved17,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlLocalControl"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlLocalControl</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlLocalControl
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlLocalControl
   */
  public static final Property pumpCtrlLocalControl = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 7, 1, null) );
  
  /**
   * Get the <code>pumpCtrlLocalControl</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlLocalControl
   */
  public BLonBoolean getPumpCtrlLocalControl() { return (BLonBoolean)get(pumpCtrlLocalControl); }
  
  /**
   * Set the <code>pumpCtrlLocalControl</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlLocalControl
   */
  public void setPumpCtrlLocalControl(BLonBoolean v) { set(pumpCtrlLocalControl,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved21"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved21</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlReserved21
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlReserved21
   */
  public static final Property pumpCtrlReserved21 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 6, 1, null) );
  
  /**
   * Get the <code>pumpCtrlReserved21</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved21
   */
  public BLonBoolean getPumpCtrlReserved21() { return (BLonBoolean)get(pumpCtrlReserved21); }
  
  /**
   * Set the <code>pumpCtrlReserved21</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved21
   */
  public void setPumpCtrlReserved21(BLonBoolean v) { set(pumpCtrlReserved21,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlRunning"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlRunning</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlRunning
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlRunning
   */
  public static final Property pumpCtrlRunning = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 5, 1, null) );
  
  /**
   * Get the <code>pumpCtrlRunning</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRunning
   */
  public BLonBoolean getPumpCtrlRunning() { return (BLonBoolean)get(pumpCtrlRunning); }
  
  /**
   * Set the <code>pumpCtrlRunning</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRunning
   */
  public void setPumpCtrlRunning(BLonBoolean v) { set(pumpCtrlRunning,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved23"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved23</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlReserved23
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlReserved23
   */
  public static final Property pumpCtrlReserved23 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 4, 1, null) );
  
  /**
   * Get the <code>pumpCtrlReserved23</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved23
   */
  public BLonBoolean getPumpCtrlReserved23() { return (BLonBoolean)get(pumpCtrlReserved23); }
  
  /**
   * Set the <code>pumpCtrlReserved23</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved23
   */
  public void setPumpCtrlReserved23(BLonBoolean v) { set(pumpCtrlReserved23,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlRemotePress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlRemotePress</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlRemotePress
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlRemotePress
   */
  public static final Property pumpCtrlRemotePress = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 3, 1, null) );
  
  /**
   * Get the <code>pumpCtrlRemotePress</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRemotePress
   */
  public BLonBoolean getPumpCtrlRemotePress() { return (BLonBoolean)get(pumpCtrlRemotePress); }
  
  /**
   * Set the <code>pumpCtrlRemotePress</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRemotePress
   */
  public void setPumpCtrlRemotePress(BLonBoolean v) { set(pumpCtrlRemotePress,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlRemoteFlow"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlRemoteFlow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlRemoteFlow
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlRemoteFlow
   */
  public static final Property pumpCtrlRemoteFlow = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 2, 1, null) );
  
  /**
   * Get the <code>pumpCtrlRemoteFlow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRemoteFlow
   */
  public BLonBoolean getPumpCtrlRemoteFlow() { return (BLonBoolean)get(pumpCtrlRemoteFlow); }
  
  /**
   * Set the <code>pumpCtrlRemoteFlow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRemoteFlow
   */
  public void setPumpCtrlRemoteFlow(BLonBoolean v) { set(pumpCtrlRemoteFlow,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlRemoteTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlRemoteTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlRemoteTemp
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlRemoteTemp
   */
  public static final Property pumpCtrlRemoteTemp = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 1, 1, null) );
  
  /**
   * Get the <code>pumpCtrlRemoteTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRemoteTemp
   */
  public BLonBoolean getPumpCtrlRemoteTemp() { return (BLonBoolean)get(pumpCtrlRemoteTemp); }
  
  /**
   * Set the <code>pumpCtrlRemoteTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlRemoteTemp
   */
  public void setPumpCtrlRemoteTemp(BLonBoolean v) { set(pumpCtrlRemoteTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved27"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved27</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlReserved27
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlReserved27
   */
  public static final Property pumpCtrlReserved27 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 0, 1, null) );
  
  /**
   * Get the <code>pumpCtrlReserved27</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved27
   */
  public BLonBoolean getPumpCtrlReserved27() { return (BLonBoolean)get(pumpCtrlReserved27); }
  
  /**
   * Set the <code>pumpCtrlReserved27</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved27
   */
  public void setPumpCtrlReserved27(BLonBoolean v) { set(pumpCtrlReserved27,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved307"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getPumpCtrlReserved307
   * @see javax.baja.lonworks.londata.BLonDevStatus#setPumpCtrlReserved307
   */
  public static final Property pumpCtrlReserved307 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) );
  
  /**
   * Get the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved307
   */
  public BLonFloat getPumpCtrlReserved307() { return (BLonFloat)get(pumpCtrlReserved307); }
  
  /**
   * Set the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#pumpCtrlReserved307
   */
  public void setPumpCtrlReserved307(BLonFloat v) { set(pumpCtrlReserved307,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosRunning"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosRunning</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosRunning
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosRunning
   */
  public static final Property valvePosRunning = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) );
  
  /**
   * Get the <code>valvePosRunning</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosRunning
   */
  public BLonBoolean getValvePosRunning() { return (BLonBoolean)get(valvePosRunning); }
  
  /**
   * Set the <code>valvePosRunning</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosRunning
   */
  public void setValvePosRunning(BLonBoolean v) { set(valvePosRunning,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosAdapting"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosAdapting</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosAdapting
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosAdapting
   */
  public static final Property valvePosAdapting = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) );
  
  /**
   * Get the <code>valvePosAdapting</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosAdapting
   */
  public BLonBoolean getValvePosAdapting() { return (BLonBoolean)get(valvePosAdapting); }
  
  /**
   * Set the <code>valvePosAdapting</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosAdapting
   */
  public void setValvePosAdapting(BLonBoolean v) { set(valvePosAdapting,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosInitializing"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosInitializing</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosInitializing
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosInitializing
   */
  public static final Property valvePosInitializing = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) );
  
  /**
   * Get the <code>valvePosInitializing</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosInitializing
   */
  public BLonBoolean getValvePosInitializing() { return (BLonBoolean)get(valvePosInitializing); }
  
  /**
   * Set the <code>valvePosInitializing</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosInitializing
   */
  public void setValvePosInitializing(BLonBoolean v) { set(valvePosInitializing,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosLocalControl"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosLocalControl</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosLocalControl
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosLocalControl
   */
  public static final Property valvePosLocalControl = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) );
  
  /**
   * Get the <code>valvePosLocalControl</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosLocalControl
   */
  public BLonBoolean getValvePosLocalControl() { return (BLonBoolean)get(valvePosLocalControl); }
  
  /**
   * Set the <code>valvePosLocalControl</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosLocalControl
   */
  public void setValvePosLocalControl(BLonBoolean v) { set(valvePosLocalControl,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosSetptOutOfRange"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosSetptOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosSetptOutOfRange
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosSetptOutOfRange
   */
  public static final Property valvePosSetptOutOfRange = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) );
  
  /**
   * Get the <code>valvePosSetptOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosSetptOutOfRange
   */
  public BLonBoolean getValvePosSetptOutOfRange() { return (BLonBoolean)get(valvePosSetptOutOfRange); }
  
  /**
   * Set the <code>valvePosSetptOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosSetptOutOfRange
   */
  public void setValvePosSetptOutOfRange(BLonBoolean v) { set(valvePosSetptOutOfRange,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosRemoteCtrlSignal"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosRemoteCtrlSignal</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosRemoteCtrlSignal
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosRemoteCtrlSignal
   */
  public static final Property valvePosRemoteCtrlSignal = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) );
  
  /**
   * Get the <code>valvePosRemoteCtrlSignal</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosRemoteCtrlSignal
   */
  public BLonBoolean getValvePosRemoteCtrlSignal() { return (BLonBoolean)get(valvePosRemoteCtrlSignal); }
  
  /**
   * Set the <code>valvePosRemoteCtrlSignal</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosRemoteCtrlSignal
   */
  public void setValvePosRemoteCtrlSignal(BLonBoolean v) { set(valvePosRemoteCtrlSignal,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved167"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved167</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosReserved167
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosReserved167
   */
  public static final Property valvePosReserved167 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 1, 0, false, 0F, 2, null) );
  
  /**
   * Get the <code>valvePosReserved167</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosReserved167
   */
  public BLonFloat getValvePosReserved167() { return (BLonFloat)get(valvePosReserved167); }
  
  /**
   * Set the <code>valvePosReserved167</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosReserved167
   */
  public void setValvePosReserved167(BLonFloat v) { set(valvePosReserved167,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosHwEmergency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosHwEmergency</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosHwEmergency
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosHwEmergency
   */
  public static final Property valvePosHwEmergency = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 7, 1, null) );
  
  /**
   * Get the <code>valvePosHwEmergency</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosHwEmergency
   */
  public BLonBoolean getValvePosHwEmergency() { return (BLonBoolean)get(valvePosHwEmergency); }
  
  /**
   * Set the <code>valvePosHwEmergency</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosHwEmergency
   */
  public void setValvePosHwEmergency(BLonBoolean v) { set(valvePosHwEmergency,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosSwEmergency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosSwEmergency</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosSwEmergency
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosSwEmergency
   */
  public static final Property valvePosSwEmergency = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 6, 1, null) );
  
  /**
   * Get the <code>valvePosSwEmergency</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosSwEmergency
   */
  public BLonBoolean getValvePosSwEmergency() { return (BLonBoolean)get(valvePosSwEmergency); }
  
  /**
   * Set the <code>valvePosSwEmergency</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosSwEmergency
   */
  public void setValvePosSwEmergency(BLonBoolean v) { set(valvePosSwEmergency,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved227"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved227</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosReserved227
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosReserved227
   */
  public static final Property valvePosReserved227 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 2, 0, false, 0F, 6, null) );
  
  /**
   * Get the <code>valvePosReserved227</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosReserved227
   */
  public BLonFloat getValvePosReserved227() { return (BLonFloat)get(valvePosReserved227); }
  
  /**
   * Set the <code>valvePosReserved227</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosReserved227
   */
  public void setValvePosReserved227(BLonFloat v) { set(valvePosReserved227,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved307"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#getValvePosReserved307
   * @see javax.baja.lonworks.londata.BLonDevStatus#setValvePosReserved307
   */
  public static final Property valvePosReserved307 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) );
  
  /**
   * Get the <code>valvePosReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosReserved307
   */
  public BLonFloat getValvePosReserved307() { return (BLonFloat)get(valvePosReserved307); }
  
  /**
   * Set the <code>valvePosReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevStatus#valvePosReserved307
   */
  public void setValvePosReserved307(BLonFloat v) { set(valvePosReserved307,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonDevStatus.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
   
  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(deviceSelect      , out);

    int f = getDeviceSelect().getEnum().getOrdinal();
    if(f == BLonDeviceSelectEnum.DV_PUMP_CTRL)
    {
      primitiveToOutputStream(pumpCtrlDeviceFault         , out);
      primitiveToOutputStream(pumpCtrlSupplyFault         , out);
      primitiveToOutputStream(pumpCtrlReserved12          , out);
      primitiveToOutputStream(pumpCtrlSpeedLow            , out);
      primitiveToOutputStream(pumpCtrlSpeedHigh           , out);
      primitiveToOutputStream(pumpCtrlReserved15          , out);
      primitiveToOutputStream(pumpCtrlSetptOutOfRange     , out);
      primitiveToOutputStream(pumpCtrlReserved17          , out);
      primitiveToOutputStream(pumpCtrlLocalControl        , out);
      primitiveToOutputStream(pumpCtrlReserved21          , out);
      primitiveToOutputStream(pumpCtrlRunning             , out);
      primitiveToOutputStream(pumpCtrlReserved23          , out);
      primitiveToOutputStream(pumpCtrlRemotePress         , out);
      primitiveToOutputStream(pumpCtrlRemoteFlow          , out);
      primitiveToOutputStream(pumpCtrlRemoteTemp          , out);
      primitiveToOutputStream(pumpCtrlReserved27          , out);
      primitiveToOutputStream(pumpCtrlReserved307         , out);
    }  
    else
    {
      primitiveToOutputStream(valvePosRunning               , out);
      primitiveToOutputStream(valvePosAdapting              , out);
      primitiveToOutputStream(valvePosInitializing          , out);
      primitiveToOutputStream(valvePosLocalControl          , out);
      primitiveToOutputStream(valvePosSetptOutOfRange       , out);
      primitiveToOutputStream(valvePosRemoteCtrlSignal      , out);
      primitiveToOutputStream(valvePosReserved167           , out);
      primitiveToOutputStream(valvePosHwEmergency           , out);
      primitiveToOutputStream(valvePosSwEmergency           , out);
      primitiveToOutputStream(valvePosReserved227           , out);
      primitiveToOutputStream(valvePosReserved307           , out);
    }  
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(deviceSelect     , in);
    
    int f = getDeviceSelect().getEnum().getOrdinal();
    if(f == BLonDeviceSelectEnum.DV_PUMP_CTRL)
    {
      primitiveFromInputStream(pumpCtrlDeviceFault    , in);
      primitiveFromInputStream(pumpCtrlSupplyFault    , in);
      primitiveFromInputStream(pumpCtrlReserved12     , in);
      primitiveFromInputStream(pumpCtrlSpeedLow       , in);
      primitiveFromInputStream(pumpCtrlSpeedHigh      , in);
      primitiveFromInputStream(pumpCtrlReserved15     , in);
      primitiveFromInputStream(pumpCtrlSetptOutOfRange, in);
      primitiveFromInputStream(pumpCtrlReserved17     , in);
      primitiveFromInputStream(pumpCtrlLocalControl   , in);
      primitiveFromInputStream(pumpCtrlReserved21     , in);
      primitiveFromInputStream(pumpCtrlRunning        , in);
      primitiveFromInputStream(pumpCtrlReserved23     , in);
      primitiveFromInputStream(pumpCtrlRemotePress    , in);
      primitiveFromInputStream(pumpCtrlRemoteFlow     , in);
      primitiveFromInputStream(pumpCtrlRemoteTemp     , in);
      primitiveFromInputStream(pumpCtrlReserved27     , in);
      primitiveFromInputStream(pumpCtrlReserved307    , in);
    }
    else
    {
      primitiveFromInputStream(valvePosRunning            , in);
      primitiveFromInputStream(valvePosAdapting           , in);
      primitiveFromInputStream(valvePosInitializing       , in);
      primitiveFromInputStream(valvePosLocalControl       , in);
      primitiveFromInputStream(valvePosSetptOutOfRange    , in);
      primitiveFromInputStream(valvePosRemoteCtrlSignal   , in);
      primitiveFromInputStream(valvePosReserved167        , in);
      primitiveFromInputStream(valvePosHwEmergency        , in);
      primitiveFromInputStream(valvePosSwEmergency        , in);
      primitiveFromInputStream(valvePosReserved227        , in);
      primitiveFromInputStream(valvePosReserved307        , in);
    }
  }  


}      