/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonDeviceSelectEnum;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_dev_maint.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  4 Sept 01
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonDevMaint
  extends BLonData
{  
  /*
 <DevMaint type="XTypeDef">
  <elem n="deviceSelect" qual="e8" enumDef="DeviceSelectT"/>
  <elem n="pumpCtrlServiceRequired   " qual="ub byt=1 bit=7 len=1"/>
  <elem n="pumpCtrlBearingsChange    " qual="ub byt=1 bit=6 len=1"/>
  <elem n="pumpCtrlBearingsLubricate " qual="ub byt=1 bit=5 len=1"/>
  <elem n="pumpCtrlShaftsealChange   " qual="ub byt=1 bit=4 len=1"/>
  <elem n="pumpCtrlReserved147       " qual="ub byt=1 bit=0 len=4"/>
  <elem n="pumpCtrlReserved207       " qual="ub byt=2 bit=0 len=8"/>
  <elem n="pumpCtrlReserved307       " qual="ub byt=3 bit=0 len=8"/>
  <elem n="valvePosMotorMaint        " qual="ub byt=1 bit=7 len=1"/>
  <elem n="valvePosPackingChange     " qual="ub byt=1 bit=6 len=1"/>
  <elem n="valvePosElectronicsCheck  " qual="ub byt=1 bit=5 len=1"/>
  <elem n="valvePosPositioningCheck  " qual="ub byt=1 bit=4 len=1"/>
  <elem n="valvePosLubricationCheck  " qual="ub byt=1 bit=3 len=1"/>
  <elem n="valvePosReturnCheck       " qual="ub byt=1 bit=2 len=1"/>
  <elem n="valvePosBatteryCheck      " qual="ub byt=1 bit=1 len=1"/>
  <elem n="valvePosReserved17        " qual="ub byt=1 bit=0 len=1"/>
  <elem n="valvePosReserved207       " qual="ub byt=2 bit=0 len=8"/>
  <elem n="valvePosReserved306       " qual="ub byt=3 bit=1 len=7"/>
  <elem n="valvePosGeneralMaint      " qual="ub byt=3 bit=0 len=1"/>
  <typeScope v="0,175"/>
 </DevMaint>
  */

  /*-

  class BLonDevMaint
  {
    properties
    {
      deviceSelect     : BLonEnum   default {[ BLonEnum.make(BLonDeviceSelectEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      pumpCtrlServiceRequired  : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) ]}
      pumpCtrlBearingsChange   : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) ]}
      pumpCtrlBearingsLubricate: BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) ]}
      pumpCtrlShaftsealChange  : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) ]}
      pumpCtrlReserved147      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 1, 0, 4, null) ]}
      pumpCtrlReserved207      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 0, 8, null) ]}
      pumpCtrlReserved307      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) ]}
      valvePosMotorMaint       : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) ]}
      valvePosPackingChange    : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) ]}
      valvePosElectronicsCheck : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) ]}
      valvePosPositioningCheck : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) ]}
      valvePosLubricationCheck : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) ]}
      valvePosReturnCheck      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) ]}
      valvePosBatteryCheck     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) ]}
      valvePosReserved17       : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) ]}
      valvePosReserved207      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 0, 8, null) ]}
      valvePosReserved306      : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 1, 7, null) ]}
      valvePosGeneralMaint     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 0, 1, null) ]}
    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonDevMaint(3972839874)1.0$ @*/
/* Generated Thu Nov 09 16:35:06 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceSelect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getDeviceSelect
   * @see javax.baja.lonworks.londata.BLonDevMaint#setDeviceSelect
   */
  public static final Property deviceSelect = newProperty(0, BLonEnum.make(BLonDeviceSelectEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#deviceSelect
   */
  public BLonEnum getDeviceSelect() { return (BLonEnum)get(deviceSelect); }
  
  /**
   * Set the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#deviceSelect
   */
  public void setDeviceSelect(BLonEnum v) { set(deviceSelect,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlServiceRequired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlServiceRequired</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getPumpCtrlServiceRequired
   * @see javax.baja.lonworks.londata.BLonDevMaint#setPumpCtrlServiceRequired
   */
  public static final Property pumpCtrlServiceRequired = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) );
  
  /**
   * Get the <code>pumpCtrlServiceRequired</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlServiceRequired
   */
  public BLonBoolean getPumpCtrlServiceRequired() { return (BLonBoolean)get(pumpCtrlServiceRequired); }
  
  /**
   * Set the <code>pumpCtrlServiceRequired</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlServiceRequired
   */
  public void setPumpCtrlServiceRequired(BLonBoolean v) { set(pumpCtrlServiceRequired,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlBearingsChange"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlBearingsChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getPumpCtrlBearingsChange
   * @see javax.baja.lonworks.londata.BLonDevMaint#setPumpCtrlBearingsChange
   */
  public static final Property pumpCtrlBearingsChange = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) );
  
  /**
   * Get the <code>pumpCtrlBearingsChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlBearingsChange
   */
  public BLonBoolean getPumpCtrlBearingsChange() { return (BLonBoolean)get(pumpCtrlBearingsChange); }
  
  /**
   * Set the <code>pumpCtrlBearingsChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlBearingsChange
   */
  public void setPumpCtrlBearingsChange(BLonBoolean v) { set(pumpCtrlBearingsChange,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlBearingsLubricate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlBearingsLubricate</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getPumpCtrlBearingsLubricate
   * @see javax.baja.lonworks.londata.BLonDevMaint#setPumpCtrlBearingsLubricate
   */
  public static final Property pumpCtrlBearingsLubricate = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) );
  
  /**
   * Get the <code>pumpCtrlBearingsLubricate</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlBearingsLubricate
   */
  public BLonBoolean getPumpCtrlBearingsLubricate() { return (BLonBoolean)get(pumpCtrlBearingsLubricate); }
  
  /**
   * Set the <code>pumpCtrlBearingsLubricate</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlBearingsLubricate
   */
  public void setPumpCtrlBearingsLubricate(BLonBoolean v) { set(pumpCtrlBearingsLubricate,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlShaftsealChange"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlShaftsealChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getPumpCtrlShaftsealChange
   * @see javax.baja.lonworks.londata.BLonDevMaint#setPumpCtrlShaftsealChange
   */
  public static final Property pumpCtrlShaftsealChange = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) );
  
  /**
   * Get the <code>pumpCtrlShaftsealChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlShaftsealChange
   */
  public BLonBoolean getPumpCtrlShaftsealChange() { return (BLonBoolean)get(pumpCtrlShaftsealChange); }
  
  /**
   * Set the <code>pumpCtrlShaftsealChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlShaftsealChange
   */
  public void setPumpCtrlShaftsealChange(BLonBoolean v) { set(pumpCtrlShaftsealChange,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved147"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved147</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getPumpCtrlReserved147
   * @see javax.baja.lonworks.londata.BLonDevMaint#setPumpCtrlReserved147
   */
  public static final Property pumpCtrlReserved147 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 1, 0, 4, null) );
  
  /**
   * Get the <code>pumpCtrlReserved147</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlReserved147
   */
  public BLonFloat getPumpCtrlReserved147() { return (BLonFloat)get(pumpCtrlReserved147); }
  
  /**
   * Set the <code>pumpCtrlReserved147</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlReserved147
   */
  public void setPumpCtrlReserved147(BLonFloat v) { set(pumpCtrlReserved147,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved207"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved207</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getPumpCtrlReserved207
   * @see javax.baja.lonworks.londata.BLonDevMaint#setPumpCtrlReserved207
   */
  public static final Property pumpCtrlReserved207 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 0, 8, null) );
  
  /**
   * Get the <code>pumpCtrlReserved207</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlReserved207
   */
  public BLonFloat getPumpCtrlReserved207() { return (BLonFloat)get(pumpCtrlReserved207); }
  
  /**
   * Set the <code>pumpCtrlReserved207</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlReserved207
   */
  public void setPumpCtrlReserved207(BLonFloat v) { set(pumpCtrlReserved207,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved307"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getPumpCtrlReserved307
   * @see javax.baja.lonworks.londata.BLonDevMaint#setPumpCtrlReserved307
   */
  public static final Property pumpCtrlReserved307 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) );
  
  /**
   * Get the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlReserved307
   */
  public BLonFloat getPumpCtrlReserved307() { return (BLonFloat)get(pumpCtrlReserved307); }
  
  /**
   * Set the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#pumpCtrlReserved307
   */
  public void setPumpCtrlReserved307(BLonFloat v) { set(pumpCtrlReserved307,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosMotorMaint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosMotorMaint</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosMotorMaint
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosMotorMaint
   */
  public static final Property valvePosMotorMaint = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) );
  
  /**
   * Get the <code>valvePosMotorMaint</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosMotorMaint
   */
  public BLonBoolean getValvePosMotorMaint() { return (BLonBoolean)get(valvePosMotorMaint); }
  
  /**
   * Set the <code>valvePosMotorMaint</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosMotorMaint
   */
  public void setValvePosMotorMaint(BLonBoolean v) { set(valvePosMotorMaint,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosPackingChange"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosPackingChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosPackingChange
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosPackingChange
   */
  public static final Property valvePosPackingChange = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) );
  
  /**
   * Get the <code>valvePosPackingChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosPackingChange
   */
  public BLonBoolean getValvePosPackingChange() { return (BLonBoolean)get(valvePosPackingChange); }
  
  /**
   * Set the <code>valvePosPackingChange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosPackingChange
   */
  public void setValvePosPackingChange(BLonBoolean v) { set(valvePosPackingChange,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosElectronicsCheck"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosElectronicsCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosElectronicsCheck
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosElectronicsCheck
   */
  public static final Property valvePosElectronicsCheck = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) );
  
  /**
   * Get the <code>valvePosElectronicsCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosElectronicsCheck
   */
  public BLonBoolean getValvePosElectronicsCheck() { return (BLonBoolean)get(valvePosElectronicsCheck); }
  
  /**
   * Set the <code>valvePosElectronicsCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosElectronicsCheck
   */
  public void setValvePosElectronicsCheck(BLonBoolean v) { set(valvePosElectronicsCheck,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosPositioningCheck"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosPositioningCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosPositioningCheck
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosPositioningCheck
   */
  public static final Property valvePosPositioningCheck = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) );
  
  /**
   * Get the <code>valvePosPositioningCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosPositioningCheck
   */
  public BLonBoolean getValvePosPositioningCheck() { return (BLonBoolean)get(valvePosPositioningCheck); }
  
  /**
   * Set the <code>valvePosPositioningCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosPositioningCheck
   */
  public void setValvePosPositioningCheck(BLonBoolean v) { set(valvePosPositioningCheck,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosLubricationCheck"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosLubricationCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosLubricationCheck
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosLubricationCheck
   */
  public static final Property valvePosLubricationCheck = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) );
  
  /**
   * Get the <code>valvePosLubricationCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosLubricationCheck
   */
  public BLonBoolean getValvePosLubricationCheck() { return (BLonBoolean)get(valvePosLubricationCheck); }
  
  /**
   * Set the <code>valvePosLubricationCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosLubricationCheck
   */
  public void setValvePosLubricationCheck(BLonBoolean v) { set(valvePosLubricationCheck,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReturnCheck"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReturnCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosReturnCheck
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosReturnCheck
   */
  public static final Property valvePosReturnCheck = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) );
  
  /**
   * Get the <code>valvePosReturnCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReturnCheck
   */
  public BLonBoolean getValvePosReturnCheck() { return (BLonBoolean)get(valvePosReturnCheck); }
  
  /**
   * Set the <code>valvePosReturnCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReturnCheck
   */
  public void setValvePosReturnCheck(BLonBoolean v) { set(valvePosReturnCheck,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosBatteryCheck"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosBatteryCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosBatteryCheck
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosBatteryCheck
   */
  public static final Property valvePosBatteryCheck = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) );
  
  /**
   * Get the <code>valvePosBatteryCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosBatteryCheck
   */
  public BLonBoolean getValvePosBatteryCheck() { return (BLonBoolean)get(valvePosBatteryCheck); }
  
  /**
   * Set the <code>valvePosBatteryCheck</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosBatteryCheck
   */
  public void setValvePosBatteryCheck(BLonBoolean v) { set(valvePosBatteryCheck,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved17"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosReserved17
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosReserved17
   */
  public static final Property valvePosReserved17 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) );
  
  /**
   * Get the <code>valvePosReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReserved17
   */
  public BLonBoolean getValvePosReserved17() { return (BLonBoolean)get(valvePosReserved17); }
  
  /**
   * Set the <code>valvePosReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReserved17
   */
  public void setValvePosReserved17(BLonBoolean v) { set(valvePosReserved17,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved207"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved207</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosReserved207
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosReserved207
   */
  public static final Property valvePosReserved207 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 0, 8, null) );
  
  /**
   * Get the <code>valvePosReserved207</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReserved207
   */
  public BLonFloat getValvePosReserved207() { return (BLonFloat)get(valvePosReserved207); }
  
  /**
   * Set the <code>valvePosReserved207</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReserved207
   */
  public void setValvePosReserved207(BLonFloat v) { set(valvePosReserved207,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved306"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved306</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosReserved306
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosReserved306
   */
  public static final Property valvePosReserved306 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 1, 7, null) );
  
  /**
   * Get the <code>valvePosReserved306</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReserved306
   */
  public BLonFloat getValvePosReserved306() { return (BLonFloat)get(valvePosReserved306); }
  
  /**
   * Set the <code>valvePosReserved306</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosReserved306
   */
  public void setValvePosReserved306(BLonFloat v) { set(valvePosReserved306,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosGeneralMaint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosGeneralMaint</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#getValvePosGeneralMaint
   * @see javax.baja.lonworks.londata.BLonDevMaint#setValvePosGeneralMaint
   */
  public static final Property valvePosGeneralMaint = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 0, 1, null) );
  
  /**
   * Get the <code>valvePosGeneralMaint</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosGeneralMaint
   */
  public BLonBoolean getValvePosGeneralMaint() { return (BLonBoolean)get(valvePosGeneralMaint); }
  
  /**
   * Set the <code>valvePosGeneralMaint</code> property.
   * @see javax.baja.lonworks.londata.BLonDevMaint#valvePosGeneralMaint
   */
  public void setValvePosGeneralMaint(BLonBoolean v) { set(valvePosGeneralMaint,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonDevMaint.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(deviceSelect      , out);

    int f = getDeviceSelect().getEnum().getOrdinal();
    if(f == BLonDeviceSelectEnum.DV_PUMP_CTRL)
    {
      primitiveToOutputStream(pumpCtrlServiceRequired   , out);
      primitiveToOutputStream(pumpCtrlBearingsChange    , out);
      primitiveToOutputStream(pumpCtrlBearingsLubricate , out);
      primitiveToOutputStream(pumpCtrlShaftsealChange   , out);
      primitiveToOutputStream(pumpCtrlReserved147       , out);
      primitiveToOutputStream(pumpCtrlReserved207       , out);
      primitiveToOutputStream(pumpCtrlReserved307       , out);
    }  
    else
    {
      primitiveToOutputStream(valvePosMotorMaint       , out);
      primitiveToOutputStream(valvePosPackingChange    , out);
      primitiveToOutputStream(valvePosElectronicsCheck , out);
      primitiveToOutputStream(valvePosPositioningCheck , out);
      primitiveToOutputStream(valvePosLubricationCheck , out);
      primitiveToOutputStream(valvePosReturnCheck      , out);
      primitiveToOutputStream(valvePosBatteryCheck     , out);
      primitiveToOutputStream(valvePosReserved17       , out);
      primitiveToOutputStream(valvePosReserved207      , out);
      primitiveToOutputStream(valvePosReserved306      , out);
      primitiveToOutputStream(valvePosGeneralMaint     , out);
    }  
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(deviceSelect     , in);
    
    int f = getDeviceSelect().getEnum().getOrdinal();
    if(f == BLonDeviceSelectEnum.DV_PUMP_CTRL)
    {
      primitiveFromInputStream(pumpCtrlServiceRequired   , in);
      primitiveFromInputStream(pumpCtrlBearingsChange    , in);
      primitiveFromInputStream(pumpCtrlBearingsLubricate , in);
      primitiveFromInputStream(pumpCtrlShaftsealChange   , in);
      primitiveFromInputStream(pumpCtrlReserved147       , in);
      primitiveFromInputStream(pumpCtrlReserved207       , in);
      primitiveFromInputStream(pumpCtrlReserved307       , in);
    }
    else
    {
      primitiveFromInputStream(valvePosMotorMaint       , in);
      primitiveFromInputStream(valvePosPackingChange    , in);
      primitiveFromInputStream(valvePosElectronicsCheck , in);
      primitiveFromInputStream(valvePosPositioningCheck , in);
      primitiveFromInputStream(valvePosLubricationCheck , in);
      primitiveFromInputStream(valvePosReturnCheck      , in);
      primitiveFromInputStream(valvePosBatteryCheck     , in);
      primitiveFromInputStream(valvePosReserved17       , in);
      primitiveFromInputStream(valvePosReserved207      , in);
      primitiveFromInputStream(valvePosReserved306      , in);
      primitiveFromInputStream(valvePosGeneralMaint     , in);
    }
  }  


}      