/*
 * Copyright 2010 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.datatypes.BUnionQualifiers;
import javax.baja.sys.*;

/**
 * The BLonDataUnion contains support for BLonData which
 * has a union in its type definition. 
 * <p>
 *
 * @author    Robert Adams
 * @creation  5 May 01
 * @version   $Revision: 8$ $Date: 9/28/01 10:20:42 AM$
 * @since     Niagara 3.0
 */
public class BLonDataUnion
    extends BLonData
{
  /*-

  class BLonDataUnion
  {
    properties
    {
      unionQuals : BUnionQualifiers
        flags { hidden }
        default {[ new BUnionQualifiers() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonDataUnion(3510798124)1.0$ @*/
/* Generated Thu Jan 21 12:04:19 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "unionQuals"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unionQuals</code> property.
   * @see javax.baja.lonworks.londata.BLonDataUnion#getUnionQuals
   * @see javax.baja.lonworks.londata.BLonDataUnion#setUnionQuals
   */
  public static final Property unionQuals = newProperty(Flags.HIDDEN, new BUnionQualifiers(),null);
  
  /**
   * Get the <code>unionQuals</code> property.
   * @see javax.baja.lonworks.londata.BLonDataUnion#unionQuals
   */
  public BUnionQualifiers getUnionQuals() { return (BUnionQualifiers)get(unionQuals); }
  
  /**
   * Set the <code>unionQuals</code> property.
   * @see javax.baja.lonworks.londata.BLonDataUnion#unionQuals
   */
  public void setUnionQuals(BUnionQualifiers v) { set(unionQuals,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonDataUnion.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////
 
  /**
   *  Verify that the specified lonData has the same set of primitive
   *  data elements by type, qualifiers, and name. Will recurse  into
   *  nested datatypes.
   */
  public boolean hasEquivalentElements(BLonData ld)
  {
    if(!super.hasEquivalentElements(ld)) return false;
    if( !((BLonDataUnion)ld).getUnionQuals().equivalent(getUnionQuals()) ) return false;
    return true;
  }
  public boolean isUnion() { return true; }

////////////////////////////////////////////////////////////////
// Implementation
////////////////////////////////////////////////////////////////
  public Property[] getActiveProperties()
  {
    return getActiveProperties(get(getProperty(getUnionQuals().getConditionProp())));
  }

  public Property[] getActiveProperties(BObject condVal)
  {
    return getUnionQuals().getActiveProperties(condVal);
  }

  Property[] getActiveProps() { return getActiveProperties(); } 
}
