/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonControlRespEnum;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_ctrl_resp.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  4 Sept 01
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonCtrlResp
  extends BLonData
{  
  /*-

  class BLonCtrlResp
  {
    properties
    {
      status           : BLonEnum   default {[ BLonEnum.make(BLonControlRespEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      senderId         : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 1, 0, null) ]}
      senderRangeLower : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 1, 0, null) ]}
      senderRangeUpper : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 3, 0, null) ]}
      controllerId     : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 5, 0, null) ]}
    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonCtrlResp(4172416057)1.0$ @*/
/* Generated Mon Jan 25 10:18:11 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "status"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>status</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#getStatus
   * @see javax.baja.lonworks.londata.BLonCtrlResp#setStatus
   */
  public static final Property status = newProperty(0, BLonEnum.make(BLonControlRespEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null));
  
  /**
   * Get the <code>status</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#status
   */
  public BLonEnum getStatus() { return (BLonEnum)get(status); }
  
  /**
   * Set the <code>status</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#status
   */
  public void setStatus(BLonEnum v) { set(status,v,null); }

////////////////////////////////////////////////////////////////
// Property "senderId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>senderId</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#getSenderId
   * @see javax.baja.lonworks.londata.BLonCtrlResp#setSenderId
   */
  public static final Property senderId = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 1, 0, null));
  
  /**
   * Get the <code>senderId</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#senderId
   */
  public BLonFloat getSenderId() { return (BLonFloat)get(senderId); }
  
  /**
   * Set the <code>senderId</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#senderId
   */
  public void setSenderId(BLonFloat v) { set(senderId,v,null); }

////////////////////////////////////////////////////////////////
// Property "senderRangeLower"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>senderRangeLower</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#getSenderRangeLower
   * @see javax.baja.lonworks.londata.BLonCtrlResp#setSenderRangeLower
   */
  public static final Property senderRangeLower = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 1, 0, null));
  
  /**
   * Get the <code>senderRangeLower</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#senderRangeLower
   */
  public BLonFloat getSenderRangeLower() { return (BLonFloat)get(senderRangeLower); }
  
  /**
   * Set the <code>senderRangeLower</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#senderRangeLower
   */
  public void setSenderRangeLower(BLonFloat v) { set(senderRangeLower,v,null); }

////////////////////////////////////////////////////////////////
// Property "senderRangeUpper"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>senderRangeUpper</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#getSenderRangeUpper
   * @see javax.baja.lonworks.londata.BLonCtrlResp#setSenderRangeUpper
   */
  public static final Property senderRangeUpper = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 3, 0, null));
  
  /**
   * Get the <code>senderRangeUpper</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#senderRangeUpper
   */
  public BLonFloat getSenderRangeUpper() { return (BLonFloat)get(senderRangeUpper); }
  
  /**
   * Set the <code>senderRangeUpper</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#senderRangeUpper
   */
  public void setSenderRangeUpper(BLonFloat v) { set(senderRangeUpper,v,null); }

////////////////////////////////////////////////////////////////
// Property "controllerId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>controllerId</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#getControllerId
   * @see javax.baja.lonworks.londata.BLonCtrlResp#setControllerId
   */
  public static final Property controllerId = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16, 1, 65534, 1, 65535, 5, 0, null));
  
  /**
   * Get the <code>controllerId</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#controllerId
   */
  public BLonFloat getControllerId() { return (BLonFloat)get(controllerId); }
  
  /**
   * Set the <code>controllerId</code> property.
   * @see javax.baja.lonworks.londata.BLonCtrlResp#controllerId
   */
  public void setControllerId(BLonFloat v) { set(controllerId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonCtrlResp.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  /*
   *  Statement on union from SNVT Master List - May 2002
   *
   *  A union holds the logical id of the controllable device. For camera telemetry
   *  receivers this value is a fixed value configured prior to use.
   *
   *  For matrixes, this value holds the currently selected monitor, by the specified
   *  controller in the contoller_id field. The matrix is logically assigned by monitor
   *  range during configuration; thus, these values must be transmitted when the
   *  status is CTRLR_RES.
   *
   *  e.g., A matrix having the monitor range 1 to 16 must on reset send:
   *  sender.range.lower = 1
   *  sender.range.upper = 16
   */
   
  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(status          , out);
    
    int st = getStatus().getEnum().getOrdinal();
    if(st == BLonControlRespEnum.CTRLR_RES)
    {
      primitiveToOutputStream(senderRangeLower, out);
      primitiveToOutputStream(senderRangeUpper, out);
    }  
    else
    {
      primitiveToOutputStream(senderId        , out);
      out.writeUnsigned16(0);
    }  
    primitiveToOutputStream(controllerId    , out);
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(status          , in);

    int st = getStatus().getEnum().getOrdinal();
    if(st == BLonControlRespEnum.CTRLR_RES)
    {
      primitiveFromInputStream(senderRangeLower, in);
      primitiveFromInputStream(senderRangeUpper, in);
    }
    else
    {
      primitiveFromInputStream(senderId        , in);
      in.readUnsigned16();
    }  
    primitiveFromInputStream(controllerId    , in);
  }  

}