/*
 * Copyright 2000 Tridium Inc. All Rights Reserved.
 */
package javax.baja.lonworks.ext;

import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 *   The BLonPollService class provides a concrete class
 *  for polling lonworks devices.
 * <p>
 *
 * @author    Robert Adams
 * @creation  23 January 02
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:44 PM$
 * @since     Niagara 3.0
 */
public class BLonPollService
  extends BPollScheduler
{
  /*-

  class BLonPollService
  {
    properties
    {
    }
    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.ext.BLonPollService(948126352)1.0$ @*/
/* Generated Thu Feb 14 10:05:08 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonPollService.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Poll the specified point synchronously, blocking
   * until polled successfully or a failure is encountered.
   * Failures should throw an exception.
   */
  public void doPoll(BIPollable p)
    throws Exception
  {
    if( !((BLonNetwork)getParent()).isServiceRunning()) return;

    try
    {
      ((BNetworkVariable)p).pollNv();
    }
    catch(Throwable e)
    {
      // Failure of read already report - no need to pass this exception
    }
  }


}
