/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

// needed for main()
//import com.tridium.lonworks.util.NameUtil;
//import com.tridium.lonworks.xml.XLonInterfaceFile;
//import com.tridium.lonworks.xml.XTypeDef;
//
//import java.util.*;                  
//
//import javax.baja.lonworks.londata.BLonData;
//import javax.baja.lonworks.util.*;   // for main
//import com.tridium.lonworks.xml.*;   // for main

/**
 * The BLonSnvtType class provides an enumeration for 
 * all standard SNVT types
 *
 * @author    Robert Adams
 * @creation  14 Jan 01
 * @version   $Revision: 1$ $Date: 6/13/01 12:26:08 PM$
 * @since     Niagara 3.0
 */
public final class BLonSnvtType
  extends BFrozenEnum
//  implements BIHiddenEnums
{
////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////
  //  Extracted from standard.typ 10/31/03
  //////////////////////////////////////////////////////////////
  public static final int SNVT_XXX         = 0  ;
  public static final int SNVT_AMP         = 1  ;
  public static final int SNVT_AMP_MIL     = 2  ;
  public static final int SNVT_ANGLE       = 3  ;
  public static final int SNVT_ANGLE_VEL   = 4  ;
  public static final int SNVT_BTU_KILO    = 5  ;
  public static final int SNVT_BTU_MEGA    = 6  ;
  public static final int SNVT_CHAR_ASCII  = 7  ;
  public static final int SNVT_COUNT       = 8  ;
  public static final int SNVT_COUNT_INC   = 9  ;
  public static final int SNVT_DATE_CAL    = 10  ;
  public static final int SNVT_DATE_DAY    = 11  ;
  public static final int SNVT_DATE_TIME   = 12  ;
  public static final int SNVT_ELEC_KWH    = 13  ;
  public static final int SNVT_ELEC_WHR    = 14  ;
  public static final int SNVT_FLOW        = 15  ;
  public static final int SNVT_FLOW_MIL    = 16  ;
  public static final int SNVT_LENGTH      = 17  ;
  public static final int SNVT_LENGTH_KILO = 18  ;
  public static final int SNVT_LENGTH_MICR = 19  ;
  public static final int SNVT_LENGTH_MIL  = 20  ;
  public static final int SNVT_LEV_CONT    = 21  ;
  public static final int SNVT_LEV_DISC    = 22  ;
  public static final int SNVT_MASS        = 23  ;
  public static final int SNVT_MASS_KILO   = 24  ;
  public static final int SNVT_MASS_MEGA   = 25  ;
  public static final int SNVT_MASS_MIL    = 26  ;
  public static final int SNVT_POWER       = 27  ;
  public static final int SNVT_POWER_KILO  = 28  ;
  public static final int SNVT_PPM         = 29  ;
  public static final int SNVT_PRESS       = 30  ;
  public static final int SNVT_RES         = 31  ;
  public static final int SNVT_RES_KILO    = 32  ;
  public static final int SNVT_SOUND_DB    = 33  ;
  public static final int SNVT_SPEED       = 34  ;
  public static final int SNVT_SPEED_MIL   = 35  ;
  public static final int SNVT_STR_ASC     = 36  ;
  public static final int SNVT_STR_INT     = 37  ;
  public static final int SNVT_TELCOM      = 38  ;
  public static final int SNVT_TEMP        = 39  ;
  public static final int SNVT_TIME_PASSED = 40  ;
  public static final int SNVT_VOL         = 41  ;
  public static final int SNVT_VOL_KILO    = 42  ;
  public static final int SNVT_VOL_MIL     = 43  ;
  public static final int SNVT_VOLT        = 44  ;
  public static final int SNVT_VOLT_DBMV   = 45  ;
  public static final int SNVT_VOLT_KILO   = 46  ;
  public static final int SNVT_VOLT_MIL    = 47  ;
  public static final int SNVT_AMP_F       = 48  ;
  public static final int SNVT_ANGLE_F     = 49  ;
  public static final int SNVT_ANGLE_VEL_F = 50  ;
  public static final int SNVT_COUNT_F     = 51  ;
  public static final int SNVT_COUNT_INC_F = 52  ;
  public static final int SNVT_FLOW_F      = 53  ;
  public static final int SNVT_LENGTH_F    = 54  ;
  public static final int SNVT_LEV_CONT_F  = 55  ;
  public static final int SNVT_MASS_F      = 56  ;
  public static final int SNVT_POWER_F     = 57  ;
  public static final int SNVT_PPM_F       = 58  ;
  public static final int SNVT_PRESS_F     = 59  ;
  public static final int SNVT_RES_F       = 60  ;
  public static final int SNVT_SOUND_DB_F  = 61  ;
  public static final int SNVT_SPEED_F     = 62  ;
  public static final int SNVT_TEMP_F      = 63  ;
  public static final int SNVT_TIME_F      = 64  ;
  public static final int SNVT_VOL_F       = 65  ;
  public static final int SNVT_VOLT_F      = 66  ;
  public static final int SNVT_BTU_F       = 67  ;
  public static final int SNVT_ELEC_WHR_F  = 68  ;
  public static final int SNVT_CONFIG_SRC  = 69  ;
  public static final int SNVT_COLOR       = 70  ;
  public static final int SNVT_GRAMMAGE    = 71  ;
  public static final int SNVT_GRAMMAGE_F  = 72  ;
  public static final int SNVT_FILE_REQ    = 73  ;
  public static final int SNVT_FILE_STATUS = 74  ;
  public static final int SNVT_FREQ_F      = 75  ;
  public static final int SNVT_FREQ_HZ     = 76  ;
  public static final int SNVT_FREQ_KILOHZ = 77  ;
  public static final int SNVT_FREQ_MILHZ  = 78  ;
  public static final int SNVT_LUX         = 79  ;
  public static final int SNVT_ISO_7811    = 80  ;
  public static final int SNVT_LEV_PERCENT = 81  ;
  public static final int SNVT_MULTIPLIER  = 82  ;
  public static final int SNVT_STATE       = 83  ;
  public static final int SNVT_TIME_STAMP  = 84  ;
  public static final int SNVT_ZEROSPAN    = 85  ;
  public static final int SNVT_MAGCARD     = 86  ;
  public static final int SNVT_ELAPSED_TM  = 87  ;
  public static final int SNVT_ALARM       = 88  ;
  public static final int SNVT_CURRENCY    = 89  ;
  public static final int SNVT_FILE_POS    = 90  ;
  public static final int SNVT_MULDIV      = 91  ;
  public static final int SNVT_OBJ_REQUEST = 92  ;
  public static final int SNVT_OBJ_STATUS  = 93  ;
  public static final int SNVT_PRESET      = 94  ;
  public static final int SNVT_SWITCH      = 95  ;
  public static final int SNVT_TRANS_TABLE = 96  ;
  public static final int SNVT_OVERRIDE    = 97  ;
  public static final int SNVT_PWR_FACT    = 98  ;
  public static final int SNVT_PWR_FACT_F  = 99  ;
  public static final int SNVT_DENSITY     = 100  ;
  public static final int SNVT_DENSITY_F   = 101  ;
  public static final int SNVT_RPM         = 102  ;
  public static final int SNVT_HVAC_EMERG  = 103  ;
  public static final int SNVT_ANGLE_DEG   = 104  ;
  public static final int SNVT_TEMP_P      = 105  ;
  public static final int SNVT_TEMP_SETPT  = 106  ;
  public static final int SNVT_TIME_SEC    = 107  ;
  public static final int SNVT_HVAC_MODE   = 108  ;
  public static final int SNVT_OCCUPANCY   = 109  ;
  public static final int SNVT_AREA        = 110  ;
  public static final int SNVT_HVAC_OVERID = 111  ;
  public static final int SNVT_HVAC_STATUS = 112  ;
  public static final int SNVT_PRESS_P     = 113  ;
  public static final int SNVT_ADDRESS     = 114  ;
  public static final int SNVT_SCENE       = 115  ;
  public static final int SNVT_SCENE_CFG   = 116  ;
  public static final int SNVT_SETTING     = 117  ;
  public static final int SNVT_EVAP_STATE  = 118  ;
  public static final int SNVT_THERM_MODE  = 119  ;
  public static final int SNVT_DEFR_MODE   = 120  ;
  public static final int SNVT_DEFR_TERM   = 121  ;
  public static final int SNVT_DEFR_STATE  = 122  ;
  public static final int SNVT_TIME_MIN    = 123  ;
  public static final int SNVT_TIME_HOUR   = 124  ;
  public static final int SNVT_PH          = 125  ;
  public static final int SNVT_PH_F        = 126  ;
  public static final int SNVT_CHLR_STATUS = 127  ;
  public static final int SNVT_TOD_EVENT   = 128  ;
  public static final int SNVT_SMO_OBSCUR  = 129  ;
  public static final int SNVT_FIRE_TEST   = 130  ;
  public static final int SNVT_TEMP_ROR    = 131  ;
  public static final int SNVT_FIRE_INIT   = 132  ;
  public static final int SNVT_FIRE_INDCTE = 133  ;
  public static final int SNVT_TIME_ZONE   = 134  ;
  public static final int SNVT_EARTH_POS   = 135  ;
  public static final int SNVT_REG_VAL     = 136  ;
  public static final int SNVT_REG_VAL_TS  = 137  ;
  public static final int SNVT_VOLT_AC     = 138  ;
  public static final int SNVT_AMP_AC      = 139  ;
  public static final int SNVT_TURBIDITY   = 143  ;
  public static final int SNVT_TURBIDITY_F = 144  ;
  public static final int SNVT_HVAC_TYPE   = 145  ;
  public static final int SNVT_ELEC_KWH_L  = 146  ;
  public static final int SNVT_TEMP_DIFF_P = 147  ;
  public static final int SNVT_CTRL_REQ    = 148  ;
  public static final int SNVT_CTRL_RESP   = 149  ;
  public static final int SNVT_PTZ         = 150  ;
  public static final int SNVT_PRIVACYZONE = 151  ;
  public static final int SNVT_POS_CTRL    = 152  ;
  public static final int SNVT_ENTHALPY    = 153  ;
  public static final int SNVT_GFCI_STATUS = 154  ;
  public static final int SNVT_MOTOR_STATE = 155  ;
  public static final int SNVT_PUMPSET_MN  = 156  ;
  public static final int SNVT_EX_CONTROL  = 157  ;
  public static final int SNVT_PUMPSET_SN  = 158  ;
  public static final int SNVT_PUMP_SENSOR = 159  ;
  public static final int SNVT_ABS_HUMID   = 160  ;
  public static final int SNVT_FLOW_P      = 161  ;
  public static final int SNVT_DEV_C_MODE  = 162  ;
  public static final int SNVT_VALVE_MODE  = 163  ;
  public static final int SNVT_ALARM_2     = 164  ;
  public static final int SNVT_STATE_64    = 165  ;
  public static final int SNVT_NV_TYPE     = 166  ;
  public static final int SNVT_ENT_OPMODE  = 168  ;
  public static final int SNVT_ENT_STATE   = 169  ;
  public static final int SNVT_ENT_STATUS  = 170  ;
  public static final int SNVT_FLOW_DIR    = 171  ;
  public static final int SNVT_HVAC_SATSTS = 172  ;
  public static final int SNVT_DEV_STATUS  = 173  ;
  public static final int SNVT_DEV_FAULT   = 174  ;
  public static final int SNVT_DEV_MAINT   = 175  ;
  public static final int SNVT_DATE_EVENT  = 176  ;
  public static final int SNVT_SCHED_VAL   = 177  ;

  public static final int SNVT_SEC_STATE    = 178  ;
  public static final int SNVT_SEC_STATUS   = 179  ;
  public static final int SNVT_SBLND_STATE  = 180  ;
  public static final int SNVT_RAC_CTRL     = 181  ;
  public static final int SNVT_RAC_REQ      = 182  ;
  public static final int SNVT_COUNT32      = 183  ;
  public static final int SNVT_CLOTHES_WC   = 184  ;
  public static final int SNVT_CLOTHES_WM   = 185  ;
  public static final int SNVT_CLOTHES_WS   = 186  ;
  public static final int SNVT_CLOTHES_WA   = 187  ;

  // Version 13.04
  public static final int  SNVT_MULTIPLIER_S   = 188 ;
  public static final int  SNVT_SWITCH_2       = 189 ;
  public static final int  SNVT_COLOR_2        = 190 ;
  public static final int  SNVT_LOG_STATUS     = 191 ;
  public static final int  SNVT_TIME_STAMP_P   = 192 ;
  public static final int  SNVT_LOG_FX_REQUEST = 193 ;
  public static final int  SNVT_LOG_FX_STATUS  = 194 ;
  public static final int  SNVT_LOG_REQUEST    = 195 ;
  public static final int  SNVT_ENTHALPY_D     = 196 ;
  public static final int  SNVT_AMP_AC_MIL     = 197 ;
  public static final int  SNVT_TIME_HOUR_P    = 198 ;
  public static final int  SNVT_LAMP_STATUS    = 199 ;
  public static final int  SNVT_ENVIRONMENT    = 200 ;
  public static final int  SNVT_GEO_LOC        = 201 ;

  // Version 13.20
  public static final int SNVT_PROGRAM_STATUS = 202  ;
  public static final int SNVT_LOAD_OFFSETS   = 203  ;
  public static final int SNVT_WM_2_P         = 204  ;
  public static final int SNVT_SAFE_1         = 205  ;
  public static final int SNVT_SAFE_2         = 206  ;
  public static final int SNVT_SAFE_4         = 207  ;
  public static final int SNVT_SAFE_8         = 208  ;
  public static final int SNVT_TIME_VAL_2     = 209  ;
  public static final int SNVT_TIME_OFFSET    = 210  ;
  public static final int SNVT_SCHED_EXC      = 211  ;
  public static final int SNVT_SCHED_STATUS   = 212  ;
  public static final int SNVT_MASS_FLOW      = 213  ;
  public static final int SNVT_MASS_FLOW_F    = 214  ;



  public static final int LAST_SNVT_ID  = 214 ;

  public static final BLonSnvtType SnvtXxx         = new BLonSnvtType(SNVT_XXX         );

  public static final BLonSnvtType SnvtAmp         = new BLonSnvtType(SNVT_AMP        );
  public static final BLonSnvtType SnvtAmpMil      = new BLonSnvtType(SNVT_AMP_MIL    );
  public static final BLonSnvtType SnvtAngle       = new BLonSnvtType(SNVT_ANGLE      );
  public static final BLonSnvtType SnvtAngleVel    = new BLonSnvtType(SNVT_ANGLE_VEL  );
  public static final BLonSnvtType SnvtBtuKilo     = new BLonSnvtType(SNVT_BTU_KILO   );
  public static final BLonSnvtType SnvtBtuMega     = new BLonSnvtType(SNVT_BTU_MEGA   );
  public static final BLonSnvtType SnvtCharAscii   = new BLonSnvtType(SNVT_CHAR_ASCII );
  public static final BLonSnvtType SnvtCount       = new BLonSnvtType(SNVT_COUNT      );
  public static final BLonSnvtType SnvtCountInc    = new BLonSnvtType(SNVT_COUNT_INC  );
  public static final BLonSnvtType SnvtDateCal     = new BLonSnvtType(SNVT_DATE_CAL   );
  public static final BLonSnvtType SnvtDateDay     = new BLonSnvtType(SNVT_DATE_DAY   );
  public static final BLonSnvtType SnvtDateTime    = new BLonSnvtType(SNVT_DATE_TIME  );
  public static final BLonSnvtType SnvtElecKwh     = new BLonSnvtType(SNVT_ELEC_KWH   );
  public static final BLonSnvtType SnvtElecWhr     = new BLonSnvtType(SNVT_ELEC_WHR   );
  public static final BLonSnvtType SnvtFlow        = new BLonSnvtType(SNVT_FLOW       );
  public static final BLonSnvtType SnvtFlowMil     = new BLonSnvtType(SNVT_FLOW_MIL   );
  public static final BLonSnvtType SnvtLength      = new BLonSnvtType(SNVT_LENGTH     );
  public static final BLonSnvtType SnvtLengthKilo  = new BLonSnvtType(SNVT_LENGTH_KILO);
  public static final BLonSnvtType SnvtLengthMicr  = new BLonSnvtType(SNVT_LENGTH_MICR);
  public static final BLonSnvtType SnvtLengthMil   = new BLonSnvtType(SNVT_LENGTH_MIL );
  public static final BLonSnvtType SnvtLevCont     = new BLonSnvtType(SNVT_LEV_CONT   );
  public static final BLonSnvtType SnvtLevDisc     = new BLonSnvtType(SNVT_LEV_DISC   );
  public static final BLonSnvtType SnvtMass        = new BLonSnvtType(SNVT_MASS       );
  public static final BLonSnvtType SnvtMassKilo    = new BLonSnvtType(SNVT_MASS_KILO  );
  public static final BLonSnvtType SnvtMassMega    = new BLonSnvtType(SNVT_MASS_MEGA  );
  public static final BLonSnvtType SnvtMassMil     = new BLonSnvtType(SNVT_MASS_MIL   );
  public static final BLonSnvtType SnvtPower       = new BLonSnvtType(SNVT_POWER      );
  public static final BLonSnvtType SnvtPowerKilo   = new BLonSnvtType(SNVT_POWER_KILO );
  public static final BLonSnvtType SnvtPpm         = new BLonSnvtType(SNVT_PPM        );
  public static final BLonSnvtType SnvtPress       = new BLonSnvtType(SNVT_PRESS      );
  public static final BLonSnvtType SnvtRes         = new BLonSnvtType(SNVT_RES        );
  public static final BLonSnvtType SnvtResKilo     = new BLonSnvtType(SNVT_RES_KILO   );
  public static final BLonSnvtType SnvtSoundDb     = new BLonSnvtType(SNVT_SOUND_DB   );
  public static final BLonSnvtType SnvtSpeed       = new BLonSnvtType(SNVT_SPEED      );
  public static final BLonSnvtType SnvtSpeedMil    = new BLonSnvtType(SNVT_SPEED_MIL  );
  public static final BLonSnvtType SnvtStrAsc      = new BLonSnvtType(SNVT_STR_ASC    );
  public static final BLonSnvtType SnvtStrInt      = new BLonSnvtType(SNVT_STR_INT    );
  public static final BLonSnvtType SnvtTelcom      = new BLonSnvtType(SNVT_TELCOM     );
  public static final BLonSnvtType SnvtTemp        = new BLonSnvtType(SNVT_TEMP       );
  public static final BLonSnvtType SnvtTimePassed  = new BLonSnvtType(SNVT_TIME_PASSED);
  public static final BLonSnvtType SnvtVol         = new BLonSnvtType(SNVT_VOL        );
  public static final BLonSnvtType SnvtVolKilo     = new BLonSnvtType(SNVT_VOL_KILO   );
  public static final BLonSnvtType SnvtVolMil      = new BLonSnvtType(SNVT_VOL_MIL    );
  public static final BLonSnvtType SnvtVolt        = new BLonSnvtType(SNVT_VOLT       );
  public static final BLonSnvtType SnvtVoltDbmv    = new BLonSnvtType(SNVT_VOLT_DBMV  );
  public static final BLonSnvtType SnvtVoltKilo    = new BLonSnvtType(SNVT_VOLT_KILO  );
  public static final BLonSnvtType SnvtVoltMil     = new BLonSnvtType(SNVT_VOLT_MIL   );
  public static final BLonSnvtType SnvtAmpF        = new BLonSnvtType(SNVT_AMP_F      );
  public static final BLonSnvtType SnvtAngleF      = new BLonSnvtType(SNVT_ANGLE_F    );
  public static final BLonSnvtType SnvtAngleVelF   = new BLonSnvtType(SNVT_ANGLE_VEL_F);
  public static final BLonSnvtType SnvtCountF      = new BLonSnvtType(SNVT_COUNT_F    );
  public static final BLonSnvtType SnvtCountIncF   = new BLonSnvtType(SNVT_COUNT_INC_F);
  public static final BLonSnvtType SnvtFlowF       = new BLonSnvtType(SNVT_FLOW_F     );
  public static final BLonSnvtType SnvtLengthF     = new BLonSnvtType(SNVT_LENGTH_F   );
  public static final BLonSnvtType SnvtLevContF    = new BLonSnvtType(SNVT_LEV_CONT_F );
  public static final BLonSnvtType SnvtMassF       = new BLonSnvtType(SNVT_MASS_F     );
  public static final BLonSnvtType SnvtPowerF      = new BLonSnvtType(SNVT_POWER_F    );
  public static final BLonSnvtType SnvtPpmF        = new BLonSnvtType(SNVT_PPM_F      );
  public static final BLonSnvtType SnvtPressF      = new BLonSnvtType(SNVT_PRESS_F    );
  public static final BLonSnvtType SnvtResF        = new BLonSnvtType(SNVT_RES_F      );
  public static final BLonSnvtType SnvtSoundDbF    = new BLonSnvtType(SNVT_SOUND_DB_F );
  public static final BLonSnvtType SnvtSpeedF      = new BLonSnvtType(SNVT_SPEED_F    );
  public static final BLonSnvtType SnvtTempF       = new BLonSnvtType(SNVT_TEMP_F     );
  public static final BLonSnvtType SnvtTimeF       = new BLonSnvtType(SNVT_TIME_F     );
  public static final BLonSnvtType SnvtVolF        = new BLonSnvtType(SNVT_VOL_F      );
  public static final BLonSnvtType SnvtVoltF       = new BLonSnvtType(SNVT_VOLT_F     );
  public static final BLonSnvtType SnvtBtuF        = new BLonSnvtType(SNVT_BTU_F      );
  public static final BLonSnvtType SnvtElecWhrF    = new BLonSnvtType(SNVT_ELEC_WHR_F );
  public static final BLonSnvtType SnvtConfigSrc   = new BLonSnvtType(SNVT_CONFIG_SRC );
  public static final BLonSnvtType SnvtColor       = new BLonSnvtType(SNVT_COLOR      );
  public static final BLonSnvtType SnvtGrammage    = new BLonSnvtType(SNVT_GRAMMAGE   );
  public static final BLonSnvtType SnvtGrammageF   = new BLonSnvtType(SNVT_GRAMMAGE_F );
  public static final BLonSnvtType SnvtFileReq     = new BLonSnvtType(SNVT_FILE_REQ   );
  public static final BLonSnvtType SnvtFileStatus  = new BLonSnvtType(SNVT_FILE_STATUS);
  public static final BLonSnvtType SnvtFreqF       = new BLonSnvtType(SNVT_FREQ_F     );
  public static final BLonSnvtType SnvtFreqHz      = new BLonSnvtType(SNVT_FREQ_HZ    );
  public static final BLonSnvtType SnvtFreqKilohz  = new BLonSnvtType(SNVT_FREQ_KILOHZ);
  public static final BLonSnvtType SnvtFreqMilhz   = new BLonSnvtType(SNVT_FREQ_MILHZ );
  public static final BLonSnvtType SnvtLux         = new BLonSnvtType(SNVT_LUX        );
  public static final BLonSnvtType SnvtIso7811     = new BLonSnvtType(SNVT_ISO_7811   );
  public static final BLonSnvtType SnvtLevPercent  = new BLonSnvtType(SNVT_LEV_PERCENT);
  public static final BLonSnvtType SnvtMultiplier  = new BLonSnvtType(SNVT_MULTIPLIER );
  public static final BLonSnvtType SnvtState       = new BLonSnvtType(SNVT_STATE      );
  public static final BLonSnvtType SnvtTimeStamp   = new BLonSnvtType(SNVT_TIME_STAMP );
  public static final BLonSnvtType SnvtZerospan    = new BLonSnvtType(SNVT_ZEROSPAN   );
  public static final BLonSnvtType SnvtMagcard     = new BLonSnvtType(SNVT_MAGCARD    );
  public static final BLonSnvtType SnvtElapsedTm   = new BLonSnvtType(SNVT_ELAPSED_TM );
  public static final BLonSnvtType SnvtAlarm       = new BLonSnvtType(SNVT_ALARM      );
  public static final BLonSnvtType SnvtCurrency    = new BLonSnvtType(SNVT_CURRENCY   );
  public static final BLonSnvtType SnvtFilePos     = new BLonSnvtType(SNVT_FILE_POS   );
  public static final BLonSnvtType SnvtMuldiv      = new BLonSnvtType(SNVT_MULDIV     );
  public static final BLonSnvtType SnvtObjRequest  = new BLonSnvtType(SNVT_OBJ_REQUEST);
  public static final BLonSnvtType SnvtObjStatus   = new BLonSnvtType(SNVT_OBJ_STATUS );
  public static final BLonSnvtType SnvtPreset      = new BLonSnvtType(SNVT_PRESET     );
  public static final BLonSnvtType SnvtSwitch      = new BLonSnvtType(SNVT_SWITCH     );
  public static final BLonSnvtType SnvtTransTable  = new BLonSnvtType(SNVT_TRANS_TABLE);
  public static final BLonSnvtType SnvtOverride    = new BLonSnvtType(SNVT_OVERRIDE   );
  public static final BLonSnvtType SnvtPwrFact     = new BLonSnvtType(SNVT_PWR_FACT   );
  public static final BLonSnvtType SnvtPwrFactF    = new BLonSnvtType(SNVT_PWR_FACT_F );
  public static final BLonSnvtType SnvtDensity     = new BLonSnvtType(SNVT_DENSITY    );
  public static final BLonSnvtType SnvtDensityF    = new BLonSnvtType(SNVT_DENSITY_F  );
  public static final BLonSnvtType SnvtRpm         = new BLonSnvtType(SNVT_RPM        );
  public static final BLonSnvtType SnvtHvacEmerg   = new BLonSnvtType(SNVT_HVAC_EMERG );
  public static final BLonSnvtType SnvtAngleDeg    = new BLonSnvtType(SNVT_ANGLE_DEG  );
  public static final BLonSnvtType SnvtTempP       = new BLonSnvtType(SNVT_TEMP_P     );
  public static final BLonSnvtType SnvtTempSetpt   = new BLonSnvtType(SNVT_TEMP_SETPT );
  public static final BLonSnvtType SnvtTimeSec     = new BLonSnvtType(SNVT_TIME_SEC   );
  public static final BLonSnvtType SnvtHvacMode    = new BLonSnvtType(SNVT_HVAC_MODE  );
  public static final BLonSnvtType SnvtOccupancy   = new BLonSnvtType(SNVT_OCCUPANCY  );
  public static final BLonSnvtType SnvtArea        = new BLonSnvtType(SNVT_AREA       );
  public static final BLonSnvtType SnvtHvacOverid  = new BLonSnvtType(SNVT_HVAC_OVERID);
  public static final BLonSnvtType SnvtHvacStatus  = new BLonSnvtType(SNVT_HVAC_STATUS);
  public static final BLonSnvtType SnvtPressP      = new BLonSnvtType(SNVT_PRESS_P    );
  public static final BLonSnvtType SnvtAddress     = new BLonSnvtType(SNVT_ADDRESS    );
  public static final BLonSnvtType SnvtScene       = new BLonSnvtType(SNVT_SCENE      );
  public static final BLonSnvtType SnvtSceneCfg    = new BLonSnvtType(SNVT_SCENE_CFG  );
  public static final BLonSnvtType SnvtSetting     = new BLonSnvtType(SNVT_SETTING    );
  public static final BLonSnvtType SnvtEvapState   = new BLonSnvtType(SNVT_EVAP_STATE );
  public static final BLonSnvtType SnvtThermMode   = new BLonSnvtType(SNVT_THERM_MODE );
  public static final BLonSnvtType SnvtDefrMode    = new BLonSnvtType(SNVT_DEFR_MODE  );
  public static final BLonSnvtType SnvtDefrTerm    = new BLonSnvtType(SNVT_DEFR_TERM  );
  public static final BLonSnvtType SnvtDefrState   = new BLonSnvtType(SNVT_DEFR_STATE );
  public static final BLonSnvtType SnvtTimeMin     = new BLonSnvtType(SNVT_TIME_MIN   );
  public static final BLonSnvtType SnvtTimeHour    = new BLonSnvtType(SNVT_TIME_HOUR  );
  public static final BLonSnvtType SnvtPh          = new BLonSnvtType(SNVT_PH         );
  public static final BLonSnvtType SnvtPhF         = new BLonSnvtType(SNVT_PH_F       );
  public static final BLonSnvtType SnvtChlrStatus  = new BLonSnvtType(SNVT_CHLR_STATUS);
  public static final BLonSnvtType SnvtTodEvent    = new BLonSnvtType(SNVT_TOD_EVENT  );
  public static final BLonSnvtType SnvtSmoObscur   = new BLonSnvtType(SNVT_SMO_OBSCUR );
  public static final BLonSnvtType SnvtFireTest    = new BLonSnvtType(SNVT_FIRE_TEST  );
  public static final BLonSnvtType SnvtTempRor     = new BLonSnvtType(SNVT_TEMP_ROR   );
  public static final BLonSnvtType SnvtFireInit    = new BLonSnvtType(SNVT_FIRE_INIT  );
  public static final BLonSnvtType SnvtFireIndcte  = new BLonSnvtType(SNVT_FIRE_INDCTE);
  public static final BLonSnvtType SnvtTimeZone    = new BLonSnvtType(SNVT_TIME_ZONE  );
  public static final BLonSnvtType SnvtEarthPos    = new BLonSnvtType(SNVT_EARTH_POS  );
  public static final BLonSnvtType SnvtRegVal      = new BLonSnvtType(SNVT_REG_VAL    );
  public static final BLonSnvtType SnvtRegValTs    = new BLonSnvtType(SNVT_REG_VAL_TS );
  public static final BLonSnvtType SnvtVoltAc      = new BLonSnvtType(SNVT_VOLT_AC    );
  public static final BLonSnvtType SnvtAmpAc       = new BLonSnvtType(SNVT_AMP_AC     );
  public static final BLonSnvtType SnvtTurbidity   = new BLonSnvtType(SNVT_TURBIDITY  );
  public static final BLonSnvtType SnvtTurbidityF  = new BLonSnvtType(SNVT_TURBIDITY_F);
  public static final BLonSnvtType SnvtHvacType    = new BLonSnvtType(SNVT_HVAC_TYPE  );
  public static final BLonSnvtType SnvtElecKwhL    = new BLonSnvtType(SNVT_ELEC_KWH_L );
  public static final BLonSnvtType SnvtTempDiffP   = new BLonSnvtType(SNVT_TEMP_DIFF_P);
  public static final BLonSnvtType SnvtCtrlReq     = new BLonSnvtType(SNVT_CTRL_REQ   );
  public static final BLonSnvtType SnvtCtrlResp    = new BLonSnvtType(SNVT_CTRL_RESP  );
  public static final BLonSnvtType SnvtPtz         = new BLonSnvtType(SNVT_PTZ        );
  public static final BLonSnvtType SnvtPrivacyzone = new BLonSnvtType(SNVT_PRIVACYZONE);
  public static final BLonSnvtType SnvtPosCtrl     = new BLonSnvtType(SNVT_POS_CTRL   );
  public static final BLonSnvtType SnvtEnthalpy    = new BLonSnvtType(SNVT_ENTHALPY   );
  public static final BLonSnvtType SnvtGfciStatus  = new BLonSnvtType(SNVT_GFCI_STATUS);
  public static final BLonSnvtType SnvtMotorState  = new BLonSnvtType(SNVT_MOTOR_STATE);
  public static final BLonSnvtType SnvtPumpsetMn   = new BLonSnvtType(SNVT_PUMPSET_MN );
  public static final BLonSnvtType SnvtExControl   = new BLonSnvtType(SNVT_EX_CONTROL );
  public static final BLonSnvtType SnvtPumpsetSn   = new BLonSnvtType(SNVT_PUMPSET_SN );
  public static final BLonSnvtType SnvtPumpSensor  = new BLonSnvtType(SNVT_PUMP_SENSOR);
  public static final BLonSnvtType SnvtAbsHumid    = new BLonSnvtType(SNVT_ABS_HUMID  );
  public static final BLonSnvtType SnvtFlowP       = new BLonSnvtType(SNVT_FLOW_P     );
  public static final BLonSnvtType SnvtDevCMode    = new BLonSnvtType(SNVT_DEV_C_MODE );
  public static final BLonSnvtType SnvtValveMode   = new BLonSnvtType(SNVT_VALVE_MODE );
  public static final BLonSnvtType SnvtAlarm2      = new BLonSnvtType(SNVT_ALARM_2    );
  public static final BLonSnvtType SnvtState64     = new BLonSnvtType(SNVT_STATE_64   );
  public static final BLonSnvtType SnvtNvType      = new BLonSnvtType(SNVT_NV_TYPE    );
  public static final BLonSnvtType SnvtEntOpmode   = new BLonSnvtType(SNVT_ENT_OPMODE );
  public static final BLonSnvtType SnvtEntState    = new BLonSnvtType(SNVT_ENT_STATE  );
  public static final BLonSnvtType SnvtEntStatus   = new BLonSnvtType(SNVT_ENT_STATUS );
  public static final BLonSnvtType SnvtFlowDir     = new BLonSnvtType(SNVT_FLOW_DIR   );
  public static final BLonSnvtType SnvtHvacSatsts  = new BLonSnvtType(SNVT_HVAC_SATSTS);
  public static final BLonSnvtType SnvtDevStatus   = new BLonSnvtType(SNVT_DEV_STATUS );
  public static final BLonSnvtType SnvtDevFault    = new BLonSnvtType(SNVT_DEV_FAULT  );
  public static final BLonSnvtType SnvtDevMaint    = new BLonSnvtType(SNVT_DEV_MAINT  );
  public static final BLonSnvtType SnvtDateEvent   = new BLonSnvtType(SNVT_DATE_EVENT );
  public static final BLonSnvtType SnvtSchedVal    = new BLonSnvtType(SNVT_SCHED_VAL  );
 
  public static final BLonSnvtType SnvtSecState      = new BLonSnvtType(SNVT_SEC_STATE   );
  public static final BLonSnvtType SnvtSecStatus     = new BLonSnvtType(SNVT_SEC_STATUS  );
  public static final BLonSnvtType SnvtSblndState    = new BLonSnvtType(SNVT_SBLND_STATE );
  public static final BLonSnvtType SnvtRacCtrl       = new BLonSnvtType(SNVT_RAC_CTRL    );
  public static final BLonSnvtType SnvtRacReq        = new BLonSnvtType(SNVT_RAC_REQ     );
  public static final BLonSnvtType SnvtCount32       = new BLonSnvtType(SNVT_COUNT32     );
  public static final BLonSnvtType SnvtClothesWC     = new BLonSnvtType(SNVT_CLOTHES_WC  );
  public static final BLonSnvtType SnvtClothesWM     = new BLonSnvtType(SNVT_CLOTHES_WM  );
  public static final BLonSnvtType SnvtClothesWS     = new BLonSnvtType(SNVT_CLOTHES_WS  );
  public static final BLonSnvtType SnvtClothesWA     = new BLonSnvtType(SNVT_CLOTHES_WA  );

  // Version 13.04
  public static final BLonSnvtType SnvtMultiplierS   = new BLonSnvtType(SNVT_MULTIPLIER_S    );
  public static final BLonSnvtType SnvtSwitch2       = new BLonSnvtType(SNVT_SWITCH_2        );
  public static final BLonSnvtType SnvtColor2        = new BLonSnvtType(SNVT_COLOR_2         );
  public static final BLonSnvtType SnvtLogStatus     = new BLonSnvtType(SNVT_LOG_STATUS      );
  public static final BLonSnvtType SnvtTimeStampP    = new BLonSnvtType(SNVT_TIME_STAMP_P    );
  public static final BLonSnvtType SnvtLogFxRequest  = new BLonSnvtType(SNVT_LOG_FX_REQUEST  );
  public static final BLonSnvtType SnvtLogFxStatus   = new BLonSnvtType(SNVT_LOG_FX_STATUS   );
  public static final BLonSnvtType SnvtLogRequest    = new BLonSnvtType(SNVT_LOG_REQUEST     );
  public static final BLonSnvtType SnvtEnthalpyD     = new BLonSnvtType(SNVT_ENTHALPY_D      );
  public static final BLonSnvtType SnvtAmpAcMil      = new BLonSnvtType(SNVT_AMP_AC_MIL      );
  public static final BLonSnvtType SnvtTimeHourP     = new BLonSnvtType(SNVT_TIME_HOUR_P     );
  public static final BLonSnvtType SnvtLampStatus    = new BLonSnvtType(SNVT_LAMP_STATUS     );
  public static final BLonSnvtType SnvtEnvironment   = new BLonSnvtType(SNVT_ENVIRONMENT     );
  public static final BLonSnvtType SnvtGeoLoc        = new BLonSnvtType(SNVT_GEO_LOC         );

  // Version 13.20
  public static final BLonSnvtType SnvtProgramStatus  = new BLonSnvtType(SNVT_PROGRAM_STATUS);
  public static final BLonSnvtType SnvtLoadOffsets    = new BLonSnvtType(SNVT_LOAD_OFFSETS  );
  public static final BLonSnvtType SnvtWm2P           = new BLonSnvtType(SNVT_WM_2_P        );
  public static final BLonSnvtType SnvtSafe1          = new BLonSnvtType(SNVT_SAFE_1        );
  public static final BLonSnvtType SnvtSafe2          = new BLonSnvtType(SNVT_SAFE_2        );
  public static final BLonSnvtType SnvtSafe4          = new BLonSnvtType(SNVT_SAFE_4        );
  public static final BLonSnvtType SnvtSafe8          = new BLonSnvtType(SNVT_SAFE_8        );
  public static final BLonSnvtType SnvtTimeVal2       = new BLonSnvtType(SNVT_TIME_VAL_2    );
  public static final BLonSnvtType SnvtTimeOffset     = new BLonSnvtType(SNVT_TIME_OFFSET   );
  public static final BLonSnvtType SnvtSchedExc       = new BLonSnvtType(SNVT_SCHED_EXC     );
  public static final BLonSnvtType SnvtSchedStatus    = new BLonSnvtType(SNVT_SCHED_STATUS  );
  public static final BLonSnvtType SnvtMassFlow       = new BLonSnvtType(SNVT_MASS_FLOW     );
  public static final BLonSnvtType SnvtMassFlowF      = new BLonSnvtType(SNVT_MASS_FLOW_F   );

////////////////////////////////////////////////////////////////       
// Type                                                                
////////////////////////////////////////////////////////////////       
                                                                       
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonSnvtType.class);
  
  /** Factory method with ordinal. */
  public static BLonSnvtType make(int ordinal)
  {
    return (BLonSnvtType)SnvtXxx.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BLonSnvtType make(String tag)
  {
    return (BLonSnvtType)SnvtXxx.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonSnvtType(int ordinal)
  {
    super(ordinal);
  }

  
//  // Create a list of snvt types for this class file
//  // to run >>nre lonworks:javax.baja.lonworks.enums.BLonSnvtType
//  public static void main(String[] args)
//  {  
//      XLonInterfaceFile std = XUtil.getStandard();
//      Vector types = std.types;
//      String[] a = new String[255];
//int[] la = new int [255];      
//      int maxNv = 0;
//      int maxLen = 0;
//      for(int i=0 ; i<types.size() ; i++)
//      {
//        XTypeDef t = ((XTypeDef)types.elementAt(i));
//        if(!t.isCpType())
//        { 
//          int ndx = t.getTypeIndex();
//          if(ndx < 0) continue;
//          a[ndx] = t.getName();
//          if(ndx>maxNv) maxNv = ndx;
//          int len = NameUtil.toConstantName(a[ndx]).length();
//          if( len > maxLen) maxLen = len;
//try { la[ndx] = t.getLonData(std).getByteLength(); } catch(Exception e) {}          
//        }
//      }
//      
//      String pad = "                                          ";
//      System.out.println("  public static final int SNVT_XXX          = 0  ;");
//      for(int i=1; i<=maxNv ; i++)
//      {           
//        if(a[i]==null) continue;
//        String conName = NameUtil.toConstantName(a[i]);
//        int padLen = maxLen - conName.length();
//        System.out.println("  public static final int SNVT_" + 
//               conName + pad.substring(0,padLen) + " = " + i + "  ;"); 
//      }
//
//      System.out.println("\n\n");
//      System.out.println("  public static final int LAST_SNVT_ID  = " + maxNv + " ;\n");
//      System.out.println("  public static final BLonSnvtType SnvtXxx         = new BLonSnvtType(SNVT_XXX         );\n");
//      
//      for(int i=1; i<=maxNv ; i++)
//      {
//        if(a[i]==null) continue;
//        String conName = NameUtil.toConstantName(a[i]);
//        int padLen = maxLen - a[i].length();
//        System.out.println("  public static final BLonSnvtType Snvt" 
//                     + NameUtil.toJavaName(a[i],true) + pad.substring(0,padLen) +
//                      " = new BLonSnvtType(SNVT_" + conName + pad.substring(0,maxLen-conName.length()) + 
//  ");  " + la[i]);
//      }
//    
//  }
//  
  
}
