/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

//import java.util.*;                  // needed for main()
//import com.tridium.lonworks.util.*; // for main
//import com.tridium.lonworks.xml.*;   // for main
//import javax.baja.util.*;

/**
 * The BLonScptType class provides an enumeration for 
 * all standard SCPT types
 *
 * @author    Robert Adams
 * @creation  31 Oct 03
 * @version   $Revision: 1$ $Date: 6/13/01 12:26:08 PM$
 * @since     Niagara 3.0
 */
public final class BLonScptType
  extends BFrozenEnum
{
////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////
  //  Extracted from standard.typ 10/31/03
  //  Updated   from standard.typ 10/10/06
  //////////////////////////////////////////////////////////////
  public static final int SCPT_XXX          = 0  ;
  public static final int SCPT_ACT_FB_DLY                          = 1  ;
  public static final int SCPT_ALRM_CLR_T_1                        = 2  ;
  public static final int SCPT_ALRM_CLR_T_2                        = 3  ;
  public static final int SCPT_ALRM_IHB_T                          = 4  ;
  public static final int SCPT_ALRM_SET_T_1                        = 5  ;
  public static final int SCPT_ALRM_SET_T_2                        = 6  ;
  public static final int SCPT_DEF_OUTPUT                          = 7  ;
  public static final int SCPT_DRIVE_T                             = 8  ;
  public static final int SCPT_HIGH_LIMIT_1                        = 9  ;
  public static final int SCPT_HIGH_LIMIT_2                        = 10  ;
  public static final int SCPT_HYST_HIGH_1                         = 11  ;
  public static final int SCPT_HYST_HIGH_2                         = 12  ;
  public static final int SCPT_HYST_LOW_1                          = 13  ;
  public static final int SCPT_HYST_LOW_2                          = 14  ;
  public static final int SCPT_IN_FB_DLY                           = 15  ;
  public static final int SCPT_INVRT_OUT                           = 16  ;
  public static final int SCPT_LOCATION                            = 17  ;
  public static final int SCPT_LOW_LIMIT_1                         = 18  ;
  public static final int SCPT_LOW_LIMIT_2                         = 19  ;
  public static final int SCPT_MAX_RNGE                            = 20  ;
  public static final int SCPT_MAX_RCV_T                           = 21  ;
  public static final int SCPT_MAX_SND_T                           = 22  ;
  public static final int SCPT_MIN_RNGE                            = 23  ;
  public static final int SCPT_MIN_SND_T                           = 24  ;
  public static final int SCPT_NWRK_CNFG                           = 25  ;
  public static final int SCPT_OFFSET                              = 26  ;
  public static final int SCPT_SND_DELTA                           = 27  ;
  public static final int SCPT_TRNS_TBL_X                          = 28  ;
  public static final int SCPT_TRNS_TBL_Y                          = 29  ;
  public static final int SCPT_OFF_DELY                            = 30  ;
  public static final int SCPT_GAIN                                = 31  ;
  public static final int SCPT_OVR_BEHAVE                          = 32  ;
  public static final int SCPT_OVR_VALUE                           = 33  ;
  public static final int SCPT_BYPASS_TIME                         = 34  ;
  public static final int SCPT_MAN_OVR_TIME                        = 35  ;
  public static final int SCPT_HUM_SETPT                           = 36  ;
  public static final int SCPT_MAX_FLOW_HEAT                       = 37  ;
  public static final int SCPT_FIRE_INIT_TYPE                      = 38  ;
  public static final int SCPT_SMOKE_NOM_SENS                      = 39  ;
  public static final int SCPT_SMOKE_DAY_ALRM_LIM                  = 40  ;
  public static final int SCPT_ACTUATOR_TYPE                       = 41  ;
  public static final int SCPT_LIMIT_CO_2                          = 42  ;
  public static final int SCPT_MIN_DELTA_ANGL                      = 43  ;
  public static final int SCPT_DIRECTION                           = 44  ;
  public static final int SCPT_DRIVE_TIME                          = 45  ;
  public static final int SCPT_DUCT_AREA                           = 46  ;
  public static final int SCPT_MIN_DELTA_FLOW                      = 47  ;
  public static final int SCPT_MAX_RCV_TIME                        = 48  ;
  public static final int SCPT_MAX_SEND_TIME                       = 49  ;
  public static final int SCPT_MAX_SETPOINT                        = 50  ;
  public static final int SCPT_MAX_FLOW                            = 51  ;
  public static final int SCPT_MIN_SEND_TIME                       = 52  ;
  public static final int SCPT_MIN_SETPOINT                        = 53  ;
  public static final int SCPT_MIN_FLOW                            = 54  ;
  public static final int SCPT_MIN_FLOW_HEAT                       = 55  ;
  public static final int SCPT_MIN_FLOW_STBY                       = 56  ;
  public static final int SCPT_NOM_AIR_FLOW                        = 57  ;
  public static final int SCPT_NOM_ANGLE                           = 58  ;
  public static final int SCPT_NUM_VALVES                          = 59  ;
  public static final int SCPT_SET_PNTS                            = 60  ;
  public static final int SCPT_OEM_TYPE                            = 61  ;
  public static final int SCPT_MIN_DELTA_RH                        = 62  ;
  public static final int SCPT_MIN_DELTA_CO_2                      = 63  ;
  public static final int SCPT_MIN_DELTA_TEMP                      = 64  ;
  public static final int SCPT_SENS_CONST_TMP                      = 65  ;
  public static final int SCPT_GAIN_VAV                            = 66  ;
  public static final int SCPT_SENS_CONST_VAV                      = 67  ;
  public static final int SCPT_OFFSET_CO_2                         = 68  ;
  public static final int SCPT_OFFSET_RH                           = 69  ;
  public static final int SCPT_OFFSET_TEMP                         = 70  ;
  public static final int SCPT_DEFLT_BEHAVE                        = 71  ;
  public static final int SCPT_PWR_UP_DELAY                        = 72  ;
  public static final int SCPT_PWR_UP_STATE                        = 73  ;
  public static final int SCPT_HVAC_MODE                           = 74  ;
  public static final int SCPT_COOL_SETPT                          = 75  ;
  public static final int SCPT_COOL_LOWER_SP                       = 76  ;
  public static final int SCPT_COOL_UPPER_SP                       = 77  ;
  public static final int SCPT_HEAT_SETPT                          = 78  ;
  public static final int SCPT_HEAT_LOWER_SP                       = 79  ;
  public static final int SCPT_HEAT_UPPER_SP                       = 80  ;
  public static final int SCPT_LIMIT_CHLR_CAP                      = 81  ;
  public static final int SCPT_LUX_SETPOINT                        = 82  ;
  public static final int SCPT_STEP                                = 83  ;
  public static final int SCPT_ON_OFF_HYSTERESIS                   = 84  ;
  public static final int SCPT_CL_OFF_DELAY                        = 85  ;
  public static final int SCPT_CL_ON_DELAY                         = 86  ;
  public static final int SCPT_POWERUP_STATE                       = 87  ;
  public static final int SCPT_MIN_DELTA_LEVEL                     = 88  ;
  public static final int SCPT_REFLECTION                          = 89  ;
  public static final int SCPT_FIELD_CALIB                         = 90  ;
  public static final int SCPT_HOLD_TIME                           = 91  ;
  public static final int SCPT_STEP_VALUE                          = 92  ;
  public static final int SCPT_MAX_OUT                             = 93  ;
  public static final int SCPT_SCENE_NMBR                          = 94  ;
  public static final int SCPT_FADE_TIME                           = 95  ;
  public static final int SCPT_DELAY_TIME                          = 96  ;
  public static final int SCPT_MASTER_SLAVE                        = 97  ;
  public static final int SCPT_UPDATE_RATE                         = 98  ;
  public static final int SCPT_SUMMER_TIME                         = 99  ;
  public static final int SCPT_WINTER_TIME                         = 100  ;
  public static final int SCPT_MANUAL_ALLOWED                      = 101  ;
  public static final int SCPT_DEF_WEEK_MASK                       = 102  ;
  public static final int SCPT_DAY_DATE_INDEX                      = 103  ;
  public static final int SCPT_TIME_EVENT                          = 104  ;
  public static final int SCPT_MODE_HRT_BT                         = 105  ;
  public static final int SCPT_DEFROST_MODE                        = 106  ;
  public static final int SCPT_MAX_DEFRST_TIME                     = 107  ;
  public static final int SCPT_DRAIN_DELAY                         = 108  ;
  public static final int SCPT_INJ_DELAY                           = 109  ;
  public static final int SCPT_MAX_DEFRST_TEMP                     = 110  ;
  public static final int SCPT_STRTUP_DELAY                        = 111  ;
  public static final int SCPT_TERM_TIME_TEMP                      = 112  ;
  public static final int SCPT_PUMP_DOWN_DELAY                     = 113  ;
  public static final int SCPT_SUPER_HT_REF_INIT                   = 114  ;
  public static final int SCPT_STRTUP_OPEN                         = 115  ;
  public static final int SCPT_SUPER_HT_REF_MIN                    = 116  ;
  public static final int SCPT_REFRIG_GLIDE                        = 117  ;
  public static final int SCPT_SUPER_HT_REF_MAX                    = 118  ;
  public static final int SCPT_REFRIG_TYPE                         = 119  ;
  public static final int SCPT_THERM_MODE                          = 120  ;
  public static final int SCPT_DAY_NIGHT_CNTRL                     = 121  ;
  public static final int SCPT_DIFF_NIGHT                          = 122  ;
  public static final int SCPT_HIGH_LIM_TEMP                       = 123  ;
  public static final int SCPT_HIGH_LIM_DLY                        = 124  ;
  public static final int SCPT_CUT_OUT_VALUE                       = 125  ;
  public static final int SCPT_AIR_TEMP_1_DAY                      = 126  ;
  public static final int SCPT_SMOKE_NIGHT_ALRM_LIM                = 127  ;
  public static final int SCPT_LOW_LIM_TEMP                        = 128  ;
  public static final int SCPT_LOW_LIM_DLY                         = 129  ;
  public static final int SCPT_DIFF_VALUE                          = 130  ;
  public static final int SCPT_AIR_TEMP_1_NIGHT                    = 131  ;
  public static final int SCPT_AIR_TEMP_1_ALRM                     = 132  ;
  public static final int SCPT_HIGH_LIM_DEFR_DLY                   = 133  ;
  public static final int SCPT_DELTA_NIGHT                         = 134  ;
  public static final int SCPT_RUN_HR_INIT                         = 135  ;
  public static final int SCPT_RUN_HR_ALARM                        = 136  ;
  public static final int SCPT_ENERGY_CNT_INIT                     = 137  ;
  public static final int SCPT_SMOKE_DAY_PRE_ALRM_LIM              = 138  ;
  public static final int SCPT_DEBOUNCE                            = 139  ;
  public static final int SCPT_SMOKE_NIGHT_PRE_ALRM_LIM            = 140  ;
  public static final int SCPT_ZONE_NUM                            = 141  ;
  public static final int SCPT_THERM_ALRM_ROR                      = 142  ;
  public static final int SCPT_VIS_OUTPUT                          = 143  ;
  public static final int SCPT_AUD_OUTPUT                          = 144  ;
  public static final int SCPT_FLASH_FREQ                          = 145  ;
  public static final int SCPT_INSTALL_DATE                        = 146  ;
  public static final int SCPT_MAINT_DATE                          = 147  ;
  public static final int SCPT_MANF_DATE                           = 148  ;
  public static final int SCPT_FIRE_TXT_1                          = 149  ;
  public static final int SCPT_FIRE_TXT_2                          = 150  ;
  public static final int SCPT_FIRE_TXT_3                          = 151  ;
  public static final int SCPT_THERM_THRESHOLD                     = 152  ;
  public static final int SCPT_FIRE_INDICATE                       = 153  ;
  public static final int SCPT_TIME_ZONE                           = 154  ;
  public static final int SCPT_PRIME_VAL                           = 155  ;
  public static final int SCPT_SECOND_VAL                          = 156  ;
  public static final int SCPT_SCENE_OFFSET                        = 157  ;
  public static final int SCPT_NOM_RPM                             = 158  ;
  public static final int SCPT_NOM_FREQ                            = 159  ;
  public static final int SCPT_RAMP_UP_TM                          = 160  ;
  public static final int SCPT_RAMP_DOWN_TM                        = 161  ;
  public static final int SCPT_DEF_SCALE                           = 162  ;
  public static final int SCPT_REG_NAME                            = 163  ;
  public static final int SCPT_BASE_VALUE                          = 164  ;
  public static final int SCPT_DEV_MAJ_VER                         = 165  ;
  public static final int SCPT_DEV_MIN_VER                         = 166  ;
  public static final int SCPT_OBJ_MAJ_VER                         = 167  ;
  public static final int SCPT_OBJ_MIN_VER                         = 168  ;
  public static final int SCPT_HVAC_TYPE                           = 169  ;
  public static final int SCPT_TIMEOUT                             = 170  ;
  public static final int SCPT_CONTROL_PRIORITY                    = 171  ;
  public static final int SCPT_DEVICE_GROUP_ID                     = 172  ;
  public static final int SCPT_MAX_PRIVACY_ZONES                   = 173  ;
  public static final int SCPT_MAX_CAMERA_PREPOSITIONS             = 174  ;
  public static final int SCPT_DEFAULT_PAN_TILT_ZOOM_SPEEDS        = 175  ;
  public static final int SCPT_DEFAULT_AUTO_PAN_SPEED              = 176  ;
  public static final int SCPT_AUTO_ANSWER                         = 177  ;
  public static final int SCPT_DIAL_STRING                         = 178  ;
  public static final int SCPT_SERIAL_NUMBER                       = 179  ;
  public static final int SCPT_NORMAL_ROTATIONAL_SPEED             = 180  ;
  public static final int SCPT_STANDBY_ROTATIONAL_SPEED            = 181  ;
  public static final int SCPT_PART_NUMBER                         = 182  ;
  public static final int SCPT_DISCHARGE_AIR_COOLING_SETPOINT      = 183  ;
  public static final int SCPT_DISCHARGE_AIR_HEATING_SETPOINT      = 184  ;
  public static final int SCPT_MAX_SUPPLY_FAN_CAPACITY             = 185  ;
  public static final int SCPT_MIN_SUPPLY_FAN_CAPACITY             = 186  ;
  public static final int SCPT_MAX_RETURN_EXHAUST_FAN_CAPACITY     = 187  ;
  public static final int SCPT_MIN_RETURN_EXHAUST_FAN_CAPACITY     = 188  ;
  public static final int SCPT_DUCT_STATIC_PRESSURE_SETPOINT       = 189  ;
  public static final int SCPT_MAX_DUCT_STATIC_PRESSURE_SETPOINT   = 190  ;
  public static final int SCPT_MIN_DUCT_STATIC_PRESSURE_SETPOINT   = 191  ;
  public static final int SCPT_DUCT_STATIC_PRESSURE_LIMIT          = 192  ;
  public static final int SCPT_BUILDING_STATIC_PRESSURE_SETPOINT   = 193  ;
  public static final int SCPT_RETURN_FAN_STATIC_PRESSURE_SETPOINT = 194  ;
  public static final int SCPT_FAN_DIFFERENTIAL_SETPOINT           = 195  ;
  public static final int SCPT_MIXED_AIR_LOW_LIMIT_SETPOINT        = 196  ;
  public static final int SCPT_MIXED_AIR_TEMP_SETPOINT             = 197  ;
  public static final int SCPT_MIN_OUTDOOR_AIR_FLOW_SETPOINT       = 198  ;
  public static final int SCPT_OUTDOOR_AIR_TEMP_SETPOINT           = 199  ;
  public static final int SCPT_OUTDOOR_AIR_ENTHALPY_SETPOINT       = 200  ;
  public static final int SCPT_DIFF_TEMP_SETPOINT                  = 201  ;
  public static final int SCPT_EXHAUST_ENABLE_POSITION             = 202  ;
  public static final int SCPT_SPACE_HUM_SETPOINT                  = 203  ;
  public static final int SCPT_DISCHARGE_AIR_DEWPOINT_SETPOINT     = 204  ;
  public static final int SCPT_MAX_DISCHARGE_AIR_COOLING_SETPOINT  = 205  ;
  public static final int SCPT_MIN_DISCHARGE_AIR_COOLING_SETPOINT  = 206  ;
  public static final int SCPT_MAX_DISCHARGE_AIR_HEATING_SETPOINT  = 207  ;
  public static final int SCPT_MIN_DISCHARGE_AIR_HEATING_SETPOINT  = 208  ;
  public static final int SCPT_COOLING_LOCKOUT                     = 209  ;
  public static final int SCPT_HEATING_LOCKOUT                     = 210  ;
  public static final int SCPT_COOLING_RESET_ENABLE                = 211  ;
  public static final int SCPT_HEATING_RESET_ENABLE                = 212  ;
  public static final int SCPT_SETPOINT                            = 213  ;
  public static final int SCPT_TEMPERATURE_HYSTERESIS              = 214  ;
  public static final int SCPT_CONTROL_TEMPERATURE_WEIGHTING       = 215  ;
  public static final int SCPT_PWM_PERIOD                          = 216  ;
  public static final int SCPT_DEFROST_INTERNAL_SCHEDULE           = 217  ;
  public static final int SCPT_DEFROST_START                       = 218  ;
  public static final int SCPT_DEFROST_CYCLES                      = 219  ;
  public static final int SCPT_MIN_DEFROST_TIME                    = 220  ;
  public static final int SCPT_MAX_DEFROST_TIME                    = 221  ;
  public static final int SCPT_DEFROST_FAN_DELAY                   = 222  ;
  public static final int SCPT_DEFROST_RECOVERY_TIME               = 223  ;
  public static final int SCPT_DEFROST_HOLD                        = 224  ;
  public static final int SCPT_DEFROST_DETECT                      = 225  ;
  public static final int SCPT_SCHEDULE_INTERNAL                   = 226  ;
  public static final int SCPT_TEMP_OFFSET                         = 227  ;
  public static final int SCPT_AUDIBLE_LEVEL                       = 228  ;
  public static final int SCPT_SCROLL_SPEED                        = 229  ;
  public static final int SCPT_BRIGHTNESS                          = 230  ;
  public static final int SCPT_ORIENTATION                         = 231  ;
  public static final int SCPT_INSTALLED_LEVEL                     = 232  ;
  public static final int SCPT_PUMP_CHARACTERISTIC                 = 233  ;
  public static final int SCPT_MIN_PRESSURE_SETPOINT               = 234  ;
  public static final int SCPT_MAX_PRESSURE_SETPOINT               = 235  ;
  public static final int SCPT_MIN_FLOW_SETPOINT                   = 236  ;
  public static final int SCPT_MAX_FLOW_SETPOINT                   = 237  ;
  public static final int SCPT_DEVICE_CONTROL_MODE                 = 238  ;
  public static final int SCPT_MIN_REMOTE_PRESSURE_SETPOINT        = 239  ;
  public static final int SCPT_MAX_REMOTE_PRESSURE_SETPOINT        = 240  ;
  public static final int SCPT_MIN_REMOTE_FLOW_SETPOINT            = 241  ;
  public static final int SCPT_MAX_REMOTE_FLOW_SETPOINT            = 242  ;
  public static final int SCPT_MIN_REMOTE_TEMP_SETPOINT            = 243  ;
  public static final int SCPT_MAX_REMOTE_TEMP_SETPOINT            = 244  ;
  public static final int SCPT_CONTROL_SIGNAL                      = 245  ;
  public static final int SCPT_NIGHT_PURGE_POSITION                = 246  ;
  public static final int SCPT_FREE_COOL_POSITION                  = 247  ;
  public static final int SCPT_VALVE_FLOW_CHARACTERISTIC           = 248  ;
  public static final int SCPT_VALVE_OPERATING_MODE                = 249  ;
  public static final int SCPT_EMERGENCY_POSITION                  = 250  ;
  public static final int SCPT_BLOCK_PROTECTION_TIME               = 251  ;
  public static final int SCPT_MIN_STROKE                          = 252  ;
  public static final int SCPT_MAX_STROKE                          = 253  ;
  public static final int SCPT_NV_TYPE                             = 254  ;
  public static final int SCPT_MAX_NV_LENGTH                       = 255  ;
  public static final int SCPT_NV_DYNAMIC_ASSIGNMENT               = 256  ;
  public static final int SCPT_SAF_EXT_CNFG                        = 257  ;
  public static final int SCPT_EMERG_CNFG                          = 258  ;
  public static final int SCPT_SLUICE_CNFG                         = 259  ;
  public static final int SCPT_FAN_OPERATION                       = 260  ;
  public static final int SCPT_MIN_FLOW_UNIT                       = 261  ;
  public static final int SCPT_MAX_FLOW_UNIT                       = 262  ;
  public static final int SCPT_MIN_FLOW_HEAT_STBY                  = 263  ;
  public static final int SCPT_MIN_FLOW_UNIT_STBY                  = 264  ;
  public static final int SCPT_OFFSET_FLOW                         = 265  ;
  public static final int SCPT_AREA_DUCT_HEAT                      = 266  ;
  public static final int SCPT_NOM_AIR_FLOW_HEAT                   = 267  ;
  public static final int SCPT_GAIN_VAV_HEAT                       = 268  ;
  public static final int SCPT_NUM_DAMPERS                         = 269  ;
  public static final int SCPT_MIN_FLOW_UNIT_HEAT                  = 270  ;
  public static final int SCPT_SATURATION_DELAY                    = 271  ;
  public static final int SCPT_EFFECTIVE_PERIOD                    = 272  ;
  public static final int SCPT_SCHEDULE_DATES                      = 273  ;
  public static final int SCPT_SCHEDULE                            = 274  ;
  public static final int SCPT_SCHEDULE_TIME_VALUE                 = 275  ;
  public static final int SCPT_VALUE_DEFINITION                    = 276  ;
  public static final int SCPT_VALUE_NAME                          = 277  ;
  public static final int SCPT_WEEKLY_SCHEDULE                     = 278  ;
  public static final int SCPT_SCHEDULE_NAME                       = 279  ;

  public static final int SCPT_VALVE_STROKE                        = 280  ;
  public static final int SCPT_VALVE_NOMINAL_SIZE                  = 281  ;
  public static final int SCPT_VALVE_KVS                           = 282  ;
  public static final int SCPT_VALVE_TYPE                          = 283  ;
  public static final int SCPT_ACTUATOR_CHARACTERISTIC             = 284  ;
  public static final int SCPT_TRNS_TBL_X2                         = 285  ;
  public static final int SCPT_TRNS_TBL_Y2                         = 286  ;
  public static final int SCPT_COMB_FLOW_CHARACTERISTIC            = 287  ;
  public static final int SCPT_TRNS_TBL_X3                         = 288  ;
  public static final int SCPT_TRNS_TBL_Y3                         = 289  ;
  public static final int SCPT_RUN_TIME_ALARM                      = 290  ;
  public static final int SCPT_TIME_PERIOD                         = 291  ;
  public static final int SCPT_PULSE_VALUE                         = 292  ;
  public static final int SCPT_NUM_DIGITS                          = 293  ;
  public static final int SCPT_IDENTITY                            = 294  ;
  public static final int SCPT_DEFAULT_STATE                       = 295  ;
  public static final int SCPT_NV_PRIORITY                         = 296  ;
  public static final int SCPT_DEFAULT_SETTING                     = 297  ;
  public static final int SCPT_LOW_LIMIT1_ENABLE                   = 298  ;
  public static final int SCPT_LOW_LIMIT2_ENABLE                   = 299  ;
  public static final int SCPT_CLOCK_CALIBRATION                   = 300  ;
  public static final int SCPT_NEURON_ID                           = 301  ;
  public static final int SCPT_HIGH_LIMIT1_ENABLE                  = 302  ;
  public static final int SCPT_HIGH_LIMIT2_ENABLE                  = 303  ;
  public static final int SCPT_AHAM_APPLIANCE_MODEL                = 304  ;

  // Version 13.04
  public static final int SCPT_DEF_INPUT                           = 305  ;
  public static final int SCPT_NAME1                               = 306  ;
  public static final int SCPT_SCENE                               = 307  ;
  public static final int SCPT_SCENE_TIMING                        = 308  ;
  public static final int SCPT_NAME2                               = 309  ;
  public static final int SCPT_NAME3                               = 310  ;
  public static final int SCPT_BUTTON_PRESS_ACTION                 = 311  ;
  public static final int SCPT_BUTTON_COLOR                        = 312  ;
  public static final int SCPT_BUTTON_REPEAT_INTERVAL              = 313  ;
  public static final int SCPT_BUTTON_HOLD_ACTION                  = 314  ;
  public static final int SCPT_PWR_SEND_ON_DELTA                   = 315  ;
  public static final int SCPT_SCENE_NAME                          = 316  ;
  public static final int SCPT_MAX_POWER                           = 317  ;
  public static final int SCPT_IFACE_DESC                          = 318  ;
  public static final int SCPT_MON_INTERVAL                        = 319  ;
  public static final int SCPT_LINK_POWER_DETECT_ENABLE            = 320  ;
  public static final int SCPT_SCAN_TIME                           = 321  ;
  public static final int SCPT_DEV_LIST_DESC                       = 322  ;
  public static final int SCPT_DEV_LIST_ENTRY                      = 323  ;
  public static final int SCPT_LOG_CAPACITY                        = 324  ;
  public static final int SCPT_LOG_NOTIFICATION_THRESHOLD          = 325  ;
  public static final int SCPT_LOG_SIZE                            = 326  ;
  public static final int SCPT_LOG_TYPE                            = 327  ;
  public static final int SCPT_FAN_IN_ENABLE                       = 328  ;
  public static final int SCPT_LOG_TIMESTAMP_ENABLE                = 329  ;
  public static final int SCPT_LOG_HIGH_LIMIT                      = 330  ;
  public static final int SCPT_LOG_LOW_LIMIT                       = 331  ;
  public static final int SCPT_MAX_FAN_IN                          = 332  ;
  public static final int SCPT_LOG_MIN_DELTA_TIME                  = 333  ;
  public static final int SCPT_LOG_MIN_DELTA_VALUE                 = 334  ;
  public static final int SCPT_POLL_RATE                           = 335  ;
  public static final int SCPT_SOURCE_ADDRESS                      = 336  ;
  public static final int SCPT_LOG_RECORD                          = 337  ;
  public static final int SCPT_LOG_FILE_HEADER                     = 338  ;
  public static final int SCPT_LOG_ALARM_THRESHOLD                 = 339  ;
  public static final int SCPT_LOG_REQUEST                         = 340  ;
  public static final int SCPT_LOG_RESPONSE                        = 341  ;
  public static final int SCPT_LIGHTING_GROUP_ENABLE               = 342  ;
  public static final int SCPT_SCENE_COLOR                         = 343  ;
  public static final int SCPT_BKUP_SCHEDULE                       = 344  ;
  public static final int SCPT_OLC_LIMITS                          = 345  ;
  public static final int SCPT_LAMP_POWER                          = 346  ;
  public static final int SCPT_DEVICE_OUT_SELECTION                = 347  ;
  public static final int SCPT_ENABLE_STATUS_MSG                   = 348  ;
  public static final int SCPT_MAX_LEVEL_VOLT                      = 349  ;
  public static final int SCPT_GEO_LOCATION                        = 350  ;

  // Version 13.20
  public static final int SCPT_PROG_NAME                           = 351  ;
  public static final int SCPT_PROG_REVISION                       = 352  ;
  public static final int SCPT_PROG_SELECT                         = 353  ;
  public static final int SCPT_PROG_SOURCE_LOCATION                = 354  ;
  public static final int SCPT_PROG_FILE_INDEXES                   = 355  ;
  public static final int SCPT_PROG_CMD_HISTORY                    = 356  ;
  public static final int SCPT_PROG_STATE_HISTORY                  = 357  ;
  public static final int SCPT_NSDS_FB_INDEX                       = 358  ;
  public static final int SCPT_CURRENT_SENSE_ENABLE                = 359  ;
  public static final int SCPT_MEASUREMENT_INTERVAL                = 360  ;
  public static final int SCPT_LIGHTING_GROUP_MEMBERSHIP           = 361  ;
  public static final int SCPT_LOAD_CONTROL_OFFSET                 = 362  ;
  public static final int SCPT_PROG_ERROR_HISTORY                  = 363  ;
  public static final int SCPT_NV_USAGE                            = 364  ;
  public static final int SCPT_SCHEDULE_SUNDAY                     = 365  ;
  public static final int SCPT_SCHEDULE_MONDAY                     = 366  ;
  public static final int SCPT_SCHEDULE_TUESDAY                    = 367  ;
  public static final int SCPT_SCHEDULE_WEDNESDAY                  = 368  ;
  public static final int SCPT_SCHEDULE_THURSDAY                   = 369  ;
  public static final int SCPT_SCHEDULE_FRIDAY                     = 370  ;
  public static final int SCPT_SCHEDULE_SATURDAY                   = 371  ;
  public static final int SCPT_OCCUPANCY_BEHAVIOR                  = 372  ;
  public static final int SCPT_TIME_SOURCE                         = 373  ;
  public static final int SCPT_SCHEDULE_EXCEPTION                  = 374  ;
  public static final int SCPT_SCHEDULE_HOLIDAY                    = 375  ;
  public static final int SCPT_RANDOMIZATION_INTERVAL              = 376  ;
  public static final int SCPT_SUNRISE_TIME                        = 377  ;
  public static final int SCPT_SUNSET_TIME                         = 378  ;
  public static final int SCPT_SCHEDULER_OPTIONS                   = 379  ;
  public static final int SCPT_OCCUPANCY_THRESHOLDS                = 380  ;

  public static final int LAST_SCPT_ID  = 380 ;

  public static final BLonScptType ScptXxx         = new BLonScptType(SCPT_XXX         );

  public static final BLonScptType ScptActFbDly                        = new BLonScptType(SCPT_ACT_FB_DLY                         );
  public static final BLonScptType ScptAlrmClrT1                       = new BLonScptType(SCPT_ALRM_CLR_T_1                       );
  public static final BLonScptType ScptAlrmClrT2                       = new BLonScptType(SCPT_ALRM_CLR_T_2                       );
  public static final BLonScptType ScptAlrmIhbT                        = new BLonScptType(SCPT_ALRM_IHB_T                         );
  public static final BLonScptType ScptAlrmSetT1                       = new BLonScptType(SCPT_ALRM_SET_T_1                       );
  public static final BLonScptType ScptAlrmSetT2                       = new BLonScptType(SCPT_ALRM_SET_T_2                       );
  public static final BLonScptType ScptDefOutput                       = new BLonScptType(SCPT_DEF_OUTPUT                         );
  public static final BLonScptType ScptDriveT                          = new BLonScptType(SCPT_DRIVE_T                            );
  public static final BLonScptType ScptHighLimit1                      = new BLonScptType(SCPT_HIGH_LIMIT_1                       );
  public static final BLonScptType ScptHighLimit2                      = new BLonScptType(SCPT_HIGH_LIMIT_2                       );
  public static final BLonScptType ScptHystHigh1                       = new BLonScptType(SCPT_HYST_HIGH_1                        );
  public static final BLonScptType ScptHystHigh2                       = new BLonScptType(SCPT_HYST_HIGH_2                        );
  public static final BLonScptType ScptHystLow1                        = new BLonScptType(SCPT_HYST_LOW_1                         );
  public static final BLonScptType ScptHystLow2                        = new BLonScptType(SCPT_HYST_LOW_2                         );
  public static final BLonScptType ScptInFbDly                         = new BLonScptType(SCPT_IN_FB_DLY                          );
  public static final BLonScptType ScptInvrtOut                        = new BLonScptType(SCPT_INVRT_OUT                          );
  public static final BLonScptType ScptLocation                        = new BLonScptType(SCPT_LOCATION                           );
  public static final BLonScptType ScptLowLimit1                       = new BLonScptType(SCPT_LOW_LIMIT_1                        );
  public static final BLonScptType ScptLowLimit2                       = new BLonScptType(SCPT_LOW_LIMIT_2                        );
  public static final BLonScptType ScptMaxRnge                         = new BLonScptType(SCPT_MAX_RNGE                           );
  public static final BLonScptType ScptMaxRcvT                         = new BLonScptType(SCPT_MAX_RCV_T                          );
  public static final BLonScptType ScptMaxSndT                         = new BLonScptType(SCPT_MAX_SND_T                          );
  public static final BLonScptType ScptMinRnge                         = new BLonScptType(SCPT_MIN_RNGE                           );
  public static final BLonScptType ScptMinSndT                         = new BLonScptType(SCPT_MIN_SND_T                          );
  public static final BLonScptType ScptNwrkCnfg                        = new BLonScptType(SCPT_NWRK_CNFG                          );
  public static final BLonScptType ScptOffset                          = new BLonScptType(SCPT_OFFSET                             );
  public static final BLonScptType ScptSndDelta                        = new BLonScptType(SCPT_SND_DELTA                          );
  public static final BLonScptType ScptTrnsTblX                        = new BLonScptType(SCPT_TRNS_TBL_X                         );
  public static final BLonScptType ScptTrnsTblY                        = new BLonScptType(SCPT_TRNS_TBL_Y                         );
  public static final BLonScptType ScptOffDely                         = new BLonScptType(SCPT_OFF_DELY                           );
  public static final BLonScptType ScptGain                            = new BLonScptType(SCPT_GAIN                               );
  public static final BLonScptType ScptOvrBehave                       = new BLonScptType(SCPT_OVR_BEHAVE                         );
  public static final BLonScptType ScptOvrValue                        = new BLonScptType(SCPT_OVR_VALUE                          );
  public static final BLonScptType ScptBypassTime                      = new BLonScptType(SCPT_BYPASS_TIME                        );
  public static final BLonScptType ScptManOvrTime                      = new BLonScptType(SCPT_MAN_OVR_TIME                       );
  public static final BLonScptType ScptHumSetpt                        = new BLonScptType(SCPT_HUM_SETPT                          );
  public static final BLonScptType ScptMaxFlowHeat                     = new BLonScptType(SCPT_MAX_FLOW_HEAT                      );
  public static final BLonScptType ScptFireInitType                    = new BLonScptType(SCPT_FIRE_INIT_TYPE                     );
  public static final BLonScptType ScptSmokeNomSens                    = new BLonScptType(SCPT_SMOKE_NOM_SENS                     );
  public static final BLonScptType ScptSmokeDayAlrmLim                 = new BLonScptType(SCPT_SMOKE_DAY_ALRM_LIM                 );
  public static final BLonScptType ScptActuatorType                    = new BLonScptType(SCPT_ACTUATOR_TYPE                      );
  public static final BLonScptType ScptLimitCO2                        = new BLonScptType(SCPT_LIMIT_CO_2                         );
  public static final BLonScptType ScptMinDeltaAngl                    = new BLonScptType(SCPT_MIN_DELTA_ANGL                     );
  public static final BLonScptType ScptDirection                       = new BLonScptType(SCPT_DIRECTION                          );
  public static final BLonScptType ScptDriveTime                       = new BLonScptType(SCPT_DRIVE_TIME                         );
  public static final BLonScptType ScptDuctArea                        = new BLonScptType(SCPT_DUCT_AREA                          );
  public static final BLonScptType ScptMinDeltaFlow                    = new BLonScptType(SCPT_MIN_DELTA_FLOW                     );
  public static final BLonScptType ScptMaxRcvTime                      = new BLonScptType(SCPT_MAX_RCV_TIME                       );
  public static final BLonScptType ScptMaxSendTime                     = new BLonScptType(SCPT_MAX_SEND_TIME                      );
  public static final BLonScptType ScptMaxSetpoint                     = new BLonScptType(SCPT_MAX_SETPOINT                       );
  public static final BLonScptType ScptMaxFlow                         = new BLonScptType(SCPT_MAX_FLOW                           );
  public static final BLonScptType ScptMinSendTime                     = new BLonScptType(SCPT_MIN_SEND_TIME                      );
  public static final BLonScptType ScptMinSetpoint                     = new BLonScptType(SCPT_MIN_SETPOINT                       );
  public static final BLonScptType ScptMinFlow                         = new BLonScptType(SCPT_MIN_FLOW                           );
  public static final BLonScptType ScptMinFlowHeat                     = new BLonScptType(SCPT_MIN_FLOW_HEAT                      );
  public static final BLonScptType ScptMinFlowStby                     = new BLonScptType(SCPT_MIN_FLOW_STBY                      );
  public static final BLonScptType ScptNomAirFlow                      = new BLonScptType(SCPT_NOM_AIR_FLOW                       );
  public static final BLonScptType ScptNomAngle                        = new BLonScptType(SCPT_NOM_ANGLE                          );
  public static final BLonScptType ScptNumValves                       = new BLonScptType(SCPT_NUM_VALVES                         );
  public static final BLonScptType ScptSetPnts                         = new BLonScptType(SCPT_SET_PNTS                           );
  public static final BLonScptType ScptOemType                         = new BLonScptType(SCPT_OEM_TYPE                           );
  public static final BLonScptType ScptMinDeltaRH                      = new BLonScptType(SCPT_MIN_DELTA_RH                       );
  public static final BLonScptType ScptMinDeltaCO2                     = new BLonScptType(SCPT_MIN_DELTA_CO_2                     );
  public static final BLonScptType ScptMinDeltaTemp                    = new BLonScptType(SCPT_MIN_DELTA_TEMP                     );
  public static final BLonScptType ScptSensConstTmp                    = new BLonScptType(SCPT_SENS_CONST_TMP                     );
  public static final BLonScptType ScptGainVAV                         = new BLonScptType(SCPT_GAIN_VAV                           );
  public static final BLonScptType ScptSensConstVAV                    = new BLonScptType(SCPT_SENS_CONST_VAV                     );
  public static final BLonScptType ScptOffsetCO2                       = new BLonScptType(SCPT_OFFSET_CO_2                        );
  public static final BLonScptType ScptOffsetRH                        = new BLonScptType(SCPT_OFFSET_RH                          );
  public static final BLonScptType ScptOffsetTemp                      = new BLonScptType(SCPT_OFFSET_TEMP                        );
  public static final BLonScptType ScptDefltBehave                     = new BLonScptType(SCPT_DEFLT_BEHAVE                       );
  public static final BLonScptType ScptPwrUpDelay                      = new BLonScptType(SCPT_PWR_UP_DELAY                       );
  public static final BLonScptType ScptPwrUpState                      = new BLonScptType(SCPT_PWR_UP_STATE                       );
  public static final BLonScptType ScptHvacMode                        = new BLonScptType(SCPT_HVAC_MODE                          );
  public static final BLonScptType ScptCoolSetpt                       = new BLonScptType(SCPT_COOL_SETPT                         );
  public static final BLonScptType ScptCoolLowerSP                     = new BLonScptType(SCPT_COOL_LOWER_SP                      );
  public static final BLonScptType ScptCoolUpperSP                     = new BLonScptType(SCPT_COOL_UPPER_SP                      );
  public static final BLonScptType ScptHeatSetpt                       = new BLonScptType(SCPT_HEAT_SETPT                         );
  public static final BLonScptType ScptHeatLowerSP                     = new BLonScptType(SCPT_HEAT_LOWER_SP                      );
  public static final BLonScptType ScptHeatUpperSP                     = new BLonScptType(SCPT_HEAT_UPPER_SP                      );
  public static final BLonScptType ScptLimitChlrCap                    = new BLonScptType(SCPT_LIMIT_CHLR_CAP                     );
  public static final BLonScptType ScptLuxSetpoint                     = new BLonScptType(SCPT_LUX_SETPOINT                       );
  public static final BLonScptType ScptStep                            = new BLonScptType(SCPT_STEP                               );
  public static final BLonScptType ScptOnOffHysteresis                 = new BLonScptType(SCPT_ON_OFF_HYSTERESIS                  );
  public static final BLonScptType ScptClOffDelay                      = new BLonScptType(SCPT_CL_OFF_DELAY                       );
  public static final BLonScptType ScptClOnDelay                       = new BLonScptType(SCPT_CL_ON_DELAY                        );
  public static final BLonScptType ScptPowerupState                    = new BLonScptType(SCPT_POWERUP_STATE                      );
  public static final BLonScptType ScptMinDeltaLevel                   = new BLonScptType(SCPT_MIN_DELTA_LEVEL                    );
  public static final BLonScptType ScptReflection                      = new BLonScptType(SCPT_REFLECTION                         );
  public static final BLonScptType ScptFieldCalib                      = new BLonScptType(SCPT_FIELD_CALIB                        );
  public static final BLonScptType ScptHoldTime                        = new BLonScptType(SCPT_HOLD_TIME                          );
  public static final BLonScptType ScptStepValue                       = new BLonScptType(SCPT_STEP_VALUE                         );
  public static final BLonScptType ScptMaxOut                          = new BLonScptType(SCPT_MAX_OUT                            );
  public static final BLonScptType ScptSceneNmbr                       = new BLonScptType(SCPT_SCENE_NMBR                         );
  public static final BLonScptType ScptFadeTime                        = new BLonScptType(SCPT_FADE_TIME                          );
  public static final BLonScptType ScptDelayTime                       = new BLonScptType(SCPT_DELAY_TIME                         );
  public static final BLonScptType ScptMasterSlave                     = new BLonScptType(SCPT_MASTER_SLAVE                       );
  public static final BLonScptType ScptUpdateRate                      = new BLonScptType(SCPT_UPDATE_RATE                        );
  public static final BLonScptType ScptSummerTime                      = new BLonScptType(SCPT_SUMMER_TIME                        );
  public static final BLonScptType ScptWinterTime                      = new BLonScptType(SCPT_WINTER_TIME                        );
  public static final BLonScptType ScptManualAllowed                   = new BLonScptType(SCPT_MANUAL_ALLOWED                     );
  public static final BLonScptType ScptDefWeekMask                     = new BLonScptType(SCPT_DEF_WEEK_MASK                      );
  public static final BLonScptType ScptDayDateIndex                    = new BLonScptType(SCPT_DAY_DATE_INDEX                     );
  public static final BLonScptType ScptTimeEvent                       = new BLonScptType(SCPT_TIME_EVENT                         );
  public static final BLonScptType ScptModeHrtBt                       = new BLonScptType(SCPT_MODE_HRT_BT                        );
  public static final BLonScptType ScptDefrostMode                     = new BLonScptType(SCPT_DEFROST_MODE                       );
  public static final BLonScptType ScptMaxDefrstTime                   = new BLonScptType(SCPT_MAX_DEFRST_TIME                    );
  public static final BLonScptType ScptDrainDelay                      = new BLonScptType(SCPT_DRAIN_DELAY                        );
  public static final BLonScptType ScptInjDelay                        = new BLonScptType(SCPT_INJ_DELAY                          );
  public static final BLonScptType ScptMaxDefrstTemp                   = new BLonScptType(SCPT_MAX_DEFRST_TEMP                    );
  public static final BLonScptType ScptStrtupDelay                     = new BLonScptType(SCPT_STRTUP_DELAY                       );
  public static final BLonScptType ScptTermTimeTemp                    = new BLonScptType(SCPT_TERM_TIME_TEMP                     );
  public static final BLonScptType ScptPumpDownDelay                   = new BLonScptType(SCPT_PUMP_DOWN_DELAY                    );
  public static final BLonScptType ScptSuperHtRefInit                  = new BLonScptType(SCPT_SUPER_HT_REF_INIT                  );
  public static final BLonScptType ScptStrtupOpen                      = new BLonScptType(SCPT_STRTUP_OPEN                        );
  public static final BLonScptType ScptSuperHtRefMin                   = new BLonScptType(SCPT_SUPER_HT_REF_MIN                   );
  public static final BLonScptType ScptRefrigGlide                     = new BLonScptType(SCPT_REFRIG_GLIDE                       );
  public static final BLonScptType ScptSuperHtRefMax                   = new BLonScptType(SCPT_SUPER_HT_REF_MAX                   );
  public static final BLonScptType ScptRefrigType                      = new BLonScptType(SCPT_REFRIG_TYPE                        );
  public static final BLonScptType ScptThermMode                       = new BLonScptType(SCPT_THERM_MODE                         );
  public static final BLonScptType ScptDayNightCntrl                   = new BLonScptType(SCPT_DAY_NIGHT_CNTRL                    );
  public static final BLonScptType ScptDiffNight                       = new BLonScptType(SCPT_DIFF_NIGHT                         );
  public static final BLonScptType ScptHighLimTemp                     = new BLonScptType(SCPT_HIGH_LIM_TEMP                      );
  public static final BLonScptType ScptHighLimDly                      = new BLonScptType(SCPT_HIGH_LIM_DLY                       );
  public static final BLonScptType ScptCutOutValue                     = new BLonScptType(SCPT_CUT_OUT_VALUE                      );
  public static final BLonScptType ScptAirTemp1Day                     = new BLonScptType(SCPT_AIR_TEMP_1_DAY                     );
  public static final BLonScptType ScptSmokeNightAlrmLim               = new BLonScptType(SCPT_SMOKE_NIGHT_ALRM_LIM               );
  public static final BLonScptType ScptLowLimTemp                      = new BLonScptType(SCPT_LOW_LIM_TEMP                       );
  public static final BLonScptType ScptLowLimDly                       = new BLonScptType(SCPT_LOW_LIM_DLY                        );
  public static final BLonScptType ScptDiffValue                       = new BLonScptType(SCPT_DIFF_VALUE                         );
  public static final BLonScptType ScptAirTemp1Night                   = new BLonScptType(SCPT_AIR_TEMP_1_NIGHT                   );
  public static final BLonScptType ScptAirTemp1Alrm                    = new BLonScptType(SCPT_AIR_TEMP_1_ALRM                    );
  public static final BLonScptType ScptHighLimDefrDly                  = new BLonScptType(SCPT_HIGH_LIM_DEFR_DLY                  );
  public static final BLonScptType ScptDeltaNight                      = new BLonScptType(SCPT_DELTA_NIGHT                        );
  public static final BLonScptType ScptRunHrInit                       = new BLonScptType(SCPT_RUN_HR_INIT                        );
  public static final BLonScptType ScptRunHrAlarm                      = new BLonScptType(SCPT_RUN_HR_ALARM                       );
  public static final BLonScptType ScptEnergyCntInit                   = new BLonScptType(SCPT_ENERGY_CNT_INIT                    );
  public static final BLonScptType ScptSmokeDayPreAlrmLim              = new BLonScptType(SCPT_SMOKE_DAY_PRE_ALRM_LIM             );
  public static final BLonScptType ScptDebounce                        = new BLonScptType(SCPT_DEBOUNCE                           );
  public static final BLonScptType ScptSmokeNightPreAlrmLim            = new BLonScptType(SCPT_SMOKE_NIGHT_PRE_ALRM_LIM           );
  public static final BLonScptType ScptZoneNum                         = new BLonScptType(SCPT_ZONE_NUM                           );
  public static final BLonScptType ScptThermAlrmROR                    = new BLonScptType(SCPT_THERM_ALRM_ROR                     );
  public static final BLonScptType ScptVisOutput                       = new BLonScptType(SCPT_VIS_OUTPUT                         );
  public static final BLonScptType ScptAudOutput                       = new BLonScptType(SCPT_AUD_OUTPUT                         );
  public static final BLonScptType ScptFlashFreq                       = new BLonScptType(SCPT_FLASH_FREQ                         );
  public static final BLonScptType ScptInstallDate                     = new BLonScptType(SCPT_INSTALL_DATE                       );
  public static final BLonScptType ScptMaintDate                       = new BLonScptType(SCPT_MAINT_DATE                         );
  public static final BLonScptType ScptManfDate                        = new BLonScptType(SCPT_MANF_DATE                          );
  public static final BLonScptType ScptFireTxt1                        = new BLonScptType(SCPT_FIRE_TXT_1                         );
  public static final BLonScptType ScptFireTxt2                        = new BLonScptType(SCPT_FIRE_TXT_2                         );
  public static final BLonScptType ScptFireTxt3                        = new BLonScptType(SCPT_FIRE_TXT_3                         );
  public static final BLonScptType ScptThermThreshold                  = new BLonScptType(SCPT_THERM_THRESHOLD                    );
  public static final BLonScptType ScptFireIndicate                    = new BLonScptType(SCPT_FIRE_INDICATE                      );
  public static final BLonScptType ScptTimeZone                        = new BLonScptType(SCPT_TIME_ZONE                          );
  public static final BLonScptType ScptPrimeVal                        = new BLonScptType(SCPT_PRIME_VAL                          );
  public static final BLonScptType ScptSecondVal                       = new BLonScptType(SCPT_SECOND_VAL                         );
  public static final BLonScptType ScptSceneOffset                     = new BLonScptType(SCPT_SCENE_OFFSET                       );
  public static final BLonScptType ScptNomRPM                          = new BLonScptType(SCPT_NOM_RPM                            );
  public static final BLonScptType ScptNomFreq                         = new BLonScptType(SCPT_NOM_FREQ                           );
  public static final BLonScptType ScptRampUpTm                        = new BLonScptType(SCPT_RAMP_UP_TM                         );
  public static final BLonScptType ScptRampDownTm                      = new BLonScptType(SCPT_RAMP_DOWN_TM                       );
  public static final BLonScptType ScptDefScale                        = new BLonScptType(SCPT_DEF_SCALE                          );
  public static final BLonScptType ScptRegName                         = new BLonScptType(SCPT_REG_NAME                           );
  public static final BLonScptType ScptBaseValue                       = new BLonScptType(SCPT_BASE_VALUE                         );
  public static final BLonScptType ScptDevMajVer                       = new BLonScptType(SCPT_DEV_MAJ_VER                        );
  public static final BLonScptType ScptDevMinVer                       = new BLonScptType(SCPT_DEV_MIN_VER                        );
  public static final BLonScptType ScptObjMajVer                       = new BLonScptType(SCPT_OBJ_MAJ_VER                        );
  public static final BLonScptType ScptObjMinVer                       = new BLonScptType(SCPT_OBJ_MIN_VER                        );
  public static final BLonScptType ScptHvacType                        = new BLonScptType(SCPT_HVAC_TYPE                          );
  public static final BLonScptType ScptTimeout                         = new BLonScptType(SCPT_TIMEOUT                            );
  public static final BLonScptType ScptControlPriority                 = new BLonScptType(SCPT_CONTROL_PRIORITY                   );
  public static final BLonScptType ScptDeviceGroupID                   = new BLonScptType(SCPT_DEVICE_GROUP_ID                    );
  public static final BLonScptType ScptMaxPrivacyZones                 = new BLonScptType(SCPT_MAX_PRIVACY_ZONES                  );
  public static final BLonScptType ScptMaxCameraPrepositions           = new BLonScptType(SCPT_MAX_CAMERA_PREPOSITIONS            );
  public static final BLonScptType ScptDefaultPanTiltZoomSpeeds        = new BLonScptType(SCPT_DEFAULT_PAN_TILT_ZOOM_SPEEDS       );
  public static final BLonScptType ScptDefaultAutoPanSpeed             = new BLonScptType(SCPT_DEFAULT_AUTO_PAN_SPEED             );
  public static final BLonScptType ScptAutoAnswer                      = new BLonScptType(SCPT_AUTO_ANSWER                        );
  public static final BLonScptType ScptDialString                      = new BLonScptType(SCPT_DIAL_STRING                        );
  public static final BLonScptType ScptSerialNumber                    = new BLonScptType(SCPT_SERIAL_NUMBER                      );
  public static final BLonScptType ScptNormalRotationalSpeed           = new BLonScptType(SCPT_NORMAL_ROTATIONAL_SPEED            );
  public static final BLonScptType ScptStandbyRotationalSpeed          = new BLonScptType(SCPT_STANDBY_ROTATIONAL_SPEED           );
  public static final BLonScptType ScptPartNumber                      = new BLonScptType(SCPT_PART_NUMBER                        );
  public static final BLonScptType ScptDischargeAirCoolingSetpoint     = new BLonScptType(SCPT_DISCHARGE_AIR_COOLING_SETPOINT     );
  public static final BLonScptType ScptDischargeAirHeatingSetpoint     = new BLonScptType(SCPT_DISCHARGE_AIR_HEATING_SETPOINT     );
  public static final BLonScptType ScptMaxSupplyFanCapacity            = new BLonScptType(SCPT_MAX_SUPPLY_FAN_CAPACITY            );
  public static final BLonScptType ScptMinSupplyFanCapacity            = new BLonScptType(SCPT_MIN_SUPPLY_FAN_CAPACITY            );
  public static final BLonScptType ScptMaxReturnExhaustFanCapacity     = new BLonScptType(SCPT_MAX_RETURN_EXHAUST_FAN_CAPACITY    );
  public static final BLonScptType ScptMinReturnExhaustFanCapacity     = new BLonScptType(SCPT_MIN_RETURN_EXHAUST_FAN_CAPACITY    );
  public static final BLonScptType ScptDuctStaticPressureSetpoint      = new BLonScptType(SCPT_DUCT_STATIC_PRESSURE_SETPOINT      );
  public static final BLonScptType ScptMaxDuctStaticPressureSetpoint   = new BLonScptType(SCPT_MAX_DUCT_STATIC_PRESSURE_SETPOINT  );
  public static final BLonScptType ScptMinDuctStaticPressureSetpoint   = new BLonScptType(SCPT_MIN_DUCT_STATIC_PRESSURE_SETPOINT  );
  public static final BLonScptType ScptDuctStaticPressureLimit         = new BLonScptType(SCPT_DUCT_STATIC_PRESSURE_LIMIT         );
  public static final BLonScptType ScptBuildingStaticPressureSetpoint  = new BLonScptType(SCPT_BUILDING_STATIC_PRESSURE_SETPOINT  );
  public static final BLonScptType ScptReturnFanStaticPressureSetpoint = new BLonScptType(SCPT_RETURN_FAN_STATIC_PRESSURE_SETPOINT);
  public static final BLonScptType ScptFanDifferentialSetpoint         = new BLonScptType(SCPT_FAN_DIFFERENTIAL_SETPOINT          );
  public static final BLonScptType ScptMixedAirLowLimitSetpoint        = new BLonScptType(SCPT_MIXED_AIR_LOW_LIMIT_SETPOINT       );
  public static final BLonScptType ScptMixedAirTempSetpoint            = new BLonScptType(SCPT_MIXED_AIR_TEMP_SETPOINT            );
  public static final BLonScptType ScptMinOutdoorAirFlowSetpoint       = new BLonScptType(SCPT_MIN_OUTDOOR_AIR_FLOW_SETPOINT      );
  public static final BLonScptType ScptOutdoorAirTempSetpoint          = new BLonScptType(SCPT_OUTDOOR_AIR_TEMP_SETPOINT          );
  public static final BLonScptType ScptOutdoorAirEnthalpySetpoint      = new BLonScptType(SCPT_OUTDOOR_AIR_ENTHALPY_SETPOINT      );
  public static final BLonScptType ScptDiffTempSetpoint                = new BLonScptType(SCPT_DIFF_TEMP_SETPOINT                 );
  public static final BLonScptType ScptExhaustEnablePosition           = new BLonScptType(SCPT_EXHAUST_ENABLE_POSITION            );
  public static final BLonScptType ScptSpaceHumSetpoint                = new BLonScptType(SCPT_SPACE_HUM_SETPOINT                 );
  public static final BLonScptType ScptDischargeAirDewpointSetpoint    = new BLonScptType(SCPT_DISCHARGE_AIR_DEWPOINT_SETPOINT    );
  public static final BLonScptType ScptMaxDischargeAirCoolingSetpoint  = new BLonScptType(SCPT_MAX_DISCHARGE_AIR_COOLING_SETPOINT );
  public static final BLonScptType ScptMinDischargeAirCoolingSetpoint  = new BLonScptType(SCPT_MIN_DISCHARGE_AIR_COOLING_SETPOINT );
  public static final BLonScptType ScptMaxDischargeAirHeatingSetpoint  = new BLonScptType(SCPT_MAX_DISCHARGE_AIR_HEATING_SETPOINT );
  public static final BLonScptType ScptMinDischargeAirHeatingSetpoint  = new BLonScptType(SCPT_MIN_DISCHARGE_AIR_HEATING_SETPOINT );
  public static final BLonScptType ScptCoolingLockout                  = new BLonScptType(SCPT_COOLING_LOCKOUT                    );
  public static final BLonScptType ScptHeatingLockout                  = new BLonScptType(SCPT_HEATING_LOCKOUT                    );
  public static final BLonScptType ScptCoolingResetEnable              = new BLonScptType(SCPT_COOLING_RESET_ENABLE               );
  public static final BLonScptType ScptHeatingResetEnable              = new BLonScptType(SCPT_HEATING_RESET_ENABLE               );
  public static final BLonScptType ScptSetpoint                        = new BLonScptType(SCPT_SETPOINT                           );
  public static final BLonScptType ScptTemperatureHysteresis           = new BLonScptType(SCPT_TEMPERATURE_HYSTERESIS             );
  public static final BLonScptType ScptControlTemperatureWeighting     = new BLonScptType(SCPT_CONTROL_TEMPERATURE_WEIGHTING      );
  public static final BLonScptType ScptPwmPeriod                       = new BLonScptType(SCPT_PWM_PERIOD                         );
  public static final BLonScptType ScptDefrostInternalSchedule         = new BLonScptType(SCPT_DEFROST_INTERNAL_SCHEDULE          );
  public static final BLonScptType ScptDefrostStart                    = new BLonScptType(SCPT_DEFROST_START                      );
  public static final BLonScptType ScptDefrostCycles                   = new BLonScptType(SCPT_DEFROST_CYCLES                     );
  public static final BLonScptType ScptMinDefrostTime                  = new BLonScptType(SCPT_MIN_DEFROST_TIME                   );
  public static final BLonScptType ScptMaxDefrostTime                  = new BLonScptType(SCPT_MAX_DEFROST_TIME                   );
  public static final BLonScptType ScptDefrostFanDelay                 = new BLonScptType(SCPT_DEFROST_FAN_DELAY                  );
  public static final BLonScptType ScptDefrostRecoveryTime             = new BLonScptType(SCPT_DEFROST_RECOVERY_TIME              );
  public static final BLonScptType ScptDefrostHold                     = new BLonScptType(SCPT_DEFROST_HOLD                       );
  public static final BLonScptType ScptDefrostDetect                   = new BLonScptType(SCPT_DEFROST_DETECT                     );
  public static final BLonScptType ScptScheduleInternal                = new BLonScptType(SCPT_SCHEDULE_INTERNAL                  );
  public static final BLonScptType ScptTempOffset                      = new BLonScptType(SCPT_TEMP_OFFSET                        );
  public static final BLonScptType ScptAudibleLevel                    = new BLonScptType(SCPT_AUDIBLE_LEVEL                      );
  public static final BLonScptType ScptScrollSpeed                     = new BLonScptType(SCPT_SCROLL_SPEED                       );
  public static final BLonScptType ScptBrightness                      = new BLonScptType(SCPT_BRIGHTNESS                         );
  public static final BLonScptType ScptOrientation                     = new BLonScptType(SCPT_ORIENTATION                        );
  public static final BLonScptType ScptInstalledLevel                  = new BLonScptType(SCPT_INSTALLED_LEVEL                    );
  public static final BLonScptType ScptPumpCharacteristic              = new BLonScptType(SCPT_PUMP_CHARACTERISTIC                );
  public static final BLonScptType ScptMinPressureSetpoint             = new BLonScptType(SCPT_MIN_PRESSURE_SETPOINT              );
  public static final BLonScptType ScptMaxPressureSetpoint             = new BLonScptType(SCPT_MAX_PRESSURE_SETPOINT              );
  public static final BLonScptType ScptMinFlowSetpoint                 = new BLonScptType(SCPT_MIN_FLOW_SETPOINT                  );
  public static final BLonScptType ScptMaxFlowSetpoint                 = new BLonScptType(SCPT_MAX_FLOW_SETPOINT                  );
  public static final BLonScptType ScptDeviceControlMode               = new BLonScptType(SCPT_DEVICE_CONTROL_MODE                );
  public static final BLonScptType ScptMinRemotePressureSetpoint       = new BLonScptType(SCPT_MIN_REMOTE_PRESSURE_SETPOINT       );
  public static final BLonScptType ScptMaxRemotePressureSetpoint       = new BLonScptType(SCPT_MAX_REMOTE_PRESSURE_SETPOINT       );
  public static final BLonScptType ScptMinRemoteFlowSetpoint           = new BLonScptType(SCPT_MIN_REMOTE_FLOW_SETPOINT           );
  public static final BLonScptType ScptMaxRemoteFlowSetpoint           = new BLonScptType(SCPT_MAX_REMOTE_FLOW_SETPOINT           );
  public static final BLonScptType ScptMinRemoteTempSetpoint           = new BLonScptType(SCPT_MIN_REMOTE_TEMP_SETPOINT           );
  public static final BLonScptType ScptMaxRemoteTempSetpoint           = new BLonScptType(SCPT_MAX_REMOTE_TEMP_SETPOINT           );
  public static final BLonScptType ScptControlSignal                   = new BLonScptType(SCPT_CONTROL_SIGNAL                     );
  public static final BLonScptType ScptNightPurgePosition              = new BLonScptType(SCPT_NIGHT_PURGE_POSITION               );
  public static final BLonScptType ScptFreeCoolPosition                = new BLonScptType(SCPT_FREE_COOL_POSITION                 );
  public static final BLonScptType ScptValveFlowCharacteristic         = new BLonScptType(SCPT_VALVE_FLOW_CHARACTERISTIC          );
  public static final BLonScptType ScptValveOperatingMode              = new BLonScptType(SCPT_VALVE_OPERATING_MODE               );
  public static final BLonScptType ScptEmergencyPosition               = new BLonScptType(SCPT_EMERGENCY_POSITION                 );
  public static final BLonScptType ScptBlockProtectionTime             = new BLonScptType(SCPT_BLOCK_PROTECTION_TIME              );
  public static final BLonScptType ScptMinStroke                       = new BLonScptType(SCPT_MIN_STROKE                         );
  public static final BLonScptType ScptMaxStroke                       = new BLonScptType(SCPT_MAX_STROKE                         );
  public static final BLonScptType ScptNvType                          = new BLonScptType(SCPT_NV_TYPE                            );
  public static final BLonScptType ScptMaxNVLength                     = new BLonScptType(SCPT_MAX_NV_LENGTH                      );
  public static final BLonScptType ScptNvDynamicAssignment             = new BLonScptType(SCPT_NV_DYNAMIC_ASSIGNMENT              );
  public static final BLonScptType ScptSafExtCnfg                      = new BLonScptType(SCPT_SAF_EXT_CNFG                       );
  public static final BLonScptType ScptEmergCnfg                       = new BLonScptType(SCPT_EMERG_CNFG                         );
  public static final BLonScptType ScptSluiceCnfg                      = new BLonScptType(SCPT_SLUICE_CNFG                        );
  public static final BLonScptType ScptFanOperation                    = new BLonScptType(SCPT_FAN_OPERATION                      );
  public static final BLonScptType ScptMinFlowUnit                     = new BLonScptType(SCPT_MIN_FLOW_UNIT                      );
  public static final BLonScptType ScptMaxFlowUnit                     = new BLonScptType(SCPT_MAX_FLOW_UNIT                      );
  public static final BLonScptType ScptMinFlowHeatStby                 = new BLonScptType(SCPT_MIN_FLOW_HEAT_STBY                 );
  public static final BLonScptType ScptMinFlowUnitStby                 = new BLonScptType(SCPT_MIN_FLOW_UNIT_STBY                 );
  public static final BLonScptType ScptOffsetFlow                      = new BLonScptType(SCPT_OFFSET_FLOW                        );
  public static final BLonScptType ScptAreaDuctHeat                    = new BLonScptType(SCPT_AREA_DUCT_HEAT                     );
  public static final BLonScptType ScptNomAirFlowHeat                  = new BLonScptType(SCPT_NOM_AIR_FLOW_HEAT                  );
  public static final BLonScptType ScptGainVAVHeat                     = new BLonScptType(SCPT_GAIN_VAV_HEAT                      );
  public static final BLonScptType ScptNumDampers                      = new BLonScptType(SCPT_NUM_DAMPERS                        );
  public static final BLonScptType ScptMinFlowUnitHeat                 = new BLonScptType(SCPT_MIN_FLOW_UNIT_HEAT                 );
  public static final BLonScptType ScptSaturationDelay                 = new BLonScptType(SCPT_SATURATION_DELAY                   );
  public static final BLonScptType ScptEffectivePeriod                 = new BLonScptType(SCPT_EFFECTIVE_PERIOD                   );
  public static final BLonScptType ScptScheduleDates                   = new BLonScptType(SCPT_SCHEDULE_DATES                     );
  public static final BLonScptType ScptSchedule                        = new BLonScptType(SCPT_SCHEDULE                           );
  public static final BLonScptType ScptScheduleTimeValue               = new BLonScptType(SCPT_SCHEDULE_TIME_VALUE                );
  public static final BLonScptType ScptValueDefinition                 = new BLonScptType(SCPT_VALUE_DEFINITION                   );
  public static final BLonScptType ScptValueName                       = new BLonScptType(SCPT_VALUE_NAME                         );
  public static final BLonScptType ScptWeeklySchedule                  = new BLonScptType(SCPT_WEEKLY_SCHEDULE                    );
  public static final BLonScptType ScptScheduleName                    = new BLonScptType(SCPT_SCHEDULE_NAME                      );

  public static final BLonScptType ScptValveStroke                     = new BLonScptType(SCPT_VALVE_STROKE                       ); // 280
  public static final BLonScptType ScptValveNominalSize                = new BLonScptType(SCPT_VALVE_NOMINAL_SIZE                 ); // 281
  public static final BLonScptType ScptValveKvs                        = new BLonScptType(SCPT_VALVE_KVS                          ); // 282
  public static final BLonScptType ScptValveType                       = new BLonScptType(SCPT_VALVE_TYPE                         ); // 283
  public static final BLonScptType ScptActuatorCharacteristic          = new BLonScptType(SCPT_ACTUATOR_CHARACTERISTIC            ); // 284
  public static final BLonScptType ScptTrnsTblX2                       = new BLonScptType(SCPT_TRNS_TBL_X2                        ); // 285
  public static final BLonScptType ScptTrnsTblY2                       = new BLonScptType(SCPT_TRNS_TBL_Y2                        ); // 286
  public static final BLonScptType ScptCombFlowCharacteristic          = new BLonScptType(SCPT_COMB_FLOW_CHARACTERISTIC           ); // 287
  public static final BLonScptType ScptTrnsTblX3                       = new BLonScptType(SCPT_TRNS_TBL_X3                        ); // 288
  public static final BLonScptType ScptTrnsTblY3                       = new BLonScptType(SCPT_TRNS_TBL_Y3                        ); // 289
  public static final BLonScptType ScptRunTimeAlarm                    = new BLonScptType(SCPT_RUN_TIME_ALARM                     ); // 290
  public static final BLonScptType ScptTimePeriod                      = new BLonScptType(SCPT_TIME_PERIOD                        );  // 291
  public static final BLonScptType ScptPulseValue                      = new BLonScptType(SCPT_PULSE_VALUE                        ); // 292
  public static final BLonScptType ScptNumDigits                       = new BLonScptType(SCPT_NUM_DIGITS                         ); // 293
  public static final BLonScptType ScptIdentity                        = new BLonScptType(SCPT_IDENTITY                           ); // 294
  public static final BLonScptType ScptDefaultState                    = new BLonScptType(SCPT_DEFAULT_STATE                      ); // 295
  public static final BLonScptType ScptNvPriority                      = new BLonScptType(SCPT_NV_PRIORITY                        ); // 296
  public static final BLonScptType ScptDefaultSetting                  = new BLonScptType(SCPT_DEFAULT_SETTING                    ); // 297
  public static final BLonScptType ScptLowLimit1Enable                 = new BLonScptType(SCPT_LOW_LIMIT1_ENABLE                  ); // 298
  public static final BLonScptType ScptLowLimit2Enable                 = new BLonScptType(SCPT_LOW_LIMIT2_ENABLE                  ); // 299
  public static final BLonScptType ScptClockCalibration                = new BLonScptType(SCPT_CLOCK_CALIBRATION                  ); // 300
  public static final BLonScptType ScptNeuronId                        = new BLonScptType(SCPT_NEURON_ID                          ); // 301
  public static final BLonScptType ScptHighLimit1Enable                = new BLonScptType(SCPT_HIGH_LIMIT1_ENABLE                 ); // 302
  public static final BLonScptType ScptHighLimit2Enable                = new BLonScptType(SCPT_HIGH_LIMIT2_ENABLE                 ); // 303
  public static final BLonScptType ScptAhamApplianceModel              = new BLonScptType(SCPT_AHAM_APPLIANCE_MODEL               ); // 304

  // Version 13.04
  public static final BLonScptType ScptDefInput                        = new BLonScptType(SCPT_DEF_INPUT                          ); // 305
  public static final BLonScptType ScptName1                           = new BLonScptType(SCPT_NAME1                              ); // 306
  public static final BLonScptType ScptScene                           = new BLonScptType(SCPT_SCENE                              ); // 307
  public static final BLonScptType ScptSceneTiming                     = new BLonScptType(SCPT_SCENE_TIMING                       ); // 308
  public static final BLonScptType ScptName2                           = new BLonScptType(SCPT_NAME2                              ); // 309
  public static final BLonScptType ScptName3                           = new BLonScptType(SCPT_NAME3                              ); // 310
  public static final BLonScptType ScptButtonPressAction               = new BLonScptType(SCPT_BUTTON_PRESS_ACTION                ); // 311
  public static final BLonScptType ScptButtonColor                     = new BLonScptType(SCPT_BUTTON_COLOR                       ); // 312
  public static final BLonScptType ScptButtonRepeatInterval            = new BLonScptType(SCPT_BUTTON_REPEAT_INTERVAL             ); // 313
  public static final BLonScptType ScptButtonHoldAction                = new BLonScptType(SCPT_BUTTON_HOLD_ACTION                 ); // 314
  public static final BLonScptType ScptPwrSendOnDelta                  = new BLonScptType(SCPT_PWR_SEND_ON_DELTA                  ); // 315
  public static final BLonScptType ScptSceneName                       = new BLonScptType(SCPT_SCENE_NAME                         ); // 316
  public static final BLonScptType ScptMaxPower                        = new BLonScptType(SCPT_MAX_POWER                          ); // 317
  public static final BLonScptType ScptIfaceDesc                       = new BLonScptType(SCPT_IFACE_DESC                         ); // 318
  public static final BLonScptType ScptMonInterval                     = new BLonScptType(SCPT_MON_INTERVAL                       ); // 319
  public static final BLonScptType ScptLinkPowerDetectEnable           = new BLonScptType(SCPT_LINK_POWER_DETECT_ENABLE           ); // 320
  public static final BLonScptType ScptScanTime                        = new BLonScptType(SCPT_SCAN_TIME                          ); // 321
  public static final BLonScptType ScptDevListDesc                     = new BLonScptType(SCPT_DEV_LIST_DESC                      ); // 322
  public static final BLonScptType ScptDevListEntry                    = new BLonScptType(SCPT_DEV_LIST_ENTRY                     ); // 323
  public static final BLonScptType ScptLogCapacity                     = new BLonScptType(SCPT_LOG_CAPACITY                       ); // 324
  public static final BLonScptType ScptLogNotificationThreshold        = new BLonScptType(SCPT_LOG_NOTIFICATION_THRESHOLD         ); // 325
  public static final BLonScptType ScptLogSize                         = new BLonScptType(SCPT_LOG_SIZE                           ); // 326
  public static final BLonScptType ScptLogType                         = new BLonScptType(SCPT_LOG_TYPE                           ); // 327
  public static final BLonScptType ScptFanInEnable                     = new BLonScptType(SCPT_FAN_IN_ENABLE                      ); // 328
  public static final BLonScptType ScptLogTimestampEnable              = new BLonScptType(SCPT_LOG_TIMESTAMP_ENABLE               ); // 329
  public static final BLonScptType ScptLogHighLimit                    = new BLonScptType(SCPT_LOG_HIGH_LIMIT                     ); // 330
  public static final BLonScptType ScptLogLowLimit                     = new BLonScptType(SCPT_LOG_LOW_LIMIT                      ); // 331
  public static final BLonScptType ScptMaxFanIn                        = new BLonScptType(SCPT_MAX_FAN_IN                         ); // 332
  public static final BLonScptType ScptLogMinDeltaTime                 = new BLonScptType(SCPT_LOG_MIN_DELTA_TIME                 ); // 333
  public static final BLonScptType ScptLogMinDeltaValue                = new BLonScptType(SCPT_LOG_MIN_DELTA_VALUE                ); // 334
  public static final BLonScptType ScptPollRate                        = new BLonScptType(SCPT_POLL_RATE                          ); // 335
  public static final BLonScptType ScptSourceAddress                   = new BLonScptType(SCPT_SOURCE_ADDRESS                     ); // 336
  public static final BLonScptType ScptLogRecord                       = new BLonScptType(SCPT_LOG_RECORD                         ); // 337
  public static final BLonScptType ScptLogFileHeader                   = new BLonScptType(SCPT_LOG_FILE_HEADER                    ); // 338
  public static final BLonScptType ScptLogAlarmThreshold               = new BLonScptType(SCPT_LOG_ALARM_THRESHOLD                ); // 339
  public static final BLonScptType ScptLogRequest                      = new BLonScptType(SCPT_LOG_REQUEST                        ); // 340
  public static final BLonScptType ScptLogResponse                     = new BLonScptType(SCPT_LOG_RESPONSE                       ); // 341
  public static final BLonScptType ScptLightingGroupEnable             = new BLonScptType(SCPT_LIGHTING_GROUP_ENABLE              ); // 342
  public static final BLonScptType ScptSceneColor                      = new BLonScptType(SCPT_SCENE_COLOR                        ); // 343
  public static final BLonScptType ScptBkupSchedule                    = new BLonScptType(SCPT_BKUP_SCHEDULE                      ); // 344
  public static final BLonScptType ScptOLCLimits                       = new BLonScptType(SCPT_OLC_LIMITS                         ); // 345
  public static final BLonScptType ScptLampPower                       = new BLonScptType(SCPT_LAMP_POWER                         ); // 346
  public static final BLonScptType ScptDeviceOutSelection              = new BLonScptType(SCPT_DEVICE_OUT_SELECTION               ); // 347
  public static final BLonScptType ScptEnableStatusMsg                 = new BLonScptType(SCPT_ENABLE_STATUS_MSG                  ); // 348
  public static final BLonScptType ScptMaxLevelVolt                    = new BLonScptType(SCPT_MAX_LEVEL_VOLT                     ); // 349
  public static final BLonScptType ScptGeoLocation                     = new BLonScptType(SCPT_GEO_LOCATION                       ); // 350

  // Version 13.20
  public static final BLonScptType ScptProgName                        = new BLonScptType(SCPT_PROG_NAME                          );  // 351
  public static final BLonScptType ScptProgRevision                    = new BLonScptType(SCPT_PROG_REVISION                      );  // 352
  public static final BLonScptType ScptProgSelect                      = new BLonScptType(SCPT_PROG_SELECT                        );  // 353
  public static final BLonScptType ScptProgSourceLocation              = new BLonScptType(SCPT_PROG_SOURCE_LOCATION               );  // 354
  public static final BLonScptType ScptProgFileIndexes                 = new BLonScptType(SCPT_PROG_FILE_INDEXES                  );  // 355
  public static final BLonScptType ScptProgCmdHistory                  = new BLonScptType(SCPT_PROG_CMD_HISTORY                   );  // 356
  public static final BLonScptType ScptProgStateHistory                = new BLonScptType(SCPT_PROG_STATE_HISTORY                 );  // 357
  public static final BLonScptType ScptNsdsFbIndex                     = new BLonScptType(SCPT_NSDS_FB_INDEX                      );  // 358
  public static final BLonScptType ScptCurrentSenseEnable              = new BLonScptType(SCPT_CURRENT_SENSE_ENABLE               );  // 359
  public static final BLonScptType ScptMeasurementInterval             = new BLonScptType(SCPT_MEASUREMENT_INTERVAL               );  // 360
  public static final BLonScptType ScptLightingGroupMembership         = new BLonScptType(SCPT_LIGHTING_GROUP_MEMBERSHIP          );  // 361
  public static final BLonScptType ScptLoadControlOffset               = new BLonScptType(SCPT_LOAD_CONTROL_OFFSET                );  // 362
  public static final BLonScptType ScptProgErrorHistory                = new BLonScptType(SCPT_PROG_ERROR_HISTORY                 );  // 363
  public static final BLonScptType ScptNvUsage                         = new BLonScptType(SCPT_NV_USAGE                           );  // 364
  public static final BLonScptType ScptScheduleSunday                  = new BLonScptType(SCPT_SCHEDULE_SUNDAY                    );  // 365
  public static final BLonScptType ScptScheduleMonday                  = new BLonScptType(SCPT_SCHEDULE_MONDAY                    );  // 366
  public static final BLonScptType ScptScheduleTuesday                 = new BLonScptType(SCPT_SCHEDULE_TUESDAY                   );  // 367
  public static final BLonScptType ScptScheduleWednesday               = new BLonScptType(SCPT_SCHEDULE_WEDNESDAY                 );  // 368
  public static final BLonScptType ScptScheduleThursday                = new BLonScptType(SCPT_SCHEDULE_THURSDAY                  );  // 369
  public static final BLonScptType ScptScheduleFriday                  = new BLonScptType(SCPT_SCHEDULE_FRIDAY                    );  // 370
  public static final BLonScptType ScptScheduleSaturday                = new BLonScptType(SCPT_SCHEDULE_SATURDAY                  );  // 371
  public static final BLonScptType ScptOccupancyBehavior               = new BLonScptType(SCPT_OCCUPANCY_BEHAVIOR                 );  // 372
  public static final BLonScptType ScptTimeSource                      = new BLonScptType(SCPT_TIME_SOURCE                        );  // 373
  public static final BLonScptType ScptScheduleException               = new BLonScptType(SCPT_SCHEDULE_EXCEPTION                 );  // 374
  public static final BLonScptType ScptScheduleHoliday                 = new BLonScptType(SCPT_SCHEDULE_HOLIDAY                   );  // 375
  public static final BLonScptType ScptRandomizationInterval           = new BLonScptType(SCPT_RANDOMIZATION_INTERVAL             );  // 376
  public static final BLonScptType ScptSunriseTime                     = new BLonScptType(SCPT_SUNRISE_TIME                       );  // 377
  public static final BLonScptType ScptSunsetTime                      = new BLonScptType(SCPT_SUNSET_TIME                        );  // 378
  public static final BLonScptType ScptSchedulerOptions                = new BLonScptType(SCPT_SCHEDULER_OPTIONS                  );  // 379
  public static final BLonScptType ScptOccupancyThresholds             = new BLonScptType(SCPT_OCCUPANCY_THRESHOLDS               );  // 380


////////////////////////////////////////////////////////////////       
// Type                                                                
////////////////////////////////////////////////////////////////       
                                                                       
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonScptType.class);
  
  /** Factory method with ordinal. */
  public static BLonScptType make(int ordinal)
  {
    return (BLonScptType)ScptXxx.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BLonScptType make(String tag)
  {
    return (BLonScptType)ScptXxx.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonScptType(int ordinal)
  {
    super(ordinal);
  }

  
//  // Create a list of SCPT types for this class file
//  // to run >>nre lonworks:javax.baja.lonworks.enums.BLonScptType
//  public static void main(String[] args)
//  {
//      XLonInterfaceFile std = XUtil.getStandard();
//      Vector types = std.types;
//      String[] a = new String[types.size()];
//      String[] c = new String[types.size()];
//int[] la = new int [types.size()];      
//      int maxNv = 0;
//      int maxLen = 0;
//      int maxCLen = 0;
//      for(int i=0 ; i<types.size() ; i++)
//      {
//        XTypeDef t = ((XTypeDef)types.elementAt(i));
//        if(t.isCpType())
//        { 
//          int ndx = t.getTypeIndex();
//          if(ndx < 0) continue;
//          String name = t.getName().substring(2);
//          a[ndx] = NameUtil.toJavaName(name,true);
//          c[ndx] = NameUtil.toConstantName(name);
//          if(ndx>maxNv) maxNv = ndx;
//          
//          if(a[ndx].length() > maxLen) maxLen = a[ndx].length();
//          if(c[ndx].length() > maxCLen) maxCLen = c[ndx].length();
//try { la[ndx] = t.getLonData(std).getByteLength(); } catch(Exception e) { System.out.println("error:" + a[ndx]);}          
//        }
//      }
//      
//      String pad = "                                                        ";
//      System.out.println("  public static final int SCPT_XXX          = 0  ;");
//      for(int i=1; i<=maxNv ; i++)
//      {
//        String conName = c[i];
//        System.out.println("  public static final int SCPT_" + 
//               conName + pad.substring(0,maxCLen - conName.length()) + " = " + i + "  ;"); 
//      }
//
//      System.out.println("\n\n");
//      System.out.println("  public static final int LAST_SCPT_ID  = " + maxNv + " ;\n");
//      System.out.println("  public static final BLonScptType SCPTXxx         = new BLonScptType(SCPT_XXX         );\n");
//      
//      for(int i=1; i<=maxNv ; i++)
//      {
//        String conName = c[i];
//        System.out.println("  public static final BLonScptType Scpt" 
//                     + a[i] + pad.substring(0,maxLen - a[i].length()) +
//                      " = new BLonScptType(SCPT_" + conName + pad.substring(0,maxCLen-conName.length()) + ");");
//      }
//    
//      System.out.println("\n\n/* matches name format in SCPT Master list\n");
//      for(int i=1; i<=maxNv ; i++)
//      {
//        String conName = c[i];
//        System.out.println("  public static final BLonScptType SCPT_" 
//                     + TextUtil.toLowerCase(conName) + pad.substring(0,maxCLen - conName.length()) +
//                      " = new BLonScptType(SCPT_" + conName + pad.substring(0,maxCLen - conName.length()) + 
// ");  " + la[i]);
//      }
//      System.out.println("* //");
//  }
//  
  
}
