/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonSceneConfigEnum class provides enumeration for SNVT_scene_cfg
 *
 * @author    Sean Morton
 * @creation  19 Jul 01
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:37 PM$
 * @since     Niagara 3.0
 */
public final class BLonSceneConfigEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonSceneConfigEnum
  {
    range
    {
      scfSave = 0,
      scfClear = 1,
      scfReport = 2,
      scfSize = 3,
      scfFree = 4,
      scfNul = -1, 
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonSceneConfigEnum(116295339)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for scfSave. */
  public static final int SCF_SAVE = 0;
  /** Ordinal value for scfClear. */
  public static final int SCF_CLEAR = 1;
  /** Ordinal value for scfReport. */
  public static final int SCF_REPORT = 2;
  /** Ordinal value for scfSize. */
  public static final int SCF_SIZE = 3;
  /** Ordinal value for scfFree. */
  public static final int SCF_FREE = 4;
  /** Ordinal value for scfNul. */
  public static final int SCF_NUL = -1;
  
  /** BLonSceneConfigEnum constant for scfSave. */
  public static final BLonSceneConfigEnum scfSave = new BLonSceneConfigEnum(SCF_SAVE);
  /** BLonSceneConfigEnum constant for scfClear. */
  public static final BLonSceneConfigEnum scfClear = new BLonSceneConfigEnum(SCF_CLEAR);
  /** BLonSceneConfigEnum constant for scfReport. */
  public static final BLonSceneConfigEnum scfReport = new BLonSceneConfigEnum(SCF_REPORT);
  /** BLonSceneConfigEnum constant for scfSize. */
  public static final BLonSceneConfigEnum scfSize = new BLonSceneConfigEnum(SCF_SIZE);
  /** BLonSceneConfigEnum constant for scfFree. */
  public static final BLonSceneConfigEnum scfFree = new BLonSceneConfigEnum(SCF_FREE);
  /** BLonSceneConfigEnum constant for scfNul. */
  public static final BLonSceneConfigEnum scfNul = new BLonSceneConfigEnum(SCF_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonSceneConfigEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonSceneConfigEnum make(int ordinal)
  {
    return (BLonSceneConfigEnum)scfSave.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonSceneConfigEnum make(String tag)
  {
    return (BLonSceneConfigEnum)scfSave.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonSceneConfigEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
