/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonRailAudioTypeEnum class provides enumeration for SNVT_rac_ctrl &
 *  SNVT_rac_req
 *
 * @author    Robert Adams
 * @creation  9 Nov 06
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:26 PM$
 * @since     Niagara 3.0
 */
public final class BLonRailAudioTypeEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonRailAudioTypeEnum
  {
    range
    {
      ratIcReq = 0,
      ratIcJoin = 1,
      ratIcQuit = 2,
      ratIcEnd = 3,
      ratHwRadioReq = 4,
      ratHwRadioEnd = 5,
      ratHwPaReq = 6,
      ratHwPaEnd = 7,
      ratSwPaReq = 8,
      ratSwPaEnd = 9,
      ratSwPaOrReq = 10,
      ratSwPaOrEnd = 11,
      ratPauReq = 12,
      ratPauAccept = 13,
      ratPauCall = 14,
      ratPauEnd = 15,
      ratEntertReq = 16,
      ratEntertEnd = 17,
      ratNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonRailAudioTypeEnum(487792774)1.0$ @*/
/* Generated Thu Nov 09 17:20:39 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for ratIcReq. */
  public static final int RAT_IC_REQ = 0;
  /** Ordinal value for ratIcJoin. */
  public static final int RAT_IC_JOIN = 1;
  /** Ordinal value for ratIcQuit. */
  public static final int RAT_IC_QUIT = 2;
  /** Ordinal value for ratIcEnd. */
  public static final int RAT_IC_END = 3;
  /** Ordinal value for ratHwRadioReq. */
  public static final int RAT_HW_RADIO_REQ = 4;
  /** Ordinal value for ratHwRadioEnd. */
  public static final int RAT_HW_RADIO_END = 5;
  /** Ordinal value for ratHwPaReq. */
  public static final int RAT_HW_PA_REQ = 6;
  /** Ordinal value for ratHwPaEnd. */
  public static final int RAT_HW_PA_END = 7;
  /** Ordinal value for ratSwPaReq. */
  public static final int RAT_SW_PA_REQ = 8;
  /** Ordinal value for ratSwPaEnd. */
  public static final int RAT_SW_PA_END = 9;
  /** Ordinal value for ratSwPaOrReq. */
  public static final int RAT_SW_PA_OR_REQ = 10;
  /** Ordinal value for ratSwPaOrEnd. */
  public static final int RAT_SW_PA_OR_END = 11;
  /** Ordinal value for ratPauReq. */
  public static final int RAT_PAU_REQ = 12;
  /** Ordinal value for ratPauAccept. */
  public static final int RAT_PAU_ACCEPT = 13;
  /** Ordinal value for ratPauCall. */
  public static final int RAT_PAU_CALL = 14;
  /** Ordinal value for ratPauEnd. */
  public static final int RAT_PAU_END = 15;
  /** Ordinal value for ratEntertReq. */
  public static final int RAT_ENTERT_REQ = 16;
  /** Ordinal value for ratEntertEnd. */
  public static final int RAT_ENTERT_END = 17;
  /** Ordinal value for ratNul. */
  public static final int RAT_NUL = -1;
  
  /** BLonRailAudioTypeEnum constant for ratIcReq. */
  public static final BLonRailAudioTypeEnum ratIcReq = new BLonRailAudioTypeEnum(RAT_IC_REQ);
  /** BLonRailAudioTypeEnum constant for ratIcJoin. */
  public static final BLonRailAudioTypeEnum ratIcJoin = new BLonRailAudioTypeEnum(RAT_IC_JOIN);
  /** BLonRailAudioTypeEnum constant for ratIcQuit. */
  public static final BLonRailAudioTypeEnum ratIcQuit = new BLonRailAudioTypeEnum(RAT_IC_QUIT);
  /** BLonRailAudioTypeEnum constant for ratIcEnd. */
  public static final BLonRailAudioTypeEnum ratIcEnd = new BLonRailAudioTypeEnum(RAT_IC_END);
  /** BLonRailAudioTypeEnum constant for ratHwRadioReq. */
  public static final BLonRailAudioTypeEnum ratHwRadioReq = new BLonRailAudioTypeEnum(RAT_HW_RADIO_REQ);
  /** BLonRailAudioTypeEnum constant for ratHwRadioEnd. */
  public static final BLonRailAudioTypeEnum ratHwRadioEnd = new BLonRailAudioTypeEnum(RAT_HW_RADIO_END);
  /** BLonRailAudioTypeEnum constant for ratHwPaReq. */
  public static final BLonRailAudioTypeEnum ratHwPaReq = new BLonRailAudioTypeEnum(RAT_HW_PA_REQ);
  /** BLonRailAudioTypeEnum constant for ratHwPaEnd. */
  public static final BLonRailAudioTypeEnum ratHwPaEnd = new BLonRailAudioTypeEnum(RAT_HW_PA_END);
  /** BLonRailAudioTypeEnum constant for ratSwPaReq. */
  public static final BLonRailAudioTypeEnum ratSwPaReq = new BLonRailAudioTypeEnum(RAT_SW_PA_REQ);
  /** BLonRailAudioTypeEnum constant for ratSwPaEnd. */
  public static final BLonRailAudioTypeEnum ratSwPaEnd = new BLonRailAudioTypeEnum(RAT_SW_PA_END);
  /** BLonRailAudioTypeEnum constant for ratSwPaOrReq. */
  public static final BLonRailAudioTypeEnum ratSwPaOrReq = new BLonRailAudioTypeEnum(RAT_SW_PA_OR_REQ);
  /** BLonRailAudioTypeEnum constant for ratSwPaOrEnd. */
  public static final BLonRailAudioTypeEnum ratSwPaOrEnd = new BLonRailAudioTypeEnum(RAT_SW_PA_OR_END);
  /** BLonRailAudioTypeEnum constant for ratPauReq. */
  public static final BLonRailAudioTypeEnum ratPauReq = new BLonRailAudioTypeEnum(RAT_PAU_REQ);
  /** BLonRailAudioTypeEnum constant for ratPauAccept. */
  public static final BLonRailAudioTypeEnum ratPauAccept = new BLonRailAudioTypeEnum(RAT_PAU_ACCEPT);
  /** BLonRailAudioTypeEnum constant for ratPauCall. */
  public static final BLonRailAudioTypeEnum ratPauCall = new BLonRailAudioTypeEnum(RAT_PAU_CALL);
  /** BLonRailAudioTypeEnum constant for ratPauEnd. */
  public static final BLonRailAudioTypeEnum ratPauEnd = new BLonRailAudioTypeEnum(RAT_PAU_END);
  /** BLonRailAudioTypeEnum constant for ratEntertReq. */
  public static final BLonRailAudioTypeEnum ratEntertReq = new BLonRailAudioTypeEnum(RAT_ENTERT_REQ);
  /** BLonRailAudioTypeEnum constant for ratEntertEnd. */
  public static final BLonRailAudioTypeEnum ratEntertEnd = new BLonRailAudioTypeEnum(RAT_ENTERT_END);
  /** BLonRailAudioTypeEnum constant for ratNul. */
  public static final BLonRailAudioTypeEnum ratNul = new BLonRailAudioTypeEnum(RAT_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonRailAudioTypeEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonRailAudioTypeEnum make(int ordinal)
  {
    return (BLonRailAudioTypeEnum)ratIcReq.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonRailAudioTypeEnum make(String tag)
  {
    return (BLonRailAudioTypeEnum)ratIcReq.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonRailAudioTypeEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 
  public static BLonRailAudioTypeEnum DEFAULT = ratNul;

}