/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonOccupancyEnum class provides enumeration for LonOccupancy 
 * Snvt per SNVT Master List.
 *
 * @author    Robert Adams
 * @creation  29 May 01
 * @version   $Revision: 2$ $Date: 8/9/01 2:23:04 PM$
 * @since     Niagara 3.0
 */
public final class BLonOccupancyEnum
  extends BFrozenEnum
{

  /*-
  
  enum BLonOccupancyEnum
  {
    range
    {
      occupied = 0,
      unoccupied = 1,
      bypass = 2,
      standby = 3,
      occNull = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonOccupancyEnum(400649191)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for occupied. */
  public static final int OCCUPIED = 0;
  /** Ordinal value for unoccupied. */
  public static final int UNOCCUPIED = 1;
  /** Ordinal value for bypass. */
  public static final int BYPASS = 2;
  /** Ordinal value for standby. */
  public static final int STANDBY = 3;
  /** Ordinal value for occNull. */
  public static final int OCC_NULL = -1;
  
  /** BLonOccupancyEnum constant for occupied. */
  public static final BLonOccupancyEnum occupied = new BLonOccupancyEnum(OCCUPIED);
  /** BLonOccupancyEnum constant for unoccupied. */
  public static final BLonOccupancyEnum unoccupied = new BLonOccupancyEnum(UNOCCUPIED);
  /** BLonOccupancyEnum constant for bypass. */
  public static final BLonOccupancyEnum bypass = new BLonOccupancyEnum(BYPASS);
  /** BLonOccupancyEnum constant for standby. */
  public static final BLonOccupancyEnum standby = new BLonOccupancyEnum(STANDBY);
  /** BLonOccupancyEnum constant for occNull. */
  public static final BLonOccupancyEnum occNull = new BLonOccupancyEnum(OCC_NULL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonOccupancyEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonOccupancyEnum make(int ordinal)
  {
    return (BLonOccupancyEnum)occupied.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonOccupancyEnum make(String tag)
  {
    return (BLonOccupancyEnum)occupied.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonOccupancyEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public static BLonOccupancyEnum DEFAULT = occNull;

}
