/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BLonNvDirection provides enumeration of the direction of
 * a network variable (input or output).
 * <p>
 * @author    Robert Adams
 * @creation  09 Nov 00
 * @version   $Revision: 2$ $Date: 9/18/01 9:49:48 AM$
 * @since     Niagara 3.0
 */
public final class BLonNvDirection
  extends BFrozenEnum
{

  /*-
  
  enum BLonNvDirection
  {
    range
    {
      input,
      output
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonNvDirection(1241485759)1.0$ @*/
/* Generated Tue Apr 06 10:08:41 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for input. */
  public static final int INPUT = 0;
  /** Ordinal value for output. */
  public static final int OUTPUT = 1;
  
  /** BLonNvDirection constant for input. */
  public static final BLonNvDirection input = new BLonNvDirection(INPUT);
  /** BLonNvDirection constant for output. */
  public static final BLonNvDirection output = new BLonNvDirection(OUTPUT);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonNvDirection.class);
  
  /** Factory method with ordinal. */
  public static BLonNvDirection make(int ordinal)
  {
    return (BLonNvDirection)input.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BLonNvDirection make(String tag)
  {
    return (BLonNvDirection)input.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonNvDirection(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BLonNvDirection reverse()
  {
    return (this==input) ? output : input; 
  }
  

}
