/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BLonNodeState provides enumeration for the state of
 * a lonworks device as defined in Neuron Chip Data Book 
 * Appendix B.1.6.
 * <p>
 * @author    Robert Adams
 * @creation  14 Dec 00
 * @version   $Revision: 2$ $Date: 9/18/01 9:49:48 AM$
 * @since     Niagara 3.0
 */
public final class BLonNodeState
  extends BFrozenEnum
{

  /*-
  
  enum BLonNodeState
  {
    range
    {
      unknown,
      unconfigured,
      configOnline,
      configOffline,
      applicationless,
      hardOffline
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonNodeState(2498690389)1.0$ @*/
/* Generated Tue Apr 06 10:08:41 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for unknown. */
  public static final int UNKNOWN = 0;
  /** Ordinal value for unconfigured. */
  public static final int UNCONFIGURED = 1;
  /** Ordinal value for configOnline. */
  public static final int CONFIG_ONLINE = 2;
  /** Ordinal value for configOffline. */
  public static final int CONFIG_OFFLINE = 3;
  /** Ordinal value for applicationless. */
  public static final int APPLICATIONLESS = 4;
  /** Ordinal value for hardOffline. */
  public static final int HARD_OFFLINE = 5;
  
  /** BLonNodeState constant for unknown. */
  public static final BLonNodeState unknown = new BLonNodeState(UNKNOWN);
  /** BLonNodeState constant for unconfigured. */
  public static final BLonNodeState unconfigured = new BLonNodeState(UNCONFIGURED);
  /** BLonNodeState constant for configOnline. */
  public static final BLonNodeState configOnline = new BLonNodeState(CONFIG_ONLINE);
  /** BLonNodeState constant for configOffline. */
  public static final BLonNodeState configOffline = new BLonNodeState(CONFIG_OFFLINE);
  /** BLonNodeState constant for applicationless. */
  public static final BLonNodeState applicationless = new BLonNodeState(APPLICATIONLESS);
  /** BLonNodeState constant for hardOffline. */
  public static final BLonNodeState hardOffline = new BLonNodeState(HARD_OFFLINE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonNodeState.class);
  
  /** Factory method with ordinal. */
  public static BLonNodeState make(int ordinal)
  {
    return (BLonNodeState)unknown.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BLonNodeState make(String tag)
  {
    return (BLonNodeState)unknown.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonNodeState(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /** Is this a configured state - configOnline or configOffline */
  public boolean isConfigured() 
    { return getOrdinal()==CONFIG_ONLINE || getOrdinal()==CONFIG_OFFLINE; }

  
}
