/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonIntervalOfMonthEnum class provides enumeration for SCPT_time_period.
 *
 * @author    Robert Adams
 * @creation  9 Nov 06
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:26 PM$
 * @since     Niagara 3.0
 */
public final class BLonIntervalOfMonthEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonIntervalOfMonthEnum
  {
    range
    {
      iomMinute = 0,
      iomHour   = 1,
      iomDay    = 2,
      iomWeek   = 3,
      iomMonth  = 4,
      iomNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonIntervalOfMonthEnum(1497890618)1.0$ @*/
/* Generated Fri Nov 10 10:10:37 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for iomMinute. */
  public static final int IOM_MINUTE = 0;
  /** Ordinal value for iomHour. */
  public static final int IOM_HOUR = 1;
  /** Ordinal value for iomDay. */
  public static final int IOM_DAY = 2;
  /** Ordinal value for iomWeek. */
  public static final int IOM_WEEK = 3;
  /** Ordinal value for iomMonth. */
  public static final int IOM_MONTH = 4;
  /** Ordinal value for iomNul. */
  public static final int IOM_NUL = -1;
  
  /** BLonIntervalOfMonthEnum constant for iomMinute. */
  public static final BLonIntervalOfMonthEnum iomMinute = new BLonIntervalOfMonthEnum(IOM_MINUTE);
  /** BLonIntervalOfMonthEnum constant for iomHour. */
  public static final BLonIntervalOfMonthEnum iomHour = new BLonIntervalOfMonthEnum(IOM_HOUR);
  /** BLonIntervalOfMonthEnum constant for iomDay. */
  public static final BLonIntervalOfMonthEnum iomDay = new BLonIntervalOfMonthEnum(IOM_DAY);
  /** BLonIntervalOfMonthEnum constant for iomWeek. */
  public static final BLonIntervalOfMonthEnum iomWeek = new BLonIntervalOfMonthEnum(IOM_WEEK);
  /** BLonIntervalOfMonthEnum constant for iomMonth. */
  public static final BLonIntervalOfMonthEnum iomMonth = new BLonIntervalOfMonthEnum(IOM_MONTH);
  /** BLonIntervalOfMonthEnum constant for iomNul. */
  public static final BLonIntervalOfMonthEnum iomNul = new BLonIntervalOfMonthEnum(IOM_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonIntervalOfMonthEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonIntervalOfMonthEnum make(int ordinal)
  {
    return (BLonIntervalOfMonthEnum)iomMinute.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonIntervalOfMonthEnum make(String tag)
  {
    return (BLonIntervalOfMonthEnum)iomMinute.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonIntervalOfMonthEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 
  public static BLonIntervalOfMonthEnum DEFAULT = iomNul;

}