/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonGroupRestrictionEnum represents the group_restriction enum from
 * CEA-709.1-B (p.79).  It is used in Expanded Address Table entries to expanded
 * the allowed behaviour of address entries. 
 *
 * @author    Robert Adams
 * @creation  13 Dec 06
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:40 PM$
 * @since     Niagara 3.0
 */
public final class BLonGroupRestrictionEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonGroupRestrictionEnum
  {
    range
    {
      grpNormal = 0,
      grpOutputOnly = 1,
      grpInputNoAck = 2,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonGroupRestrictionEnum(934119119)1.0$ @*/
/* Generated Wed Dec 13 11:14:56 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for grpNormal. */
  public static final int GRP_NORMAL = 0;
  /** Ordinal value for grpOutputOnly. */
  public static final int GRP_OUTPUT_ONLY = 1;
  /** Ordinal value for grpInputNoAck. */
  public static final int GRP_INPUT_NO_ACK = 2;
  
  /** BLonGroupRestrictionEnum constant for grpNormal. */
  public static final BLonGroupRestrictionEnum grpNormal = new BLonGroupRestrictionEnum(GRP_NORMAL);
  /** BLonGroupRestrictionEnum constant for grpOutputOnly. */
  public static final BLonGroupRestrictionEnum grpOutputOnly = new BLonGroupRestrictionEnum(GRP_OUTPUT_ONLY);
  /** BLonGroupRestrictionEnum constant for grpInputNoAck. */
  public static final BLonGroupRestrictionEnum grpInputNoAck = new BLonGroupRestrictionEnum(GRP_INPUT_NO_ACK);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonGroupRestrictionEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonGroupRestrictionEnum make(int ordinal)
  {
    return (BLonGroupRestrictionEnum)grpNormal.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonGroupRestrictionEnum make(String tag)
  {
    return (BLonGroupRestrictionEnum)grpNormal.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonGroupRestrictionEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
