/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonFileRequestEnum class provides enumeration for SNVT_file_req
 *
 * @author    Sean Morton
 * @creation  18 Jul 01
 * @version   $Revision: 2$ $Date: 9/5/01 12:55:53 PM$
 * @since     Niagara 3.0
 */
public final class BLonFileRequestEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonFileRequestEnum
  {
    range
    {
      openToSend = 0,
      openToReceive = 1,
      closeFile = 2,
      closeDeleteFile = 3,
      directoryLookup = 4,
      openToSendRa = 5,
      openToReceiveRa = 6,
      nul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonFileRequestEnum(3119121749)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for openToSend. */
  public static final int OPEN_TO_SEND = 0;
  /** Ordinal value for openToReceive. */
  public static final int OPEN_TO_RECEIVE = 1;
  /** Ordinal value for closeFile. */
  public static final int CLOSE_FILE = 2;
  /** Ordinal value for closeDeleteFile. */
  public static final int CLOSE_DELETE_FILE = 3;
  /** Ordinal value for directoryLookup. */
  public static final int DIRECTORY_LOOKUP = 4;
  /** Ordinal value for openToSendRa. */
  public static final int OPEN_TO_SEND_RA = 5;
  /** Ordinal value for openToReceiveRa. */
  public static final int OPEN_TO_RECEIVE_RA = 6;
  /** Ordinal value for nul. */
  public static final int NUL = -1;
  
  /** BLonFileRequestEnum constant for openToSend. */
  public static final BLonFileRequestEnum openToSend = new BLonFileRequestEnum(OPEN_TO_SEND);
  /** BLonFileRequestEnum constant for openToReceive. */
  public static final BLonFileRequestEnum openToReceive = new BLonFileRequestEnum(OPEN_TO_RECEIVE);
  /** BLonFileRequestEnum constant for closeFile. */
  public static final BLonFileRequestEnum closeFile = new BLonFileRequestEnum(CLOSE_FILE);
  /** BLonFileRequestEnum constant for closeDeleteFile. */
  public static final BLonFileRequestEnum closeDeleteFile = new BLonFileRequestEnum(CLOSE_DELETE_FILE);
  /** BLonFileRequestEnum constant for directoryLookup. */
  public static final BLonFileRequestEnum directoryLookup = new BLonFileRequestEnum(DIRECTORY_LOOKUP);
  /** BLonFileRequestEnum constant for openToSendRa. */
  public static final BLonFileRequestEnum openToSendRa = new BLonFileRequestEnum(OPEN_TO_SEND_RA);
  /** BLonFileRequestEnum constant for openToReceiveRa. */
  public static final BLonFileRequestEnum openToReceiveRa = new BLonFileRequestEnum(OPEN_TO_RECEIVE_RA);
  /** BLonFileRequestEnum constant for nul. */
  public static final BLonFileRequestEnum nul = new BLonFileRequestEnum(NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonFileRequestEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonFileRequestEnum make(int ordinal)
  {
    return (BLonFileRequestEnum)openToSend.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonFileRequestEnum make(String tag)
  {
    return (BLonFileRequestEnum)openToSend.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonFileRequestEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public static final BEnum DEFAULT = nul;

}
