/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonEmergEnum class provides enumeration for SNVT_hvac_emerg
 *
 * @author    Sean Morton
 * @creation  18 Jul 01
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:27 PM$
 * @since     Niagara 3.0
 */
public final class BLonEmergEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonEmergEnum
  {
    range
    {
      emergNormal = 0,
      emergPressurize = 1,
      emergDepressurize = 2,
      emergPurge = 3,
      emergShutdown = 4,
      emergFire = 5,
      emergNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonEmergEnum(360498576)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for emergNormal. */
  public static final int EMERG_NORMAL = 0;
  /** Ordinal value for emergPressurize. */
  public static final int EMERG_PRESSURIZE = 1;
  /** Ordinal value for emergDepressurize. */
  public static final int EMERG_DEPRESSURIZE = 2;
  /** Ordinal value for emergPurge. */
  public static final int EMERG_PURGE = 3;
  /** Ordinal value for emergShutdown. */
  public static final int EMERG_SHUTDOWN = 4;
  /** Ordinal value for emergFire. */
  public static final int EMERG_FIRE = 5;
  /** Ordinal value for emergNul. */
  public static final int EMERG_NUL = -1;
  
  /** BLonEmergEnum constant for emergNormal. */
  public static final BLonEmergEnum emergNormal = new BLonEmergEnum(EMERG_NORMAL);
  /** BLonEmergEnum constant for emergPressurize. */
  public static final BLonEmergEnum emergPressurize = new BLonEmergEnum(EMERG_PRESSURIZE);
  /** BLonEmergEnum constant for emergDepressurize. */
  public static final BLonEmergEnum emergDepressurize = new BLonEmergEnum(EMERG_DEPRESSURIZE);
  /** BLonEmergEnum constant for emergPurge. */
  public static final BLonEmergEnum emergPurge = new BLonEmergEnum(EMERG_PURGE);
  /** BLonEmergEnum constant for emergShutdown. */
  public static final BLonEmergEnum emergShutdown = new BLonEmergEnum(EMERG_SHUTDOWN);
  /** BLonEmergEnum constant for emergFire. */
  public static final BLonEmergEnum emergFire = new BLonEmergEnum(EMERG_FIRE);
  /** BLonEmergEnum constant for emergNul. */
  public static final BLonEmergEnum emergNul = new BLonEmergEnum(EMERG_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonEmergEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonEmergEnum make(int ordinal)
  {
    return (BLonEmergEnum)emergNormal.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonEmergEnum make(String tag)
  {
    return (BLonEmergEnum)emergNormal.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonEmergEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
