/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BLonElementType class provides enumeration for the element type
 * as specified in <code>BLonElementQualifiers</code>. It indicates
 * the type of data for a particular data element when encoded in 
 * network byte format.
 *
 * @author    Robert Adams
 * @creation  14 Dec 00
 * @version   $Revision: 5$ $Date: 9/18/01 9:49:39 AM$
 * @since     Niagara 3.0
 */
public final class BLonElementType
  extends BFrozenEnum
{

  /* - // Block slot regen to prevent name mangling of constants
  
  enum BLonElementType
  {
    range
    {
      // character - 1 byte
      c8,
      // signed short - 1 byte
      s8,
      // unsigned short - 1 byte
      u8,
      // signed long - 2 byte
      s16,
      // unsigned long - 2 byte
      u16,
      // signed 32bit - 4 byte
      s32,
      // boolean - 1 byte
      b8,
      // enumeration - 1 byte
      e8,
      // float - 4 byte
      f32,
      // enumeration in bit field
      eb,
      // enumeration signed in bit field
      esb,
      // boolean in bit field
      bb,
      // unsigned int in bit field
      ub,
      // signed int in bit field
      sb,
      // string
      st,
      // no type - conversion must be hand coded 
      na,
      // unsigned 32 bit
      u32,
      // double float
      f64,
      s64,
      u64
    }
  }
  - */
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonElementType(1106128874)1.0$ @*/
/* Generated Fri Jan 21 13:06:16 EST 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for c8. */
  public static final int C8 = 0;
  /** Ordinal value for s8. */
  public static final int S8 = 1;
  /** Ordinal value for u8. */
  public static final int U8 = 2;
  /** Ordinal value for s16. */
  public static final int S16 = 3;
  /** Ordinal value for u16. */
  public static final int U16 = 4;
  /** Ordinal value for s32. */
  public static final int S32 = 5;
  /** Ordinal value for b8. */
  public static final int B8 = 6;
  /** Ordinal value for e8. */
  public static final int E8 = 7;
  /** Ordinal value for f32. */
  public static final int F32 = 8;
  /** Ordinal value for eb. */
  public static final int EB = 9;
  /** Ordinal value for eb. */
  public static final int ESB = 10;
  /** Ordinal value for bb. */    
  public static final int BB =  11;
  /** Ordinal value for ub. */     
  public static final int UB =  12;
  /** Ordinal value for sb. */     
  public static final int SB =  13;
  /** Ordinal value for st. */     
  public static final int ST =  14;
  /** Ordinal value for na. */
  public static final int NA =  15;
  /** unsigned 32 bit. */
  public static final int U32 =  16;
  /** double float. */
  public static final int F64 =  17;
  /** signed int 64. */
  public static final int S64 =  18;
  /** unsigned int 64. */
  public static final int U64 =  19;
  
  /** BLonElementType constant for c8. */
  public static final BLonElementType c8 = new BLonElementType(C8);
  /** BLonElementType constant for s8. */
  public static final BLonElementType s8 = new BLonElementType(S8);
  /** BLonElementType constant for u8. */
  public static final BLonElementType u8 = new BLonElementType(U8);
  /** BLonElementType constant for s16. */
  public static final BLonElementType s16 = new BLonElementType(S16);
  /** BLonElementType constant for u16. */
  public static final BLonElementType u16 = new BLonElementType(U16);
  /** BLonElementType constant for s32. */
  public static final BLonElementType s32 = new BLonElementType(S32);
  /** BLonElementType constant for b8. */
  public static final BLonElementType b8 = new BLonElementType(B8);
  /** BLonElementType constant for e8. */
  public static final BLonElementType e8 = new BLonElementType(E8);
  /** BLonElementType constant for f32. */
  public static final BLonElementType f32 = new BLonElementType(F32);
  /** BLonElementType constant for eb. */
  public static final BLonElementType eb = new BLonElementType(EB);
  /** BLonElementType constant for eb. */
  public static final BLonElementType esb = new BLonElementType(ESB);
  /** BLonElementType constant for bb. */
  public static final BLonElementType bb = new BLonElementType(BB);
  /** BLonElementType constant for ub. */
  public static final BLonElementType ub = new BLonElementType(UB);
  /** BLonElementType constant for sb. */
  public static final BLonElementType sb = new BLonElementType(SB);
  /** BLonElementType constant for st. */
  public static final BLonElementType st = new BLonElementType(ST);
  /** BLonElementType constant for na. */
  public static final BLonElementType na = new BLonElementType(NA);
  /** BLonElementType constant for u32. */
  public static final BLonElementType u32 = new BLonElementType(U32);
  /** BLonElementType constant for f64. */
  public static final BLonElementType f64 = new BLonElementType(F64);
  /** BLonElementType constant for s64. */
  public static final BLonElementType s64 = new BLonElementType(S64);
  /** BLonElementType constant for u64. */
  public static final BLonElementType u64 = new BLonElementType(U64);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonElementType.class);
  
  /** Factory method with ordinal. */
  public static BLonElementType make(int ordinal)
  {
    return (BLonElementType)c8.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonElementType make(String tag)
  {
    return (BLonElementType)c8.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonElementType(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
