/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonDeviceSelectEnum class provides enumeration for SNVT_dev_status,
 * SNVT_dev_fault, SNVT_dev_maint
 *
 * @author    Robert Adams
 * @creation  9 Nov 06
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:26 PM$
 * @since     Niagara 3.0
 */
public final class BLonDeviceSelectEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonDeviceSelectEnum
  {
    range
    {
     dvPumpCtrl = 0,
     dvValvePos = 1,
     dvNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonDeviceSelectEnum(2880929893)1.0$ @*/
/* Generated Thu Nov 09 14:28:11 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for dvPumpCtrl. */
  public static final int DV_PUMP_CTRL = 0;
  /** Ordinal value for dvValvePos. */
  public static final int DV_VALVE_POS = 1;
  /** Ordinal value for dvNul. */
  public static final int DV_NUL = -1;
  
  /** BLonDeviceSelectEnum constant for dvPumpCtrl. */
  public static final BLonDeviceSelectEnum dvPumpCtrl = new BLonDeviceSelectEnum(DV_PUMP_CTRL);
  /** BLonDeviceSelectEnum constant for dvValvePos. */
  public static final BLonDeviceSelectEnum dvValvePos = new BLonDeviceSelectEnum(DV_VALVE_POS);
  /** BLonDeviceSelectEnum constant for dvNul. */
  public static final BLonDeviceSelectEnum dvNul = new BLonDeviceSelectEnum(DV_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonDeviceSelectEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonDeviceSelectEnum make(int ordinal)
  {
    return (BLonDeviceSelectEnum)dvPumpCtrl.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonDeviceSelectEnum make(String tag)
  {
    return (BLonDeviceSelectEnum)dvPumpCtrl.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonDeviceSelectEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 
  public static BLonDeviceSelectEnum DEFAULT = dvNul;

}