/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonConfigSourceEnum class provides enumeration for SNVT_config_src
 *
 * @author    Sean Morton
 * @creation  18 Jul 01
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:24 PM$
 * @since     Niagara 3.0
 */
public final class BLonConfigSourceEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonConfigSourceEnum
  {
    range
    {
      cfgLocal = 0,
      cfgExternal = 1,
      cfgNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonConfigSourceEnum(3564111554)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for cfgLocal. */
  public static final int CFG_LOCAL = 0;
  /** Ordinal value for cfgExternal. */
  public static final int CFG_EXTERNAL = 1;
  /** Ordinal value for cfgNul. */
  public static final int CFG_NUL = -1;
  
  /** BLonConfigSourceEnum constant for cfgLocal. */
  public static final BLonConfigSourceEnum cfgLocal = new BLonConfigSourceEnum(CFG_LOCAL);
  /** BLonConfigSourceEnum constant for cfgExternal. */
  public static final BLonConfigSourceEnum cfgExternal = new BLonConfigSourceEnum(CFG_EXTERNAL);
  /** BLonConfigSourceEnum constant for cfgNul. */
  public static final BLonConfigSourceEnum cfgNul = new BLonConfigSourceEnum(CFG_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonConfigSourceEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonConfigSourceEnum make(int ordinal)
  {
    return (BLonConfigSourceEnum)cfgLocal.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonConfigSourceEnum make(String tag)
  {
    return (BLonConfigSourceEnum)cfgLocal.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonConfigSourceEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
