/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonBooleanEnum represents Lonworks standard enumeration BooleanT.
 *
 * @author    Robert Adams
 * @creation  12 Jan 01
 * @version   $Revision: 4$ $Date: 9/18/01 9:49:32 AM$
 * @since     Niagara 3.0
 */
public final class BLonBooleanEnum
  extends BFrozenEnum
{

  /*-
  
  enum BLonBooleanEnum
  {
    range
    {
      boolFalse = 0,
      boolTrue = 1,
      boolNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonBooleanEnum(3123533043)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for boolFalse. */
  public static final int BOOL_FALSE = 0;
  /** Ordinal value for boolTrue. */
  public static final int BOOL_TRUE = 1;
  /** Ordinal value for boolNul. */
  public static final int BOOL_NUL = -1;
  
  /** BLonBooleanEnum constant for boolFalse. */
  public static final BLonBooleanEnum boolFalse = new BLonBooleanEnum(BOOL_FALSE);
  /** BLonBooleanEnum constant for boolTrue. */
  public static final BLonBooleanEnum boolTrue = new BLonBooleanEnum(BOOL_TRUE);
  /** BLonBooleanEnum constant for boolNul. */
  public static final BLonBooleanEnum boolNul = new BLonBooleanEnum(BOOL_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonBooleanEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonBooleanEnum make(int ordinal)
  {
    return (BLonBooleanEnum)boolFalse.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonBooleanEnum make(String tag)
  {
    return (BLonBooleanEnum)boolFalse.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonBooleanEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
