/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BAddressType class provides enumeration of the address
 * types in the neurons address table.
 *
 * @author    Robert Adams
 * @creation  14 Jan 01
 * @version   $Revision: 2$ $Date: 9/18/01 9:49:24 AM$
 * @since     Niagara 3.0
 */
public final class BAddressType
  extends BFrozenEnum
{

  /*-
  
  enum BAddressType
  {
    range
    {
      none,
      group,
      subnetNode,
      broadcast,
      turnaround
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BAddressType(1031279935)1.0$ @*/
/* Generated Tue Apr 06 10:08:40 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for none. */
  public static final int NONE = 0;
  /** Ordinal value for group. */
  public static final int GROUP = 1;
  /** Ordinal value for subnetNode. */
  public static final int SUBNET_NODE = 2;
  /** Ordinal value for broadcast. */
  public static final int BROADCAST = 3;
  /** Ordinal value for turnaround. */
  public static final int TURNAROUND = 4;
  
  /** BAddressType constant for none. */
  public static final BAddressType none = new BAddressType(NONE);
  /** BAddressType constant for group. */
  public static final BAddressType group = new BAddressType(GROUP);
  /** BAddressType constant for subnetNode. */
  public static final BAddressType subnetNode = new BAddressType(SUBNET_NODE);
  /** BAddressType constant for broadcast. */
  public static final BAddressType broadcast = new BAddressType(BROADCAST);
  /** BAddressType constant for turnaround. */
  public static final BAddressType turnaround = new BAddressType(TURNAROUND);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAddressType.class);
  
  /** Factory method with ordinal. */
  public static BAddressType make(int ordinal)
  {
    return (BAddressType)none.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BAddressType make(String tag)
  {
    return (BAddressType)none.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BAddressType(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
