/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.sys.*;

/**
 *   This class file ???.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  12 Jan 01
 * @version   $Revision: 2$ $Date: 9/18/01 9:50:13 AM$
 * @since     Niagara 3.0
 */
public class BNcProps
  extends BStruct
{  
  /**
   * No arg constructor
   */
  public BNcProps()
  {
  }

  /*-
  
  class BNcProps
  {
    properties
    {
      nvIndex: int 
        -- NV index within device 
        flags { readonly }
        default {[ 0 ]}
    
      snvtType: int
        -- SNVT index if this nci maps to a standard network variable type or 
        -- 0 if proprietary data type
        flags { readonly }
        default {[ 0 ]}

      configIndex: int
        -- SCPT/UCPT type
        flags { readonly }
        default {[ 0 ]}

      mfgDefined: boolean
        -- false if parameter is Scpt, true if Ucpt
        flags { readonly }
        default {[ false ]}

      modifyFlag: BModifyFlags
        -- indicates conditions for modifying this config property 
        flags { readonly }
        default {[ BModifyFlags.DEFAULT ]}

      scope: BLonConfigScope 
        -- Indicates scope of config parameter 0 node, 1 object, 2 nv 
        flags { readonly }
        default {[BLonConfigScope.node]}

      select: String
        -- list of objects/nvs controled by config parameter
        flags { readonly }
        default {[ "" ]}
    }
  }
  
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BNcProps(265976106)1.0$ @*/
/* Generated Tue Sep 20 15:16:47 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "nvIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nvIndex</code> property.
   * NV index within device
   * @see javax.baja.lonworks.datatypes.BNcProps#getNvIndex
   * @see javax.baja.lonworks.datatypes.BNcProps#setNvIndex
   */
  public static final Property nvIndex = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>nvIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#nvIndex
   */
  public int getNvIndex() { return getInt(nvIndex); }
  
  /**
   * Set the <code>nvIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#nvIndex
   */
  public void setNvIndex(int v) { setInt(nvIndex,v,null); }

////////////////////////////////////////////////////////////////
// Property "snvtType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>snvtType</code> property.
   * SNVT index if this nci maps to a standard network variable type or 0 if proprietary data type
   * @see javax.baja.lonworks.datatypes.BNcProps#getSnvtType
   * @see javax.baja.lonworks.datatypes.BNcProps#setSnvtType
   */
  public static final Property snvtType = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>snvtType</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#snvtType
   */
  public int getSnvtType() { return getInt(snvtType); }
  
  /**
   * Set the <code>snvtType</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#snvtType
   */
  public void setSnvtType(int v) { setInt(snvtType,v,null); }

////////////////////////////////////////////////////////////////
// Property "configIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>configIndex</code> property.
   * SCPT/UCPT type
   * @see javax.baja.lonworks.datatypes.BNcProps#getConfigIndex
   * @see javax.baja.lonworks.datatypes.BNcProps#setConfigIndex
   */
  public static final Property configIndex = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>configIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#configIndex
   */
  public int getConfigIndex() { return getInt(configIndex); }
  
  /**
   * Set the <code>configIndex</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#configIndex
   */
  public void setConfigIndex(int v) { setInt(configIndex,v,null); }

////////////////////////////////////////////////////////////////
// Property "mfgDefined"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>mfgDefined</code> property.
   * false if parameter is Scpt, true if Ucpt
   * @see javax.baja.lonworks.datatypes.BNcProps#getMfgDefined
   * @see javax.baja.lonworks.datatypes.BNcProps#setMfgDefined
   */
  public static final Property mfgDefined = newProperty(Flags.READONLY, false,null);
  
  /**
   * Get the <code>mfgDefined</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#mfgDefined
   */
  public boolean getMfgDefined() { return getBoolean(mfgDefined); }
  
  /**
   * Set the <code>mfgDefined</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#mfgDefined
   */
  public void setMfgDefined(boolean v) { setBoolean(mfgDefined,v,null); }

////////////////////////////////////////////////////////////////
// Property "modifyFlag"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>modifyFlag</code> property.
   * indicates conditions for modifying this config property
   * @see javax.baja.lonworks.datatypes.BNcProps#getModifyFlag
   * @see javax.baja.lonworks.datatypes.BNcProps#setModifyFlag
   */
  public static final Property modifyFlag = newProperty(Flags.READONLY, BModifyFlags.DEFAULT,null);
  
  /**
   * Get the <code>modifyFlag</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#modifyFlag
   */
  public BModifyFlags getModifyFlag() { return (BModifyFlags)get(modifyFlag); }
  
  /**
   * Set the <code>modifyFlag</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#modifyFlag
   */
  public void setModifyFlag(BModifyFlags v) { set(modifyFlag,v,null); }

////////////////////////////////////////////////////////////////
// Property "scope"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scope</code> property.
   * Indicates scope of config parameter 0 node, 1 object,
   * 2 nv
   * @see javax.baja.lonworks.datatypes.BNcProps#getScope
   * @see javax.baja.lonworks.datatypes.BNcProps#setScope
   */
  public static final Property scope = newProperty(Flags.READONLY, BLonConfigScope.node,null);
  
  /**
   * Get the <code>scope</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#scope
   */
  public BLonConfigScope getScope() { return (BLonConfigScope)get(scope); }
  
  /**
   * Set the <code>scope</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#scope
   */
  public void setScope(BLonConfigScope v) { set(scope,v,null); }

////////////////////////////////////////////////////////////////
// Property "select"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>select</code> property.
   * list of objects/nvs controled by config parameter
   * @see javax.baja.lonworks.datatypes.BNcProps#getSelect
   * @see javax.baja.lonworks.datatypes.BNcProps#setSelect
   */
  public static final Property select = newProperty(Flags.READONLY, "",null);
  
  /**
   * Get the <code>select</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#select
   */
  public String getSelect() { return getString(select); }
  
  /**
   * Set the <code>select</code> property.
   * @see javax.baja.lonworks.datatypes.BNcProps#select
   */
  public void setSelect(String v) { setString(select,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNcProps.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Set nci to unbound state.
   */
  public void setUnbound()
  {
  }
  
  public String toString(Context c)
  {
    StringBuffer sb = new StringBuffer();
    sb.append("nv:").append(getNvIndex());  
    if(getSnvtType()>0)sb.append(",snvt:").append(getSnvtType());  
    if(getConfigIndex() != 0)
    {
      sb.append(",cfgNdx:").append(getConfigIndex());  
    }  
    if(getMfgDefined())sb.append(",mfgDefn");  
    sb.append(",mod:").append(getModifyFlag());
    sb.append(",scope:").append(getScope());
    if(getScope()!=BLonConfigScope.node) sb.append(".").append(getSelect());
    return sb.toString();
  }

}
