/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.util.NmUtil;

import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.sys.*;

/**
 *   This class file contains the data needed to represent a specific
 * neuron chip including state information and configurable data in the
 * neuron tables as described in the Appendix A: Neuron Chip Data
 * Structures in the Neuron Chip Data Book.
 * <p>
 *
 * @author    Robert Adams
 * @creation  8 Nov 00
 * @version   $Revision: 2$ $Date: 9/18/01 9:49:36 AM$
 * @since     Niagara 3.0
 */
public class BDeviceData
  extends BComponent
{

  /*-

  class BDeviceData
  {
    properties
    {
      neuronId: BNeuronId
        -- unique 6 byte identifier of Neuron Chip
        flags { defaultOnClone }
        default {[ BNeuronId.DEFAULT ]}
      programId: BProgramId
        -- 8 byte program identifier supplied by device manufacturer
        flags { summary }
        default {[ BProgramId.DEFAULT ]}
      nodeState: BLonNodeState
        -- the current configured state of the lon device
        flags { defaultOnClone }
        default {[ BLonNodeState.unknown ]}
      subnetNodeId: BSubnetNode
        -- subnet node address of this lon device
        flags { defaultOnClone, readonly }
        default {[ BSubnetNode.DEFAULT ]}
      location: String
        -- optional location string supplied by user
        default {[ "" ]}
      authenticate: boolean
        -- flag indicating that authentication is enabled in device
        default {[ false ]}
      channelId: int
        -- channel identifier assigned to this device
        flags { readonly }
        default {[ 0 ]}
      workingDomain: int
        -- the domain table index containing the working domain
        flags { readonly }
        default {[ 0 ]}
      bindingII: boolean
        -- flag indicating if the device uses new binding constraints.
        flags { readonly }
        default {[ false ]}
      hosted: boolean
        -- flag indicating if the device is a hosted node
        flags { readonly }
        default {[ false ]}
      twoDomains: boolean
        -- flag indicating if the devices' domain table has two entries
        flags { readonly }
        default {[ false ]}
      msgTagCount: int
        -- the number of message tags used by the device
        flags { readonly }
        default {[ 0 ]}
      addressCount: int
        -- the number of entries in this devices' address table
        flags { readonly }
        default {[ 0 ]}
      addressTable: BAddressTable
        -- the devices' address table
        flags { defaultOnClone, readonly }
        default {[ new BAddressTable() ]}
      extAddressTable: BExtAddressTable
        -- the devices' address table
        flags { hidden }
        default {[ new BExtAddressTable() ]}
      prioritySlot: int
        flags { readonly }
        default {[ 0 ]}
      aliasTable: BAliasTable
        -- the number of network variable aliases supported on the device
        flags { readonly }
        default {[ new BAliasTable() ]}
      selfDoc: String
        -- selfdocumentation string
        default {[ "" ]}
      hasNodeObject: boolean
        -- flag indicating if devices has a node object
        default {[ false ]}
      freezeChannelPriorities  : boolean
        default {[ false ]}
      lastHash: int
        flags { hidden,readonly,defaultOnClone,transient }
        default {[ -1 ]}
      facets: BFacets
        -- Facets used to configure network management operations.
        --  delayToReset - mSec delay inserted before reset during commissioning       
        --  delayToHardOffline - mSec delay inserted before setting to hardOffline during commissioning
        --  minNvUpdateInterMsgDelay - minimum delay between nv updates to device
        --  disableSetOfflineInBind - do not set device offline when modifying address table during a bind operation
        default {[ BFacets.DEFAULT ]}  
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BDeviceData(3763587682)1.0$ @*/
/* Generated Wed Dec 15 10:25:03 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "neuronId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>neuronId</code> property.
   * unique 6 byte identifier of Neuron Chip
   * @see javax.baja.lonworks.datatypes.BDeviceData#getNeuronId
   * @see javax.baja.lonworks.datatypes.BDeviceData#setNeuronId
   */
  public static final Property neuronId = newProperty(Flags.DEFAULT_ON_CLONE, BNeuronId.DEFAULT,null);
  
  /**
   * Get the <code>neuronId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#neuronId
   */
  public BNeuronId getNeuronId() { return (BNeuronId)get(neuronId); }
  
  /**
   * Set the <code>neuronId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#neuronId
   */
  public void setNeuronId(BNeuronId v) { set(neuronId,v,null); }

////////////////////////////////////////////////////////////////
// Property "programId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>programId</code> property.
   * 8 byte program identifier supplied by device manufacturer
   * @see javax.baja.lonworks.datatypes.BDeviceData#getProgramId
   * @see javax.baja.lonworks.datatypes.BDeviceData#setProgramId
   */
  public static final Property programId = newProperty(Flags.SUMMARY, BProgramId.DEFAULT,null);
  
  /**
   * Get the <code>programId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#programId
   */
  public BProgramId getProgramId() { return (BProgramId)get(programId); }
  
  /**
   * Set the <code>programId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#programId
   */
  public void setProgramId(BProgramId v) { set(programId,v,null); }

////////////////////////////////////////////////////////////////
// Property "nodeState"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nodeState</code> property.
   * the current configured state of the lon device
   * @see javax.baja.lonworks.datatypes.BDeviceData#getNodeState
   * @see javax.baja.lonworks.datatypes.BDeviceData#setNodeState
   */
  public static final Property nodeState = newProperty(Flags.DEFAULT_ON_CLONE, BLonNodeState.unknown,null);
  
  /**
   * Get the <code>nodeState</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#nodeState
   */
  public BLonNodeState getNodeState() { return (BLonNodeState)get(nodeState); }
  
  /**
   * Set the <code>nodeState</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#nodeState
   */
  public void setNodeState(BLonNodeState v) { set(nodeState,v,null); }

////////////////////////////////////////////////////////////////
// Property "subnetNodeId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>subnetNodeId</code> property.
   * subnet node address of this lon device
   * @see javax.baja.lonworks.datatypes.BDeviceData#getSubnetNodeId
   * @see javax.baja.lonworks.datatypes.BDeviceData#setSubnetNodeId
   */
  public static final Property subnetNodeId = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, BSubnetNode.DEFAULT,null);
  
  /**
   * Get the <code>subnetNodeId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#subnetNodeId
   */
  public BSubnetNode getSubnetNodeId() { return (BSubnetNode)get(subnetNodeId); }
  
  /**
   * Set the <code>subnetNodeId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#subnetNodeId
   */
  public void setSubnetNodeId(BSubnetNode v) { set(subnetNodeId,v,null); }

////////////////////////////////////////////////////////////////
// Property "location"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>location</code> property.
   * optional location string supplied by user
   * @see javax.baja.lonworks.datatypes.BDeviceData#getLocation
   * @see javax.baja.lonworks.datatypes.BDeviceData#setLocation
   */
  public static final Property location = newProperty(0, "",null);
  
  /**
   * Get the <code>location</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#location
   */
  public String getLocation() { return getString(location); }
  
  /**
   * Set the <code>location</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#location
   */
  public void setLocation(String v) { setString(location,v,null); }

////////////////////////////////////////////////////////////////
// Property "authenticate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>authenticate</code> property.
   * flag indicating that authentication is enabled in device
   * @see javax.baja.lonworks.datatypes.BDeviceData#getAuthenticate
   * @see javax.baja.lonworks.datatypes.BDeviceData#setAuthenticate
   */
  public static final Property authenticate = newProperty(0, false,null);
  
  /**
   * Get the <code>authenticate</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#authenticate
   */
  public boolean getAuthenticate() { return getBoolean(authenticate); }
  
  /**
   * Set the <code>authenticate</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#authenticate
   */
  public void setAuthenticate(boolean v) { setBoolean(authenticate,v,null); }

////////////////////////////////////////////////////////////////
// Property "channelId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>channelId</code> property.
   * channel identifier assigned to this device
   * @see javax.baja.lonworks.datatypes.BDeviceData#getChannelId
   * @see javax.baja.lonworks.datatypes.BDeviceData#setChannelId
   */
  public static final Property channelId = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>channelId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#channelId
   */
  public int getChannelId() { return getInt(channelId); }
  
  /**
   * Set the <code>channelId</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#channelId
   */
  public void setChannelId(int v) { setInt(channelId,v,null); }

////////////////////////////////////////////////////////////////
// Property "workingDomain"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>workingDomain</code> property.
   * the domain table index containing the working domain
   * @see javax.baja.lonworks.datatypes.BDeviceData#getWorkingDomain
   * @see javax.baja.lonworks.datatypes.BDeviceData#setWorkingDomain
   */
  public static final Property workingDomain = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>workingDomain</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#workingDomain
   */
  public int getWorkingDomain() { return getInt(workingDomain); }
  
  /**
   * Set the <code>workingDomain</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#workingDomain
   */
  public void setWorkingDomain(int v) { setInt(workingDomain,v,null); }

////////////////////////////////////////////////////////////////
// Property "bindingII"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>bindingII</code> property.
   * flag indicating if the device uses new binding constraints.
   * @see javax.baja.lonworks.datatypes.BDeviceData#getBindingII
   * @see javax.baja.lonworks.datatypes.BDeviceData#setBindingII
   */
  public static final Property bindingII = newProperty(Flags.READONLY, false,null);
  
  /**
   * Get the <code>bindingII</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#bindingII
   */
  public boolean getBindingII() { return getBoolean(bindingII); }
  
  /**
   * Set the <code>bindingII</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#bindingII
   */
  public void setBindingII(boolean v) { setBoolean(bindingII,v,null); }

////////////////////////////////////////////////////////////////
// Property "hosted"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>hosted</code> property.
   * flag indicating if the device is a hosted node
   * @see javax.baja.lonworks.datatypes.BDeviceData#getHosted
   * @see javax.baja.lonworks.datatypes.BDeviceData#setHosted
   */
  public static final Property hosted = newProperty(Flags.READONLY, false,null);
  
  /**
   * Get the <code>hosted</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#hosted
   */
  public boolean getHosted() { return getBoolean(hosted); }
  
  /**
   * Set the <code>hosted</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#hosted
   */
  public void setHosted(boolean v) { setBoolean(hosted,v,null); }

////////////////////////////////////////////////////////////////
// Property "twoDomains"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>twoDomains</code> property.
   * flag indicating if the devices' domain table has two
   * entries
   * @see javax.baja.lonworks.datatypes.BDeviceData#getTwoDomains
   * @see javax.baja.lonworks.datatypes.BDeviceData#setTwoDomains
   */
  public static final Property twoDomains = newProperty(Flags.READONLY, false,null);
  
  /**
   * Get the <code>twoDomains</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#twoDomains
   */
  public boolean getTwoDomains() { return getBoolean(twoDomains); }
  
  /**
   * Set the <code>twoDomains</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#twoDomains
   */
  public void setTwoDomains(boolean v) { setBoolean(twoDomains,v,null); }

////////////////////////////////////////////////////////////////
// Property "msgTagCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>msgTagCount</code> property.
   * the number of message tags used by the device
   * @see javax.baja.lonworks.datatypes.BDeviceData#getMsgTagCount
   * @see javax.baja.lonworks.datatypes.BDeviceData#setMsgTagCount
   */
  public static final Property msgTagCount = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>msgTagCount</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#msgTagCount
   */
  public int getMsgTagCount() { return getInt(msgTagCount); }
  
  /**
   * Set the <code>msgTagCount</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#msgTagCount
   */
  public void setMsgTagCount(int v) { setInt(msgTagCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "addressCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addressCount</code> property.
   * the number of entries in this devices' address table
   * @see javax.baja.lonworks.datatypes.BDeviceData#getAddressCount
   * @see javax.baja.lonworks.datatypes.BDeviceData#setAddressCount
   */
  public static final Property addressCount = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>addressCount</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#addressCount
   */
  public int getAddressCount() { return getInt(addressCount); }
  
  /**
   * Set the <code>addressCount</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#addressCount
   */
  public void setAddressCount(int v) { setInt(addressCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "addressTable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addressTable</code> property.
   * the devices' address table
   * @see javax.baja.lonworks.datatypes.BDeviceData#getAddressTable
   * @see javax.baja.lonworks.datatypes.BDeviceData#setAddressTable
   */
  public static final Property addressTable = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, new BAddressTable(),null);
  
  /**
   * Get the <code>addressTable</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#addressTable
   */
  public BAddressTable getAddressTable() { return (BAddressTable)get(addressTable); }
  
  /**
   * Set the <code>addressTable</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#addressTable
   */
  public void setAddressTable(BAddressTable v) { set(addressTable,v,null); }

////////////////////////////////////////////////////////////////
// Property "extAddressTable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>extAddressTable</code> property.
   * the devices' address table
   * @see javax.baja.lonworks.datatypes.BDeviceData#getExtAddressTable
   * @see javax.baja.lonworks.datatypes.BDeviceData#setExtAddressTable
   */
  public static final Property extAddressTable = newProperty(Flags.HIDDEN, new BExtAddressTable(),null);
  
  /**
   * Get the <code>extAddressTable</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#extAddressTable
   */
  public BExtAddressTable getExtAddressTable() { return (BExtAddressTable)get(extAddressTable); }
  
  /**
   * Set the <code>extAddressTable</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#extAddressTable
   */
  public void setExtAddressTable(BExtAddressTable v) { set(extAddressTable,v,null); }

////////////////////////////////////////////////////////////////
// Property "prioritySlot"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>prioritySlot</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#getPrioritySlot
   * @see javax.baja.lonworks.datatypes.BDeviceData#setPrioritySlot
   */
  public static final Property prioritySlot = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>prioritySlot</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#prioritySlot
   */
  public int getPrioritySlot() { return getInt(prioritySlot); }
  
  /**
   * Set the <code>prioritySlot</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#prioritySlot
   */
  public void setPrioritySlot(int v) { setInt(prioritySlot,v,null); }

////////////////////////////////////////////////////////////////
// Property "aliasTable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>aliasTable</code> property.
   * the number of network variable aliases supported on
   * the device
   * @see javax.baja.lonworks.datatypes.BDeviceData#getAliasTable
   * @see javax.baja.lonworks.datatypes.BDeviceData#setAliasTable
   */
  public static final Property aliasTable = newProperty(Flags.READONLY, new BAliasTable(),null);
  
  /**
   * Get the <code>aliasTable</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#aliasTable
   */
  public BAliasTable getAliasTable() { return (BAliasTable)get(aliasTable); }
  
  /**
   * Set the <code>aliasTable</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#aliasTable
   */
  public void setAliasTable(BAliasTable v) { set(aliasTable,v,null); }

////////////////////////////////////////////////////////////////
// Property "selfDoc"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selfDoc</code> property.
   * selfdocumentation string
   * @see javax.baja.lonworks.datatypes.BDeviceData#getSelfDoc
   * @see javax.baja.lonworks.datatypes.BDeviceData#setSelfDoc
   */
  public static final Property selfDoc = newProperty(0, "",null);
  
  /**
   * Get the <code>selfDoc</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#selfDoc
   */
  public String getSelfDoc() { return getString(selfDoc); }
  
  /**
   * Set the <code>selfDoc</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#selfDoc
   */
  public void setSelfDoc(String v) { setString(selfDoc,v,null); }

////////////////////////////////////////////////////////////////
// Property "hasNodeObject"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>hasNodeObject</code> property.
   * flag indicating if devices has a node object
   * @see javax.baja.lonworks.datatypes.BDeviceData#getHasNodeObject
   * @see javax.baja.lonworks.datatypes.BDeviceData#setHasNodeObject
   */
  public static final Property hasNodeObject = newProperty(0, false,null);
  
  /**
   * Get the <code>hasNodeObject</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#hasNodeObject
   */
  public boolean getHasNodeObject() { return getBoolean(hasNodeObject); }
  
  /**
   * Set the <code>hasNodeObject</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#hasNodeObject
   */
  public void setHasNodeObject(boolean v) { setBoolean(hasNodeObject,v,null); }

////////////////////////////////////////////////////////////////
// Property "freezeChannelPriorities"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>freezeChannelPriorities</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#getFreezeChannelPriorities
   * @see javax.baja.lonworks.datatypes.BDeviceData#setFreezeChannelPriorities
   */
  public static final Property freezeChannelPriorities = newProperty(0, false,null);
  
  /**
   * Get the <code>freezeChannelPriorities</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#freezeChannelPriorities
   */
  public boolean getFreezeChannelPriorities() { return getBoolean(freezeChannelPriorities); }
  
  /**
   * Set the <code>freezeChannelPriorities</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#freezeChannelPriorities
   */
  public void setFreezeChannelPriorities(boolean v) { setBoolean(freezeChannelPriorities,v,null); }

////////////////////////////////////////////////////////////////
// Property "lastHash"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lastHash</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#getLastHash
   * @see javax.baja.lonworks.datatypes.BDeviceData#setLastHash
   */
  public static final Property lastHash = newProperty(Flags.HIDDEN|Flags.READONLY|Flags.DEFAULT_ON_CLONE|Flags.TRANSIENT, -1,null);
  
  /**
   * Get the <code>lastHash</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#lastHash
   */
  public int getLastHash() { return getInt(lastHash); }
  
  /**
   * Set the <code>lastHash</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#lastHash
   */
  public void setLastHash(int v) { setInt(lastHash,v,null); }

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * Facets used to configure network management operations.
   * delayToReset - mSec delay inserted before reset during
   * commissioning delayToHardOffline - mSec delay inserted
   * before setting to hardOffline during commissioning
   * minNvUpdateInterMsgDelay - minimum delay between nv
   * updates to device disableSetOfflineInBind - do not
   * set device offline when modifying address table during
   * a bind operation
   * @see javax.baja.lonworks.datatypes.BDeviceData#getFacets
   * @see javax.baja.lonworks.datatypes.BDeviceData#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.DEFAULT,null);
  
  /**
   * Get the <code>facets</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see javax.baja.lonworks.datatypes.BDeviceData#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDeviceData.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  public BDeviceData() {}
  
  public BDeviceData(BProgramId pid)
  {
  	setProgramId(pid);
  }
  
  public BDeviceData(BProgramId pid,
                     boolean    bindingII, 
                     boolean    hosted,
                     boolean    twoDomains,
                     int        msgTagCount,
                     int        addressCount,
                     int        aliasCount,  
                     boolean    hasNodeObject)
  {
  	setProgramId(pid);
  	setBindingII(bindingII);
  	setHosted(hosted);
  	setTwoDomains(twoDomains);
  	setMsgTagCount(msgTagCount);
  	setAddressCount(addressCount);
  	if(aliasCount>0) setAliasTable(new BAliasTable(aliasCount));
  	setHasNodeObject(hasNodeObject);
  }

  public void changed(Property prop, Context context)
  {
    super.changed(prop, context);
    if(!isRunning() || context==importChanges) return;
    
    // If facets change force recreate of pickle
    if(prop==facets) pickle = null;
    
    // Give parent device opportunity to respond.
    BObject p = getParent();
    if(p instanceof BLonDevice)
    {
      ((BLonDevice)p).deviceDataChanged(prop,context);
    }

    if( (prop == neuronId) ||
        (prop == programId) ||
        (prop == nodeState) ||
        (prop == subnetNodeId) ||
        (prop == channelId) )
    {
      NmUtil.getLonNetwork(this).addressManager().deviceDataChanged(this, context);
    }

    if( (context==AddressManager.noDeviceChange) ||
        (context==NAddressManager.localChange)  )
    {
      return;
    }
    
    if(getNeuronId().isZero()) return;
    
    Runnable req = null;
    if(prop==nodeState) 
    {
      req = new Runnable()
          {
            public void run() { updateNodeState(); }
          };
    }
    else if(prop == subnetNodeId ||
            prop == workingDomain) 
    {
      req = new Runnable()
          {
            public void run() { updateSubnetNodeId(); }
          };
    }  
    
    if(req!=null) NmUtil.getLonNetwork(this).postAsync(req);
  }
  
  private void updateSubnetNodeId()
  {  
    BComplex o = getParent();
    if(o instanceof BLonDevice)
    {
      BLonDevice dev = (BLonDevice)o;
      dev.updateDomainTable();
    }
  }

  private void updateNodeState()
  {
    boolean err = false;
    BComplex o = getParent();
    BLonNodeState nState = getNodeState();
    LonException cause = null;

    if(o instanceof BLonDevice)
    {
      BLonDevice dev = (BLonDevice)o;
      dev.updateNodeState();
    }
    else if(o instanceof BLonRouter)
    {
      // Keep near and far side the same
      BLonRouter rtr = (BLonRouter)o;
      try
      {
        NmUtil.setDeviceState(rtr, nState, true );
        NmUtil.setDeviceState(rtr, nState, false );
      }
      catch(LonException e)
      {
        err = true;
        cause = e;
      }

      rtr.getNearDeviceData().set(nodeState,nState,AddressManager.noDeviceChange);
      rtr.getFarDeviceData().set(nodeState,nState,AddressManager.noDeviceChange);
    }

    if(err) throw new BajaRuntimeException("Unable to update state change in " + o.getDisplayName(null), cause);
  }
  
  // Need to store DeviceFacets here. This is created from the BFacets in deviceFacets slot and was
  // previously stored on the BFacets pickle.  However the pickle was not getting saved to the facets
  // causing DeviceFacets to be recreate each time used (i.e. every nvupdate)
  private Object pickle = null;
  
  /** For internal use only */
  public void setPickle(Object o) 
  {
    if(o instanceof DeviceFacets) pickle=o;
  }
  /** For internal use only */
  public Object getPickle() { return pickle; }
  
  /** 
   * Does this device use extended device tables and implement extended network
   *  management messages. 
   */
  public boolean isExtended() { return false; }
  
  public void clearAddressTable() { getAddressTable().clearTable(); }
  
  public BIAddressEntry getAddressEntry(int index)                   { return getAddressTable().getAddressEntry(index); }
  public void setAddressEntry(int index, BIAddressEntry e)           { getAddressTable().setAddressEntry(index,e); }
  public void setAddressEntry(int index, BIAddressEntry e, Context c){ getAddressTable().setAddressEntry(index,e,c); }       
  
////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("deviceData.png");

  public static final Context importChanges = new BasicContext();

}
