/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.sys.*;

/**
 *  Contains the data in lonworks device alias table.
 * <p>
 *
 * @author    Robert Adams
 * @creation  8 Nov 00
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BAliasTable
  extends BComponent
{
  /*-       

  class BAliasTable
  {
    properties
    {
      aliasCount : int
        -- the number of network variable aliases supported on the device
        flags { readonly }
        default {[ 0 ]}
      aliasOffset : int
        -- the offset to add to the alias index when accessing alias config data
        flags { hidden }
        default {[ 0 ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BAliasTable(395033260)1.0$ @*/
/* Generated Tue Aug 15 09:32:42 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "aliasCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>aliasCount</code> property.
   * the number of network variable aliases supported on
   * the device
   * @see javax.baja.lonworks.datatypes.BAliasTable#getAliasCount
   * @see javax.baja.lonworks.datatypes.BAliasTable#setAliasCount
   */
  public static final Property aliasCount = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>aliasCount</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasTable#aliasCount
   */
  public int getAliasCount() { return getInt(aliasCount); }
  
  /**
   * Set the <code>aliasCount</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasTable#aliasCount
   */
  public void setAliasCount(int v) { setInt(aliasCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "aliasOffset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>aliasOffset</code> property.
   * the offset to add to the alias index when accessing
   * alias config data
   * @see javax.baja.lonworks.datatypes.BAliasTable#getAliasOffset
   * @see javax.baja.lonworks.datatypes.BAliasTable#setAliasOffset
   */
  public static final Property aliasOffset = newProperty(Flags.HIDDEN, 0,null);
  
  /**
   * Get the <code>aliasOffset</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasTable#aliasOffset
   */
  public int getAliasOffset() { return getInt(aliasOffset); }
  
  /**
   * Set the <code>aliasOffset</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasTable#aliasOffset
   */
  public void setAliasOffset(int v) { setInt(aliasOffset,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAliasTable.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
/* */
  public BAliasTable(){}

  public BAliasTable(int count)
  {
    setAliasCount(count);
    //createCount(count);
    verifyAliasCount();
  }
  
  public void started()
    throws Exception
  {
    super.started();
    
    if(getAliasCount()>0) verifyAliasCount();
  }
  
  public void changed(Property prop, Context context)
  {
    super.changed(prop, context);
    if(!isRunning()) return;

    if(prop == aliasCount){verifyAliasCount();}
  }


  public void verifyAliasCount()
  {
    int count = getAliasCount();
    int i=0;
    String entryName;
    Property prop;
    for(; i<count ; i++)
    {
      entryName = propName(i);
      // If the property already exists set to default else add.
      prop = getProperty(entryName);
      if( prop == null)
        add(entryName,new BAliasConfigData(),null);
    }

    // remove any additional entries
    entryName = propName(i++);
    while( (prop = getProperty(entryName)) != null)
    {
      remove(prop);
      entryName = propName(i++);
    }
  }


  public void clearTable()
  {
    SlotCursor<Property> c = getProperties();
    while(c.next(BAliasConfigData.class))
    {
      ((BAliasConfigData)c.get()).clearData();
    }
  }

  public BAliasConfigData getAliasEntry(int index)
  {
    return (BAliasConfigData)get(propName(index));
  }

  public void setAliasEntry(int index, BAliasConfigData ad)
  {
    set(propName(index),ad);
  }

  public BAliasConfigData[] getAliasArray()
  {
    BAliasConfigData[] a = new BAliasConfigData[getAliasCount()];

    for(int i=0 ; i<a.length ; i++) a[i] = getAliasEntry(i);

    return a;
  }

  private String propName(int ndx) { return "entry" + ndx; }



}
