/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.*;

/**
 *  This class file represents the network variable alias 
 *  table field described in Appendix A.4.2: Neuron Chip 
 *  Data Structures in the Neuron Chip Data Book.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  8 Jan 01
 * @version   $Revision: 2$ $Date: 9/18/01 9:50:15 AM$
 * @since     Niagara 3.0
 */
public class BAliasConfigData
  extends BNvConfigData
{  
  /** Make default selector unbound base.  */
  public static final Property selector = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, UNBOUND_NV_BASE_SELECTOR,BFacets.make(BFacets.RADIX,BInteger.make(16)) );
  /** Make defaulOnClone.  */
  public static final Property direction = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, BLonNvDirection.input,null);

  /*-
  
  class BAliasConfigData
  {
    properties
    {
      primary:     int   
        -- Index of primary network variable for which this is an alias.
        flags {defaultOnClone, readonly }
        default {[ -1 ]}
      state:     int   
        flags {defaultOnClone, readonly, hidden }
        default {[ 0 ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.datatypes.BAliasConfigData(3410253506)1.0$ @*/
/* Generated Tue Jun 13 15:39:39 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "primary"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>primary</code> property.
   * Index of primary network variable for which this is
   * an alias.
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#getPrimary
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#setPrimary
   */
  public static final Property primary = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, -1,null);
  
  /**
   * Get the <code>primary</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#primary
   */
  public int getPrimary() { return getInt(primary); }
  
  /**
   * Set the <code>primary</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#primary
   */
  public void setPrimary(int v) { setInt(primary,v,null); }

////////////////////////////////////////////////////////////////
// Property "state"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>state</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#getState
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#setState
   */
  public static final Property state = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY|Flags.HIDDEN, 0,null);
  
  /**
   * Get the <code>state</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#state
   */
  public int getState() { return getInt(state); }
  
  /**
   * Set the <code>state</code> property.
   * @see javax.baja.lonworks.datatypes.BAliasConfigData#state
   */
  public void setState(int v) { setInt(state,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAliasConfigData.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  API
////////////////////////////////////////////////////////////////  
  public boolean isAlias() { return true; }
  
  /** Return all properties to default value */
  public void clearData()
  {
      setPriority     (false);
      setDirection    (BLonNvDirection.input);
      setSelector     (UNBOUND_NV_BASE_SELECTOR);
      setTurnAround   (false);
      setServiceType  (BLonServiceType.unacked);
      setAuthenticated(false);
      setAddrIndex    (DEFAULT_ADDR_INDEX);
      setPrimary      (-1);    
      setState        (FREE);
  }
  

  /** Write this aliasNvConfig to the specified output stream. */
  public void writeNetworkBytes(LonOutputStream outputStream)
  {
    super.writeNetworkBytes(outputStream);
    int primary = getPrimary();
    if(primary<0)
    {
      // set unused
      outputStream.writeUnsigned8(-1);
      outputStream.writeUnsigned16(-1);
    }
    else if(primary >= 255)
    {
      outputStream.writeUnsigned8(255);
      outputStream.writeUnsigned16(primary);
    }
    else
    {
      outputStream.writeUnsigned8(primary);
    }
  }

  /**********************************************
  *  Extract the Nv Config Response data from
  *  the LonInputStream 
  *  
  *  @param  inputStream  data stream of message
  **********************************************/
  public void fromInputStream(LonInputStream inputStream)
  {
    super.fromInputStream(inputStream);
    
    // If no more bytes this config was for a nv not an alias
    if(inputStream.available()<=0) return;
    
    int primary = inputStream.readUnsigned8();
    if (primary == 255 && inputStream.available()>=2) primary = inputStream.readUnsigned16();
    
    setPrimary(primary);    
  }


  public String toString(Context c)
  {
    return super.toString(c) + ",pri:" + getPrimary() + ",s:" + getState();                                                                      
  }
  
////////////////////////////////////////////////////////////////
//  Manage state
////////////////////////////////////////////////////////////////  

  public static final int UNAVAILABLE_BIT    = 1;
  public static final int RESERVE_BIT        = 2;
  public static final int BOUND_BIT          = 4;
  
  public static final int FREE               = 0;
  public static final int RESERVED           = RESERVE_BIT + UNAVAILABLE_BIT;
  public static final int BOUND              = BOUND_BIT + UNAVAILABLE_BIT;
 
  public boolean isAvailable() {return (getState() & UNAVAILABLE_BIT) == 0; }
  public boolean isReserved()  {return (getState() & RESERVE_BIT) != 0; }
  
  // Don't change bound bit
  public void reserve()        { setState( getState() | RESERVED); }
  public void makeAvailable()  { setState( getState() & ~RESERVED); }

  public void setBound()       { setState( BOUND ); }
  public void setFree()        { setState( FREE ); }
  
}
