 /*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks;

 import javax.baja.lonworks.enums.BLonNvDirection;
 import javax.baja.sys.*;

//import com.tridium.lonworks.util.NmUtil;

/**
 *  BMessageTag represents a single network variable
 *  in a LonDevice. It provides specific support for runtime
 *  updates and contains data needed to support network managment.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  8 Nov 00
 * @version   $Revision: 4$ $Date: 10/18/01 2:56:44 PM$
 * @since     Niagara 3.0
 */
public class BMessageTag
  extends BVector
{  
  /*-
  
  class BMessageTag
  {
    properties
    {
      index : int
        --  Tag index.
        default {[ -1 ]}
      direction:     BLonNvDirection  
        -- Flag to indicate if message tag is input or output.
        default {[ BLonNvDirection.input ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.BMessageTag(387105601)1.0$ @*/
/* Generated Tue Apr 06 10:08:40 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "index"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>index</code> property.
   * Tag index.
   * @see javax.baja.lonworks.BMessageTag#getIndex
   * @see javax.baja.lonworks.BMessageTag#setIndex
   */
  public static final Property index = newProperty(0, -1,null);
  
  /**
   * Get the <code>index</code> property.
   * @see javax.baja.lonworks.BMessageTag#index
   */
  public int getIndex() { return getInt(index); }
  
  /**
   * Set the <code>index</code> property.
   * @see javax.baja.lonworks.BMessageTag#index
   */
  public void setIndex(int v) { setInt(index,v,null); }

////////////////////////////////////////////////////////////////
// Property "direction"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>direction</code> property.
   * Flag to indicate if message tag is input or output.
   * @see javax.baja.lonworks.BMessageTag#getDirection
   * @see javax.baja.lonworks.BMessageTag#setDirection
   */
  public static final Property direction = newProperty(0, BLonNvDirection.input,null);
  
  /**
   * Get the <code>direction</code> property.
   * @see javax.baja.lonworks.BMessageTag#direction
   */
  public BLonNvDirection getDirection() { return (BLonNvDirection)get(direction); }
  
  /**
   * Set the <code>direction</code> property.
   * @see javax.baja.lonworks.BMessageTag#direction
   */
  public void setDirection(BLonNvDirection v) { set(direction,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMessageTag.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /**
   * No arg constructor
   */
  public BMessageTag()
  {
  }
  
////////////////////////////////////////////////////////////////
// Api 
////////////////////////////////////////////////////////////////

  public boolean isInput() { return getDirection()==BLonNvDirection.input; }
  public boolean isOutput() { return getDirection()==BLonNvDirection.output; }
  
////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.make("module://lonworks/com/tridium/lonworks/ui/icons/mtag.png");
  
  
  public BMessageTag(int index, BLonNvDirection direction)
  {
    setIndex(index);
    setDirection(direction);
  } 
  
}
