/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks;

import javax.baja.sys.*;

/**
 * The ILonLoadable interface is implemented by Lonworks BComponents 
 * which support async upload and download actions.
 *
 * @author    Robert Adams
 * @creation  31 Jan 06
 * @version   $Revision$ $Date: 2/11/2004 4:14:14 PM$
 * @since     Baja 1.0
 */
public interface BILonLoadable
  extends BInterface
{
  public static final Type TYPE = Sys.loadType(BILonLoadable.class);

  /** Override point to customize upload process.  This will be called at the beginning of an upload operation. */ //after initUpload() 
  public void beginUpload();
  /** Override point to customize upload process.  This will be called after all device components have been uploaded. */ 
  public void endUpload();
  
  /** Override point to customize download process.  This will be called at the beginning of a download operation . */ //after initDownload()
  public void beginDownload();
  /** Override point to customize download process.  This will be called after all device components have been downloaded. */ 
  public void endDownload();
   
  public BLonDevice getLonDevice();
  
  // From BComponent
  public BComponent asComponent(); 
  public String getName();
  public String getDisplayName(Context cx);
}
