/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx.pdf;

import javax.baja.pdf.PdfOp;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import com.tridium.kitpx.BBoundLabel;
import com.tridium.pdf.BIPdfWidget;

/**
 * BPdfBoundLabel.
 *
 * @author   Andy Frank
 * @creation 17 May 05
 * @version  $Revision$ $Date$
 * @since    Baja 1.0
 */
public class BPdfBoundLabel
  extends BBoundLabel
  implements BIPdfWidget
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPdfBoundLabel.class);
      
////////////////////////////////////////////////////////////////
// BIPdfWidget
////////////////////////////////////////////////////////////////
  

  /**
   * Create from this source BWidget.
   */
  public void fromWidget(BWidget widget, PdfOp op)
  {    
    SlotCursor<Property> c = widget.getProperties();
    while (c.next())
    {
      Property prop = c.property();
      if (prop.isFrozen() && get(prop.getName()) != null) 
        set(prop.getName(), widget.get(prop));
    }
  }
}

