/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx.hx;

import java.io.IOException;

import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

/**
 * BHxLogoffButton.
 *
 * @author    Andy Frank
 * @creation  14 Feb 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BHxLogoffButton
  extends BHxWbCommandButton
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BHxLogoffButton INSTANCE = new BHxLogoffButton();

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxLogoffButton.class);
  
  protected BHxLogoffButton() {}

  public void handle(BInputEvent event, HxOp op)
    throws IOException
  {
    if (event instanceof BMouseEvent && event.getId() == BMouseEvent.MOUSE_PRESSED)
    {
      BMouseEvent mouseEvent = (BMouseEvent)event;
      if(mouseEvent.isButton1Down())
      {
        //Stick the csrf token in if there is a valid session
        String csrfTokenQs = HxUtil.getCsrfTokenQueryString();

        HtmlWriter out = op.getHtmlWriter();
        out.append("hx.hyperlink").append("('");
        out.append("/logout");
        out.append(csrfTokenQs);
        out.append("');");
      }
    }
  }   
  
}


