/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx.hx;

import java.io.IOException;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

/**
 * BHxForwardButton.
 *
 * @author    JJ Frankovich
 * @creation  09 Jul 09
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BHxForwardButton
  extends BHxWbCommandButton
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public static final BHxForwardButton INSTANCE = new BHxForwardButton();

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxForwardButton.class);

  protected BHxForwardButton() {}

  public void handle(BInputEvent event, HxOp op)
    throws IOException
  {
    if (event instanceof BMouseEvent && event.getId() == BMouseEvent.MOUSE_PRESSED)
    {
      BMouseEvent mouseEvent = (BMouseEvent)event;
      if(mouseEvent.isButton1Down())
      {
        HtmlWriter out = op.getHtmlWriter();
        out.w("history.go(1);");
      }
    }
  }   

}


