/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BStatusToBrushMode
 *
 * @author    Brian Frank
 * @creation  1 Dec 00
 * @version   $Revision$ $Date: 23-Mar-05 11:29:07 AM$
 * @since     Baja 1.0
 */
public final class BStatusToBrushMode
  extends BFrozenEnum
{

  /*-

  enum BStatusToBrushMode
  {
    range
    {
      background,
      foreground,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.enums.BStatusToBrushMode(3327347070)1.0$ @*/
/* Generated Thu Feb 14 09:31:33 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for background. */
  public static final int BACKGROUND = 0;
  /** Ordinal value for foreground. */
  public static final int FOREGROUND = 1;
  
  /** BStatusToBrushMode constant for background. */
  public static final BStatusToBrushMode background = new BStatusToBrushMode(BACKGROUND);
  /** BStatusToBrushMode constant for foreground. */
  public static final BStatusToBrushMode foreground = new BStatusToBrushMode(FOREGROUND);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusToBrushMode.class);
  
  /** Factory method with ordinal. */
  public static BStatusToBrushMode make(int ordinal)
  {
    return (BStatusToBrushMode)background.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BStatusToBrushMode make(String tag)
  {
    return (BStatusToBrushMode)background.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BStatusToBrushMode(int ordinal)
  {
    super(ordinal);
  }
  
  /** DEFAULT is background */
  public static final BStatusToBrushMode DEFAULT = background;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}

