/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandEvent;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import com.tridium.platform.BSystemPlatformService;

/**
 * BRebootButton provides a mechanism to restart a station
 *
 * @author    John Huffman
 * @creation  25 Mar 08
 * @version   $Revision$
 * @since     Niagara 3.4
 */

public class BRebootButton
  extends BLocalizableButton
{ 

  /*-
   class BRebootButton
   {
     properties
     {
       textFormat: BFormat
       -- The formatted string to use for the displayed label.
       default {[ BFormat.make("%lexicon(kitPx:command.reboot.label)%") ]}

       image: BImage
       -- Image to display on the label.
       default {[ BImage.make( BIcon.std("reboot.png") ) ]}
     }
   }
  
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BRebootButton(3689385183)1.0$ @*/
/* Generated Tue Apr 15 16:38:50 EDT 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "textFormat"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>textFormat</code> property.
   * The formatted string to use for the displayed label.
   * @see com.tridium.kitpx.BRebootButton#getTextFormat
   * @see com.tridium.kitpx.BRebootButton#setTextFormat
   */
  public static final Property textFormat = newProperty(0, BFormat.make("%lexicon(kitPx:command.reboot.label)%"),null);
  
  /**
   * Get the <code>textFormat</code> property.
   * @see com.tridium.kitpx.BRebootButton#textFormat
   */
  public BFormat getTextFormat() { return (BFormat)get(textFormat); }
  
  /**
   * Set the <code>textFormat</code> property.
   * @see com.tridium.kitpx.BRebootButton#textFormat
   */
  public void setTextFormat(BFormat v) { set(textFormat,v,null); }

////////////////////////////////////////////////////////////////
// Property "image"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>image</code> property.
   * Image to display on the label.
   * @see com.tridium.kitpx.BRebootButton#getImage
   * @see com.tridium.kitpx.BRebootButton#setImage
   */
  public static final Property image = newProperty(0, BImage.make( BIcon.std("reboot.png") ),null);
  
  /**
   * Get the <code>image</code> property.
   * @see com.tridium.kitpx.BRebootButton#image
   */
  public BImage getImage() { return (BImage)get(image); }
  
  /**
   * Set the <code>image</code> property.
   * @see com.tridium.kitpx.BRebootButton#image
   */
  public void setImage(BImage v) { set(image,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRebootButton.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /**
   * Enable/Disable the button based on user permission.
   */
  public void started()
  {
    try
    {
      // disable the button if the user doesn't have permission to invoke the action
      BSystemPlatformService service = getService();
      if ( service != null )
        setEnabled( canInvokeAction( service, "restartStation" ) );
      else
        setEnabled( false );
    }

    catch (Exception e)
    {
      e.printStackTrace();
      setEnabled( false );
    }
  }
  
  /**
   * Invoke the <code>restartStation</code> action.
   */
  public void doInvokeAction(CommandEvent event)
  {
    if ( getConfirmRequired() == true )
    {
      if ( confirm( lex.getText( "command.reboot.title" ), lex.getText( "command.reboot.message" ) ) == false )
      {
        return;
      }
    }

    BSystemPlatformService service = getService();
    if ( service != null )
    {
      service.restartStation();
      // inform the user that a reboot is in progress
      BDialog.info( getShell(), lex.getText( "command.reboot.saving.message" ) );
    }
  }
  
  private BSystemPlatformService getService()
  {
    BWidgetShell shell = getShell();
    if ( ( shell instanceof BWbShell) == false )
    {
      // don't get the service if we are in the PxEditor
      return( null );
    }
    
    BOrd ord = BOrd.make( ( (BWbShell) shell ).getActiveOrd(), "service:platform:SystemPlatformService" );
    return( ( BSystemPlatformService ) ord.get() );
  }

  static final Lexicon lex = Lexicon.make(BRebootButton.class);
}
