/*
 * Copyright 2016 Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitpx;

import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BValueBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BDegradeBehavior;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.BFormat;

/**
 * BMouseOverBinding
 * 
 * This binding is used to allow animating widgets on mouse enter / mouse exit events for widgets
 * 
 * @author    Danesh Kamal
 * @creation  June 15 2016
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public final class BMouseOverBinding
  extends BValueBinding
{
/*-
  class BMouseOverBinding
  {
    properties
    {      
      ord: BOrd                         
        -- Specifies the ord of the binding target.
        default {[ BOrd.make("local:") ]}
        flags { hidden }
        
      degradeBehavior: BDegradeBehavior  
        -- Specifies the behavior for when the binding
        -- ord cannot be resolved or used due to security
        -- permissions.
        default {[ BDegradeBehavior.none ]}
        flags { hidden }
      
      hyperlink: BOrd          
        -- If this ord is non-null then clicking inside the
        -- bound widget will perform a hyperlink.
        default {[ BOrd.NULL ]}
        flags { hidden }
      
      summary: BFormat          
        -- This property is used to format the summary string
        -- which is displayed in the status bar on mouse over.
        default {[ BFormat.make("%displayName?typeDisplayName% = %.%") ]}
        flags { hidden }
      
      popupEnabled: boolean
        -- If this property is true and this binding is bound
        -- to a component, a popup menu is displayed to invoke
        -- the actions.  If false this feature is disabled.
        default {[ true ]}
        flags { hidden }
    }
    actions
    {
      mouseEvent(event: BMouseEvent)
        -- Fired whenever there's an event on the associated Widget
        default{[ new BMouseEvent() ]}
    }
  }
-*/


/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BMouseOverBinding(1922604822)1.0$ @*/
/* Generated Thu Jun 16 16:47:29 EDT 2016 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "ord"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code ord} property.
   * Specifies the ord of the binding target.
   * @see #getOrd
   * @see #setOrd
   */
  public static final Property ord = newProperty(Flags.HIDDEN, BOrd.make("local:"), null);
  
  /**
   * Get the {@code ord} property.
   * Specifies the ord of the binding target.
   * @see #ord
   */
  public BOrd getOrd() { return (BOrd)get(ord); }
  
  /**
   * Set the {@code ord} property.
   * Specifies the ord of the binding target.
   * @see #ord
   */
  public void setOrd(BOrd v) { set(ord, v, null); }

////////////////////////////////////////////////////////////////
// Property "degradeBehavior"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code degradeBehavior} property.
   * Specifies the behavior for when the binding
   * ord cannot be resolved or used due to security
   * permissions.
   * @see #getDegradeBehavior
   * @see #setDegradeBehavior
   */
  public static final Property degradeBehavior = newProperty(Flags.HIDDEN, BDegradeBehavior.none, null);
  
  /**
   * Get the {@code degradeBehavior} property.
   * Specifies the behavior for when the binding
   * ord cannot be resolved or used due to security
   * permissions.
   * @see #degradeBehavior
   */
  public BDegradeBehavior getDegradeBehavior() { return (BDegradeBehavior)get(degradeBehavior); }
  
  /**
   * Set the {@code degradeBehavior} property.
   * Specifies the behavior for when the binding
   * ord cannot be resolved or used due to security
   * permissions.
   * @see #degradeBehavior
   */
  public void setDegradeBehavior(BDegradeBehavior v) { set(degradeBehavior, v, null); }

////////////////////////////////////////////////////////////////
// Property "hyperlink"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code hyperlink} property.
   * If this ord is non-null then clicking inside the
   * bound widget will perform a hyperlink.
   * @see #getHyperlink
   * @see #setHyperlink
   */
  public static final Property hyperlink = newProperty(Flags.HIDDEN, BOrd.NULL, null);
  
  /**
   * Get the {@code hyperlink} property.
   * If this ord is non-null then clicking inside the
   * bound widget will perform a hyperlink.
   * @see #hyperlink
   */
  public BOrd getHyperlink() { return (BOrd)get(hyperlink); }
  
  /**
   * Set the {@code hyperlink} property.
   * If this ord is non-null then clicking inside the
   * bound widget will perform a hyperlink.
   * @see #hyperlink
   */
  public void setHyperlink(BOrd v) { set(hyperlink, v, null); }

////////////////////////////////////////////////////////////////
// Property "summary"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code summary} property.
   * This property is used to format the summary string
   * which is displayed in the status bar on mouse over.
   * @see #getSummary
   * @see #setSummary
   */
  public static final Property summary = newProperty(Flags.HIDDEN, BFormat.make("%displayName?typeDisplayName% = %.%"), null);
  
  /**
   * Get the {@code summary} property.
   * This property is used to format the summary string
   * which is displayed in the status bar on mouse over.
   * @see #summary
   */
  public BFormat getSummary() { return (BFormat)get(summary); }
  
  /**
   * Set the {@code summary} property.
   * This property is used to format the summary string
   * which is displayed in the status bar on mouse over.
   * @see #summary
   */
  public void setSummary(BFormat v) { set(summary, v, null); }

////////////////////////////////////////////////////////////////
// Property "popupEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code popupEnabled} property.
   * If this property is true and this binding is bound
   * to a component, a popup menu is displayed to invoke
   * the actions.  If false this feature is disabled.
   * @see #getPopupEnabled
   * @see #setPopupEnabled
   */
  public static final Property popupEnabled = newProperty(Flags.HIDDEN, true, null);
  
  /**
   * Get the {@code popupEnabled} property.
   * If this property is true and this binding is bound
   * to a component, a popup menu is displayed to invoke
   * the actions.  If false this feature is disabled.
   * @see #popupEnabled
   */
  public boolean getPopupEnabled() { return getBoolean(popupEnabled); }
  
  /**
   * Set the {@code popupEnabled} property.
   * If this property is true and this binding is bound
   * to a component, a popup menu is displayed to invoke
   * the actions.  If false this feature is disabled.
   * @see #popupEnabled
   */
  public void setPopupEnabled(boolean v) { setBoolean(popupEnabled, v, null); }

////////////////////////////////////////////////////////////////
// Action "mouseEvent"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code mouseEvent} action.
   * Fired whenever there's an event on the associated Widget
   * @see #mouseEvent(BMouseEvent event)
   */
  public static final Action mouseEvent = newAction(0, new BMouseEvent(), null);
  
  /**
   * Invoke the {@code mouseEvent} action.
   * Fired whenever there's an event on the associated Widget
   * @see #mouseEvent
   */
  public void mouseEvent(BMouseEvent event) { invoke(mouseEvent, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMouseOverBinding.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// Component
////////////////////////////////////////////////////////////////

  public void started()
  {
    super.started();
    
    // Issue 15791. Receive mouse events from Widget regardless of whether other 
    // bindings have consumed them
    if (getWidget() != null)
      linkTo(getWidget(), BWidget.mouseEvent, mouseEvent);
  }
  
////////////////////////////////////////////////////////////////
// Mouse Eventing
////////////////////////////////////////////////////////////////

  public void doMouseEvent(BMouseEvent event)
  {
    if (!getWidget().isEnabled())
      return;
        
    switch(event.getId())
    {  
      case BMouseEvent.MOUSE_ENTERED:  entered(event); break;
      case BMouseEvent.MOUSE_EXITED:   exited(event); break;
    } 
  }
  
  private void entered(BMouseEvent event)
  {
    active = true;
    //ensure widget updates by calling targetChanges directly
    targetChanged();
  }
  
  private void exited(BMouseEvent event)
  {
    active = false;
    //ensure widget updates by calling targetChanges directly
    targetChanged();
  }

  @Override
  protected Context getConverterContext()
  {
    return new BasicContext(super.getConverterContext(), BFacets.make("active", active));
  }

  ////////////////////////////////////////////////////////////////
// Fields
////////////////////////////////////////////////////////////////

  private boolean active = false;
}