/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIncrementSetPointBinding is used to increment or decrement 
 * a numeric value when the widgetEvent is fired.
 *
 * @author    Brian Frank       
 * @creation  3 Nov 04
 * @version   $Revision$ $Date: 19-May-04 11:11:24 AM$
 * @since     Baja 1.0
 */
public class BIncrementSetPointBinding
  extends BSetPointBinding
{                                                                             

  public static final Property widgetProperty = newProperty(Flags.HIDDEN, "");
         
  /*-
  
  class BIncrementSetPointBinding
  {
    properties
    {
      increment: double
        -- Value to increment current value; or a negative 
        -- number for a decrement.
        default {[ 0 ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BIncrementSetPointBinding(3116877606)1.0$ @*/
/* Generated Mon Nov 15 13:32:59 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "increment"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>increment</code> property.
   * Value to increment current value; or a negative number
   * for a decrement.
   * @see com.tridium.kitpx.BIncrementSetPointBinding#getIncrement
   * @see com.tridium.kitpx.BIncrementSetPointBinding#setIncrement
   */
  public static final Property increment = newProperty(0, 0,null);
  
  /**
   * Get the <code>increment</code> property.
   * @see com.tridium.kitpx.BIncrementSetPointBinding#increment
   */
  public double getIncrement() { return getDouble(increment); }
  
  /**
   * Set the <code>increment</code> property.
   * @see com.tridium.kitpx.BIncrementSetPointBinding#increment
   */
  public void setIncrement(double v) { setDouble(increment,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BIncrementSetPointBinding.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// SetPointBinding
////////////////////////////////////////////////////////////////
  
  BValue saveWidgetProperty()
  {                      
    if (!isBound()) return null;
    BObject value = get();
    if (!(value instanceof BINumeric)) return null;
    double current = ((BINumeric)value).getNumeric();
    return BDouble.make(current + getIncrement());
  }
            

}
