/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.gx.BColor;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;
import com.tridium.kitpx.enums.BStatusToBrushMode;

/**
 * Convert Status -> Brush using predefined 
 * Status foreground or background
 *
 * @author    Brian Frank
 * @creation  12 May 04
 * @version   $Revision: 4$ $Date: 1-Nov-04 11:59:26 AM$
 * @since     Baja 1.0
 */
public class BIStatusToBrush
  extends BConverter
{                           

  /*-
  
  class BIStatusToBrush
  {
    properties
    {                     
      mode: BStatusToBrushMode
        -- Use predefined foreground or background colors.
        default {[ BStatusToBrushMode.background ]} 
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BIStatusToBrush(1441720377)1.0$ @*/
/* Generated Sat May 14 11:16:08 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "mode"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>mode</code> property.
   * Use predefined foreground or background colors.
   * @see com.tridium.kitpx.BIStatusToBrush#getMode
   * @see com.tridium.kitpx.BIStatusToBrush#setMode
   */
  public static final Property mode = newProperty(0, BStatusToBrushMode.background,null);
  
  /**
   * Get the <code>mode</code> property.
   * @see com.tridium.kitpx.BIStatusToBrush#mode
   */
  public BStatusToBrushMode getMode() { return (BStatusToBrushMode)get(mode); }
  
  /**
   * Set the <code>mode</code> property.
   * @see com.tridium.kitpx.BIStatusToBrush#mode
   */
  public void setMode(BStatusToBrushMode v) { set(mode,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BIStatusToBrush.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Converter
////////////////////////////////////////////////////////////////

  public BObject convert(BObject from, BObject to, Context cx)
  {                     
    BStatus status = ((BIStatus)from).getStatus();            
    
    BColor color;
    if (getMode() == BStatusToBrushMode.foreground)
      color = (BColor)status.getForegroundColor(null);
    else
      color = (BColor)status.getBackgroundColor(null);
    
    if (color != null) return color.toBrush();
    
    return to;
  }                            
  
} 

