/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.Command;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

/**
 * BExportButton automatically integrates with the WbShell's export command.
 *
 * @author    Brian Frank
 * @creation  24 Aug 04
 * @version   $Revision$ $Date: 19-May-04 11:11:24 AM$
 * @since     Baja 1.0
 */
public class BExportButton
  extends BWbCommandButton
{

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BExportButton.class);

  public BExportButton()
  {
    super(label, BImage.make(icon));
  }

  public Command getWbCommand()
  {
    return ((BWbShell)getShell()).getExportCommand();
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("export.png");

  static final String label = UiLexicon.bajaui().getText("commands.export.label");
}
