/*    
 * Copyright 2005 Tridium, Inc.  All rights reserved.
 */
package com.tridium.kitpx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.converters.BObjectToString;
import javax.baja.gx.BSize;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.px.PxEncoder;
import javax.baja.util.BFormat;
import com.tridium.kitpx.enums.BStatusEffect;

/**
 * BComponentToPx creates a PX representation for
 * the properties of a BComponent.
 *
 * @author    Mike Jarmy
 * @creation  12 Dec 06
 * @version   $Revision: 187$ $Date: 11/22/2006 2:32:16 PM$
 * @since     Baja 1.0
 */
public class BComponentToPx
  extends BDynamicPxView
{
  /*-
  class BComponentToPx
  {
    properties
    {
      showLinks: boolean
        -- Whether to display properties of type baja:BLink.
        default {[ false ]}
      showViews: boolean
        -- Whether to display properties of type baja:BAbstractPxView.
        default {[ false ]}
      rowsPerColumn: int
        -- Number of rows in each column.
        default {[ 10 ]}
      columnSpacing: int
        -- Spacing between columns (in pixels).
        default {[ 40 ]}
      widgetHeight: int
        -- Height of each widget (in pixels).
        default {[ 20 ]}
      nameLabelWidth: int
        -- Width of each name label (in pixels).
        default {[ 100 ]}
      nameLabelAlign: BHalign
        -- Horizontal alignment of each name label.
        default {[ BHalign.left ]}
      boundLabelWidth: int
        -- Width of each bound label (in pixels).
        default {[ 150 ]}
      boundLabelAlign: BHalign
        -- Horizontal alignment of each bound label.
        default {[ BHalign.center ]}
      boundLabelTextFormat: String
        -- Text format of each bound label.
        default {[ "%.%" ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BComponentToPx(1767441953)1.0$ @*/
/* Generated Thu Dec 21 10:28:02 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "showLinks"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>showLinks</code> property.
   * Whether to display properties of type baja:BLink.
   * @see com.tridium.kitpx.BComponentToPx#getShowLinks
   * @see com.tridium.kitpx.BComponentToPx#setShowLinks
   */
  public static final Property showLinks = newProperty(0, false,null);
  
  /**
   * Get the <code>showLinks</code> property.
   * @see com.tridium.kitpx.BComponentToPx#showLinks
   */
  public boolean getShowLinks() { return getBoolean(showLinks); }
  
  /**
   * Set the <code>showLinks</code> property.
   * @see com.tridium.kitpx.BComponentToPx#showLinks
   */
  public void setShowLinks(boolean v) { setBoolean(showLinks,v,null); }

////////////////////////////////////////////////////////////////
// Property "showViews"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>showViews</code> property.
   * Whether to display properties of type baja:BAbstractPxView.
   * @see com.tridium.kitpx.BComponentToPx#getShowViews
   * @see com.tridium.kitpx.BComponentToPx#setShowViews
   */
  public static final Property showViews = newProperty(0, false,null);
  
  /**
   * Get the <code>showViews</code> property.
   * @see com.tridium.kitpx.BComponentToPx#showViews
   */
  public boolean getShowViews() { return getBoolean(showViews); }
  
  /**
   * Set the <code>showViews</code> property.
   * @see com.tridium.kitpx.BComponentToPx#showViews
   */
  public void setShowViews(boolean v) { setBoolean(showViews,v,null); }

////////////////////////////////////////////////////////////////
// Property "rowsPerColumn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rowsPerColumn</code> property.
   * Number of rows in each column.
   * @see com.tridium.kitpx.BComponentToPx#getRowsPerColumn
   * @see com.tridium.kitpx.BComponentToPx#setRowsPerColumn
   */
  public static final Property rowsPerColumn = newProperty(0, 10,null);
  
  /**
   * Get the <code>rowsPerColumn</code> property.
   * @see com.tridium.kitpx.BComponentToPx#rowsPerColumn
   */
  public int getRowsPerColumn() { return getInt(rowsPerColumn); }
  
  /**
   * Set the <code>rowsPerColumn</code> property.
   * @see com.tridium.kitpx.BComponentToPx#rowsPerColumn
   */
  public void setRowsPerColumn(int v) { setInt(rowsPerColumn,v,null); }

////////////////////////////////////////////////////////////////
// Property "columnSpacing"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>columnSpacing</code> property.
   * Spacing between columns (in pixels).
   * @see com.tridium.kitpx.BComponentToPx#getColumnSpacing
   * @see com.tridium.kitpx.BComponentToPx#setColumnSpacing
   */
  public static final Property columnSpacing = newProperty(0, 40,null);
  
  /**
   * Get the <code>columnSpacing</code> property.
   * @see com.tridium.kitpx.BComponentToPx#columnSpacing
   */
  public int getColumnSpacing() { return getInt(columnSpacing); }
  
  /**
   * Set the <code>columnSpacing</code> property.
   * @see com.tridium.kitpx.BComponentToPx#columnSpacing
   */
  public void setColumnSpacing(int v) { setInt(columnSpacing,v,null); }

////////////////////////////////////////////////////////////////
// Property "widgetHeight"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>widgetHeight</code> property.
   * Height of each widget (in pixels).
   * @see com.tridium.kitpx.BComponentToPx#getWidgetHeight
   * @see com.tridium.kitpx.BComponentToPx#setWidgetHeight
   */
  public static final Property widgetHeight = newProperty(0, 20,null);
  
  /**
   * Get the <code>widgetHeight</code> property.
   * @see com.tridium.kitpx.BComponentToPx#widgetHeight
   */
  public int getWidgetHeight() { return getInt(widgetHeight); }
  
  /**
   * Set the <code>widgetHeight</code> property.
   * @see com.tridium.kitpx.BComponentToPx#widgetHeight
   */
  public void setWidgetHeight(int v) { setInt(widgetHeight,v,null); }

////////////////////////////////////////////////////////////////
// Property "nameLabelWidth"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nameLabelWidth</code> property.
   * Width of each name label (in pixels).
   * @see com.tridium.kitpx.BComponentToPx#getNameLabelWidth
   * @see com.tridium.kitpx.BComponentToPx#setNameLabelWidth
   */
  public static final Property nameLabelWidth = newProperty(0, 100,null);
  
  /**
   * Get the <code>nameLabelWidth</code> property.
   * @see com.tridium.kitpx.BComponentToPx#nameLabelWidth
   */
  public int getNameLabelWidth() { return getInt(nameLabelWidth); }
  
  /**
   * Set the <code>nameLabelWidth</code> property.
   * @see com.tridium.kitpx.BComponentToPx#nameLabelWidth
   */
  public void setNameLabelWidth(int v) { setInt(nameLabelWidth,v,null); }

////////////////////////////////////////////////////////////////
// Property "nameLabelAlign"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nameLabelAlign</code> property.
   * Horizontal alignment of each name label.
   * @see com.tridium.kitpx.BComponentToPx#getNameLabelAlign
   * @see com.tridium.kitpx.BComponentToPx#setNameLabelAlign
   */
  public static final Property nameLabelAlign = newProperty(0, BHalign.left,null);
  
  /**
   * Get the <code>nameLabelAlign</code> property.
   * @see com.tridium.kitpx.BComponentToPx#nameLabelAlign
   */
  public BHalign getNameLabelAlign() { return (BHalign)get(nameLabelAlign); }
  
  /**
   * Set the <code>nameLabelAlign</code> property.
   * @see com.tridium.kitpx.BComponentToPx#nameLabelAlign
   */
  public void setNameLabelAlign(BHalign v) { set(nameLabelAlign,v,null); }

////////////////////////////////////////////////////////////////
// Property "boundLabelWidth"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>boundLabelWidth</code> property.
   * Width of each bound label (in pixels).
   * @see com.tridium.kitpx.BComponentToPx#getBoundLabelWidth
   * @see com.tridium.kitpx.BComponentToPx#setBoundLabelWidth
   */
  public static final Property boundLabelWidth = newProperty(0, 150,null);
  
  /**
   * Get the <code>boundLabelWidth</code> property.
   * @see com.tridium.kitpx.BComponentToPx#boundLabelWidth
   */
  public int getBoundLabelWidth() { return getInt(boundLabelWidth); }
  
  /**
   * Set the <code>boundLabelWidth</code> property.
   * @see com.tridium.kitpx.BComponentToPx#boundLabelWidth
   */
  public void setBoundLabelWidth(int v) { setInt(boundLabelWidth,v,null); }

////////////////////////////////////////////////////////////////
// Property "boundLabelAlign"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>boundLabelAlign</code> property.
   * Horizontal alignment of each bound label.
   * @see com.tridium.kitpx.BComponentToPx#getBoundLabelAlign
   * @see com.tridium.kitpx.BComponentToPx#setBoundLabelAlign
   */
  public static final Property boundLabelAlign = newProperty(0, BHalign.center,null);
  
  /**
   * Get the <code>boundLabelAlign</code> property.
   * @see com.tridium.kitpx.BComponentToPx#boundLabelAlign
   */
  public BHalign getBoundLabelAlign() { return (BHalign)get(boundLabelAlign); }
  
  /**
   * Set the <code>boundLabelAlign</code> property.
   * @see com.tridium.kitpx.BComponentToPx#boundLabelAlign
   */
  public void setBoundLabelAlign(BHalign v) { set(boundLabelAlign,v,null); }

////////////////////////////////////////////////////////////////
// Property "boundLabelTextFormat"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>boundLabelTextFormat</code> property.
   * Text format of each bound label.
   * @see com.tridium.kitpx.BComponentToPx#getBoundLabelTextFormat
   * @see com.tridium.kitpx.BComponentToPx#setBoundLabelTextFormat
   */
  public static final Property boundLabelTextFormat = newProperty(0, "%.%",null);
  
  /**
   * Get the <code>boundLabelTextFormat</code> property.
   * @see com.tridium.kitpx.BComponentToPx#boundLabelTextFormat
   */
  public String getBoundLabelTextFormat() { return getString(boundLabelTextFormat); }
  
  /**
   * Set the <code>boundLabelTextFormat</code> property.
   * @see com.tridium.kitpx.BComponentToPx#boundLabelTextFormat
   */
  public void setBoundLabelTextFormat(String v) { setString(boundLabelTextFormat,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BComponentToPx.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * generateXml
   */
  @NiagaraRpc(
    transports = @Transport(type = TransportType.fox),
    permissions = "r"
  )
  public String generateXml(Object arg, Context context)
  {
    final boolean showLinks = getShowLinks();
    final boolean showViews = getShowViews();

    int rows    = getRowsPerColumn();
    int spacing = getColumnSpacing();
    int height  = getWidgetHeight();

    int nameWidth  = getNameLabelWidth();
    int boundWidth = getBoundLabelWidth();
    BHalign nameAlign  = getNameLabelAlign();
    BHalign boundAlign = getBoundLabelAlign();

    String  boundText  = getBoundLabelTextFormat();

    // target is Component
    final BComponent comp = (BComponent) getParent();
    BOrd base = comp.getComponentSpace().getAbsoluteOrd();

    // get properties
    comp.lease();
    Property[] props = comp.getPropertiesArray();

    // remove hidden properties, and optionally BLinks and BPxViews
    props = (new Array<>(props)).filter(new IFilter()
    {
      public boolean accept(Object obj) 
      {
        Property p = (Property) obj;
        if (Flags.isHidden(comp, p)) return false;

        BValue v = comp.get(p);
        if (v instanceof BLink) return showLinks;
        if (v instanceof BAbstractPxView) return showViews;
        return true;
      }
    }).trim();

    // scroll
    BScrollPane scroll = new BScrollPane();

    // canvas
    int plen = props.length;
    int pr = plen/rows;
    if ((plen % rows) == 0) pr--;
    int cw = (((pr + 1) * (nameWidth + boundWidth)) + (pr * spacing));
    int ch = ((plen < rows) ? plen : rows) * height + (2 * height);

    BCanvasPane canvas = new BCanvasPane();
    canvas.setViewSize(BSize.make(cw, ch));
    scroll.setContent(canvas);

    // name of component
    BLabel label = new BLabel(comp.getDisplayName(context), nameAlign);
    label.setLayout(BLayout.makeAbs(0, 0, nameWidth, height));
    canvas.add(null, label);

    // properties
    for (int i = 0; i < plen; i++)
    {
      int x = (i / rows) * (nameWidth + boundWidth + spacing);
      int y = (i % rows) * height + (2 * height);

      // label
      label = new BLabel(comp.getDisplayName(props[i], context), nameAlign);
      label.setLayout(BLayout.makeAbs(x, y, nameWidth, height));
      canvas.add(null, label);

      // binding
      BOrd ord = BOrd.make(comp.getNavOrd().relativizeToSession().toString(null) + "|slot:" + props[i].getName()).normalize();

      BObjectToString text = new BObjectToString();
      text.setFormat(BFormat.make(boundText));

      BBoundLabelBinding bnd = new BBoundLabelBinding();
      bnd.setOrd(ord);
      bnd.setHyperlink(ord);
      bnd.setStatusEffect(BStatusEffect.none);
      bnd.add("text", text);

      label = new BBoundLabel();
      label.setHalign(boundAlign);
      label.setLayout(BLayout.makeAbs(x + nameWidth, y, boundWidth, height));
      label.add("binding", bnd);

      canvas.add(null, label);
    }

    // encode
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    try { (new PxEncoder(out)).encodeDocument(scroll); }
    catch (IOException e) { throw new BajaRuntimeException(e); }
    return new String(out.toByteArray());
  }
}
