/*  
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.agent.AgentList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.event.BMouseEvent;
import com.tridium.kitpx.enums.BMouseOverEffect;
import com.tridium.ui.theme.Theme;

/**
 * BBoundLabel.
 *
 * @author    Andy Frank
 * @creation  08 Nov 04
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BBoundLabel
  extends BLabel
{
  /*-
  class BBoundLabel
  {
    properties
    {
      border: BBorder
        -- Border to use.
        default {[ BBorder.none ]}
        
      mouseOver: BMouseOverEffect
        -- The effect to use for mouse overs.
        default {[ BMouseOverEffect.none ]}
        
      padding: BInsets
        -- Padding label bounds and widget bounds.
        default {[ BInsets.DEFAULT ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BBoundLabel(2053958708)1.0$ @*/
/* Generated Tue Nov 09 10:24:20 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "border"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>border</code> property.
   * Border to use.
   * @see com.tridium.kitpx.BBoundLabel#getBorder
   * @see com.tridium.kitpx.BBoundLabel#setBorder
   */
  public static final Property border = newProperty(0, BBorder.none,null);
  
  /**
   * Get the <code>border</code> property.
   * @see com.tridium.kitpx.BBoundLabel#border
   */
  public BBorder getBorder() { return (BBorder)get(border); }
  
  /**
   * Set the <code>border</code> property.
   * @see com.tridium.kitpx.BBoundLabel#border
   */
  public void setBorder(BBorder v) { set(border,v,null); }

////////////////////////////////////////////////////////////////
// Property "mouseOver"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>mouseOver</code> property.
   * The effect to use for mouse overs.
   * @see com.tridium.kitpx.BBoundLabel#getMouseOver
   * @see com.tridium.kitpx.BBoundLabel#setMouseOver
   */
  public static final Property mouseOver = newProperty(0, BMouseOverEffect.none,null);
  
  /**
   * Get the <code>mouseOver</code> property.
   * @see com.tridium.kitpx.BBoundLabel#mouseOver
   */
  public BMouseOverEffect getMouseOver() { return (BMouseOverEffect)get(mouseOver); }
  
  /**
   * Set the <code>mouseOver</code> property.
   * @see com.tridium.kitpx.BBoundLabel#mouseOver
   */
  public void setMouseOver(BMouseOverEffect v) { set(mouseOver,v,null); }

////////////////////////////////////////////////////////////////
// Property "padding"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>padding</code> property.
   * Padding label bounds and widget bounds.
   * @see com.tridium.kitpx.BBoundLabel#getPadding
   * @see com.tridium.kitpx.BBoundLabel#setPadding
   */
  public static final Property padding = newProperty(0, BInsets.DEFAULT,null);
  
  /**
   * Get the <code>padding</code> property.
   * @see com.tridium.kitpx.BBoundLabel#padding
   */
  public BInsets getPadding() { return (BInsets)get(padding); }
  
  /**
   * Set the <code>padding</code> property.
   * @see com.tridium.kitpx.BBoundLabel#padding
   */
  public void setPadding(BInsets v) { set(padding,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBoundLabel.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBoundLabel()
  {
  }
  
////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////
  
  public boolean receiveInputEvents()
  {
    return true;
  }
    
  public void paint(Graphics g)
  {
    super.paint(g);
    
    BBorder border;
    if (isMouseOver && getMouseOver().equals(BMouseOverEffect.outline))
    {
      if(getBorder().isNull() || (getBorder().topWidth==0 && getBorder().leftWidth==0 && getBorder().rightWidth==0 && getBorder().bottomWidth==0))
        border = BBorder.make(1, BBorder.SOLID, Theme.widget().getSelectionBackground());
      else
        border = BBorder.make(getBorder(), Theme.widget().getSelectionBackground());
    } else 
      border = getBorder();
    
    border.paint(g, 1, 1, getWidth()-2, getHeight()-2);
  }

  protected void paintBackground(Graphics g, BBrush background)
  {
    if (isMouseOver && getMouseOver().equals(BMouseOverEffect.highlight))
    {
      g.push();
      g.setBrush(Theme.widget().getSelectionBackground());
      g.fillRect(0,0,getWidth(),getHeight());
      g.pop();
    } else
      super.paintBackground(g, background);
  }  
  
  protected void paintIcon(Graphics g, BImage image, double x, double y)
  {
    if (isMouseOver && getMouseOver().equals(BMouseOverEffect.highlight))
      image = makeImage(image);
    super.paintIcon(g, image, x, y);
  }  

  protected void paintText(Graphics g, String text, double tx, double ty)
  {
    g.push();
    if (isMouseOver && getMouseOver().equals(BMouseOverEffect.highlight))
      g.setBrush(Theme.widget().getSelectionForeground());
    super.paintText(g, text, tx, ty);
    g.pop();
  }
    
////////////////////////////////////////////////////////////////
// Mouse Events
////////////////////////////////////////////////////////////////

  public void mouseEntered(BMouseEvent event)
  { 
    isMouseOver = true;
    repaint();
  }
  
  public void mouseExited(BMouseEvent event)
  { 
    isMouseOver = false;
    repaint();
  }

////////////////////////////////////////////////////////////////
// Agents
////////////////////////////////////////////////////////////////

  public AgentList getAgents(Context cx)
  {
    AgentList agents = super.getAgents(cx);
    agents.toTop("kitPx:BoundLabelBinding");
    return agents;
  }

////////////////////////////////////////////////////////////////
// Composite
////////////////////////////////////////////////////////////////

  private BImage makeImage(BImage orig)
  {
    int w = (int)orig.getWidth();
    int h = (int)orig.getHeight();
    int[] pixels = orig.getPixels();
    
    for (int j=0; j<h; j++)
      for (int i=0; i<w; i++)
      {
        int rgb = pixels[j*w+i];
        int a = 0xff & rgb >> 24;
        int r = 0xff & rgb >> 16;
        int g = 0xff & rgb >> 8;
        int b = 0xff & rgb;
        
        r = r / 2;
        g = g / 2;
        b = b / 2 + 65;
        
        pixels[j*w+i] = (a << 24) | (r << 16) | (g << 8) | b;
      }
      
    if (img == null || img.getWidth() != w || img.getHeight() != h)
      img = BImage.make(w,h);
    img.setPixels(pixels);
    return img;
  }  
  private BImage img;
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private boolean isMouseOver = false;
}
