/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.util.Lexicon;

/**
 * BBargraph
 *
 * @author    Brian Frank
 * @creation  26 Dec 01
 * @version   $Revision$ $Date: 5/13/2004 6:38:08 PM$
 * @since     Niagara 3.0
 */
public class BBargraph
  extends BWidget
{   
  /*-
  class BBargraph
  {
    properties
    {
      value: double
        -- The current value for the graph.
        default {[ 0 ]}        
      min: double
        -- The minimum value to display on the graph.
        default {[ 0 ]}
      max: double
        -- The maximum value to display on the graph.
        default {[ 100 ]}
      text: String
        -- The text value used to display current value.
        default {[ "" ]}
      
      valueVisible: boolean
        -- Toggle the visibility of the current value on the graph.
        default {[ true ]}
      valueFont: BFont
        -- The font used to render the current value.
        default {[ BFont.NULL ]}      
        
      fill: BBrush
        -- Brush used to fill the current value
        -- of the graph.
        default {[ BColor.make(0x666699).toBrush() ]}
      foreground: BBrush
        -- Brush used for outline and text of graph.
        default {[ BColor.black.toBrush() ]}
      background: BBrush
        -- Brush used to fill the background of the graph.
        default {[ BBrush.NULL ]}  
        
      orientation: BOrientation
        -- Orientation defines whether the graph is horizonal or vertical.
        default {[ BOrientation.vertical ]}      
      
      scale: double
        -- The increment to use for scale divisions.
        -- Auto-scaling will occur if this value is set to "0".
        default {[ 10 ]}
      scaleFont: BFont
        -- Font used to render major scale values.
        default {[ BFont.NULL ]}  
      scaleVisible: boolean
        -- Is the scale displayed.
        default {[ true ]}      
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BBargraph(2545760070)1.0$ @*/
/* Generated Tue Jul 28 12:22:27 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * The current value for the graph.
   * @see com.tridium.kitpx.BBargraph#getValue
   * @see com.tridium.kitpx.BBargraph#setValue
   */
  public static final Property value = newProperty(0, 0,null);
  
  /**
   * Get the <code>value</code> property.
   * @see com.tridium.kitpx.BBargraph#value
   */
  public double getValue() { return getDouble(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see com.tridium.kitpx.BBargraph#value
   */
  public void setValue(double v) { setDouble(value,v,null); }

////////////////////////////////////////////////////////////////
// Property "min"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>min</code> property.
   * The minimum value to display on the graph.
   * @see com.tridium.kitpx.BBargraph#getMin
   * @see com.tridium.kitpx.BBargraph#setMin
   */
  public static final Property min = newProperty(0, 0,null);
  
  /**
   * Get the <code>min</code> property.
   * @see com.tridium.kitpx.BBargraph#min
   */
  public double getMin() { return getDouble(min); }
  
  /**
   * Set the <code>min</code> property.
   * @see com.tridium.kitpx.BBargraph#min
   */
  public void setMin(double v) { setDouble(min,v,null); }

////////////////////////////////////////////////////////////////
// Property "max"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>max</code> property.
   * The maximum value to display on the graph.
   * @see com.tridium.kitpx.BBargraph#getMax
   * @see com.tridium.kitpx.BBargraph#setMax
   */
  public static final Property max = newProperty(0, 100,null);
  
  /**
   * Get the <code>max</code> property.
   * @see com.tridium.kitpx.BBargraph#max
   */
  public double getMax() { return getDouble(max); }
  
  /**
   * Set the <code>max</code> property.
   * @see com.tridium.kitpx.BBargraph#max
   */
  public void setMax(double v) { setDouble(max,v,null); }

////////////////////////////////////////////////////////////////
// Property "text"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>text</code> property.
   * The text value used to display current value.
   * @see com.tridium.kitpx.BBargraph#getText
   * @see com.tridium.kitpx.BBargraph#setText
   */
  public static final Property text = newProperty(0, "",null);
  
  /**
   * Get the <code>text</code> property.
   * @see com.tridium.kitpx.BBargraph#text
   */
  public String getText() { return getString(text); }
  
  /**
   * Set the <code>text</code> property.
   * @see com.tridium.kitpx.BBargraph#text
   */
  public void setText(String v) { setString(text,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueVisible"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueVisible</code> property.
   * Toggle the visibility of the current value on the graph.
   * @see com.tridium.kitpx.BBargraph#getValueVisible
   * @see com.tridium.kitpx.BBargraph#setValueVisible
   */
  public static final Property valueVisible = newProperty(0, true,null);
  
  /**
   * Get the <code>valueVisible</code> property.
   * @see com.tridium.kitpx.BBargraph#valueVisible
   */
  public boolean getValueVisible() { return getBoolean(valueVisible); }
  
  /**
   * Set the <code>valueVisible</code> property.
   * @see com.tridium.kitpx.BBargraph#valueVisible
   */
  public void setValueVisible(boolean v) { setBoolean(valueVisible,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueFont"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueFont</code> property.
   * The font used to render the current value.
   * @see com.tridium.kitpx.BBargraph#getValueFont
   * @see com.tridium.kitpx.BBargraph#setValueFont
   */
  public static final Property valueFont = newProperty(0, BFont.NULL,null);
  
  /**
   * Get the <code>valueFont</code> property.
   * @see com.tridium.kitpx.BBargraph#valueFont
   */
  public BFont getValueFont() { return (BFont)get(valueFont); }
  
  /**
   * Set the <code>valueFont</code> property.
   * @see com.tridium.kitpx.BBargraph#valueFont
   */
  public void setValueFont(BFont v) { set(valueFont,v,null); }

////////////////////////////////////////////////////////////////
// Property "fill"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fill</code> property.
   * Brush used to fill the current value of the graph.
   * @see com.tridium.kitpx.BBargraph#getFill
   * @see com.tridium.kitpx.BBargraph#setFill
   */
  public static final Property fill = newProperty(0, BColor.make(0x666699).toBrush(),null);
  
  /**
   * Get the <code>fill</code> property.
   * @see com.tridium.kitpx.BBargraph#fill
   */
  public BBrush getFill() { return (BBrush)get(fill); }
  
  /**
   * Set the <code>fill</code> property.
   * @see com.tridium.kitpx.BBargraph#fill
   */
  public void setFill(BBrush v) { set(fill,v,null); }

////////////////////////////////////////////////////////////////
// Property "foreground"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>foreground</code> property.
   * Brush used for outline and text of graph.
   * @see com.tridium.kitpx.BBargraph#getForeground
   * @see com.tridium.kitpx.BBargraph#setForeground
   */
  public static final Property foreground = newProperty(0, BColor.black.toBrush(),null);
  
  /**
   * Get the <code>foreground</code> property.
   * @see com.tridium.kitpx.BBargraph#foreground
   */
  public BBrush getForeground() { return (BBrush)get(foreground); }
  
  /**
   * Set the <code>foreground</code> property.
   * @see com.tridium.kitpx.BBargraph#foreground
   */
  public void setForeground(BBrush v) { set(foreground,v,null); }

////////////////////////////////////////////////////////////////
// Property "background"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>background</code> property.
   * Brush used to fill the background of the graph.
   * @see com.tridium.kitpx.BBargraph#getBackground
   * @see com.tridium.kitpx.BBargraph#setBackground
   */
  public static final Property background = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>background</code> property.
   * @see com.tridium.kitpx.BBargraph#background
   */
  public BBrush getBackground() { return (BBrush)get(background); }
  
  /**
   * Set the <code>background</code> property.
   * @see com.tridium.kitpx.BBargraph#background
   */
  public void setBackground(BBrush v) { set(background,v,null); }

////////////////////////////////////////////////////////////////
// Property "orientation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>orientation</code> property.
   * Orientation defines whether the graph is horizonal
   * or vertical.
   * @see com.tridium.kitpx.BBargraph#getOrientation
   * @see com.tridium.kitpx.BBargraph#setOrientation
   */
  public static final Property orientation = newProperty(0, BOrientation.vertical,null);
  
  /**
   * Get the <code>orientation</code> property.
   * @see com.tridium.kitpx.BBargraph#orientation
   */
  public BOrientation getOrientation() { return (BOrientation)get(orientation); }
  
  /**
   * Set the <code>orientation</code> property.
   * @see com.tridium.kitpx.BBargraph#orientation
   */
  public void setOrientation(BOrientation v) { set(orientation,v,null); }

////////////////////////////////////////////////////////////////
// Property "scale"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scale</code> property.
   * The increment to use for scale divisions. Auto-scaling
   * will occur if this value is set to "0".
   * @see com.tridium.kitpx.BBargraph#getScale
   * @see com.tridium.kitpx.BBargraph#setScale
   */
  public static final Property scale = newProperty(0, 10,null);
  
  /**
   * Get the <code>scale</code> property.
   * @see com.tridium.kitpx.BBargraph#scale
   */
  public double getScale() { return getDouble(scale); }
  
  /**
   * Set the <code>scale</code> property.
   * @see com.tridium.kitpx.BBargraph#scale
   */
  public void setScale(double v) { setDouble(scale,v,null); }

////////////////////////////////////////////////////////////////
// Property "scaleFont"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scaleFont</code> property.
   * Font used to render major scale values.
   * @see com.tridium.kitpx.BBargraph#getScaleFont
   * @see com.tridium.kitpx.BBargraph#setScaleFont
   */
  public static final Property scaleFont = newProperty(0, BFont.NULL,null);
  
  /**
   * Get the <code>scaleFont</code> property.
   * @see com.tridium.kitpx.BBargraph#scaleFont
   */
  public BFont getScaleFont() { return (BFont)get(scaleFont); }
  
  /**
   * Set the <code>scaleFont</code> property.
   * @see com.tridium.kitpx.BBargraph#scaleFont
   */
  public void setScaleFont(BFont v) { set(scaleFont,v,null); }

////////////////////////////////////////////////////////////////
// Property "scaleVisible"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scaleVisible</code> property.
   * Is the scale displayed.
   * @see com.tridium.kitpx.BBargraph#getScaleVisible
   * @see com.tridium.kitpx.BBargraph#setScaleVisible
   */
  public static final Property scaleVisible = newProperty(0, true,null);
  
  /**
   * Get the <code>scaleVisible</code> property.
   * @see com.tridium.kitpx.BBargraph#scaleVisible
   */
  public boolean getScaleVisible() { return getBoolean(scaleVisible); }
  
  /**
   * Set the <code>scaleVisible</code> property.
   * @see com.tridium.kitpx.BBargraph#scaleVisible
   */
  public void setScaleVisible(boolean v) { setBoolean(scaleVisible,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBargraph.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constuctor
////////////////////////////////////////////////////////////////

  public BBargraph()
  {
  }

////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////

  public void paint(Graphics g)
  {
    double w = getWidth();
    double h = getHeight();
        
    BBrush bg = getBackground();
    if (!bg.isNull())
    {
      g.setBrush(bg);
      g.fillRect(0,0,w,h);
    }
    
    if (getOrientation() == BOrientation.horizontal)
      paintHoriz(g);
    else
      paintVert(g);
      
    BBrush fg = getForeground();
    if (!fg.isNull())
    {
      g.setBrush(fg);
      g.strokeRect(0,0,w-1,h-1);
    }    
  }

////////////////////////////////////////////////////////////////
// Horizontal
////////////////////////////////////////////////////////////////
  
  private void paintHoriz(Graphics g) {
    double w = getWidth();
    double h = getHeight();
    double v = getValue();
    double min = getMin();
    double max = getMax();
    
    if (max <= min) return ;
    if (v < min) v = min;
    if (v > max) v = max;
    
    double x = ((v-min) / (max-min)) * w;
    g.setBrush(getFill());
    g.fillRect(0, 0, x, h);
    
    if (getValueVisible()) {
      String s = getText();
      BFont font = getValueFont();
      if (font.isNull()) font = defValueFont;
      
      double tx = x - font.width(s) - 3;
      double ty = (h - font.getAscent()) / 2 + font.getAscent();
      if (tx < 2) tx = x + 3;
      
      g.setBrush(getForeground());
      g.setFont(font);
      g.drawString(s, tx, ty);
    }
    
    double scale = getScale();
    if( scale == 0.0 ) {
      scale = calcAutoScale( min, max );
    }
    
    if (getScaleVisible() && (scale > 0.0)) {
      double num = (max-min) / scale;
      double space = w / num;
      long roundMultiplier = 10;
      
      BFont font = getScaleFont();
      if (font.isNull()) font = defScaleFont;
      
      g.setBrush(getForeground());
      g.setFont(font);
      
      roundMultiplier = calcRoundMultiplier(scale);
      for (int i=0; i<num; i++) {
        double dx = i * space;
        g.strokeLine(dx, h-5, dx, h);
        
        if (i>0 && i<num) {
          String s = "" + (double)((long)(((i*scale)+min)*roundMultiplier))/roundMultiplier;
          if(s.endsWith(".0"))
            s = s.substring(0, s.length()-2);
          double tx = dx - (font.width(s) / 2);
          double ty = h - 8;
          g.drawString(s, tx, ty);
        }
        
      }
    }
  }
  
////////////////////////////////////////////////////////////////
// Vertical
////////////////////////////////////////////////////////////////
  
  private void paintVert(Graphics g) {
    double w = getWidth();
    double h = getHeight();
    double v = getValue();
    double min = getMin();
    double max = getMax();
    
    if(max <= min) return ;
    if (v < min) v = min;
    if (v > max) v = max;
    
    double y = h - ((v-min) / (max-min)) * h;
    g.setBrush(getFill());
    g.fillRect(0, y, w, h-y);
    
    if (getValueVisible()) {
      String s = getText();
      BFont font = getValueFont();
      if (font.isNull()) font = defValueFont;
      
      double tx = (w - font.width(s)) / 2;
      double ty = y + font.getAscent() + 3;
      if (ty > (h-2)) ty = y - 4;
      
      g.setBrush(getForeground());
      g.setFont(font);
      g.drawString(s, tx, ty);
    }
    
    double scale = getScale();
    if(scale == 0.0) {
      scale = calcAutoScale(min,max);
    }
    
    if (getScaleVisible() && (scale > 0.0)) {
      double num = (max-min) / scale;
      double space = h / num;
      long roundMultiplier = 10;
      
      BFont font = getScaleFont();
      if (font.isNull()) font = defScaleFont;
      
      g.setBrush(getForeground());
      g.setFont(font);
      
      roundMultiplier = calcRoundMultiplier(scale);
      for (int i=0; i<num; i++) {
        double dy = i * space;
        g.strokeLine(w-5, dy, w, dy);
        
        if (i>0 && i<num) {
          String s = "" + (double)((long)((((num-i)*scale)+min)*roundMultiplier))/roundMultiplier;
          if(s.endsWith(".0"))
            s = s.substring(0, s.length()-2);
          double tx = w - font.width(s) - 8;
          double ty = dy + (font.getAscent() / 2)-1;
          g.drawString(s, tx, ty);
        }
      }
    }
  }
  
  /**
   * there are two cases to handle -
   * 1) delta > 1.0
   * 2) delta <= 1.0
   *
   * In both cases we attempt to squeeze to a range of [MIN_TICKS, MAX_TICKS],
   * but ultimately it is more important to have less than MAX_TICKS than
   * to ensure we have more than MIN_TICKS
   *
   * DETAILS: tickCount is guaranteed to be no more than 10, hence we only
   * have to check if tickCount is less than our arbitrarily chosen
   * value of MIN_TICKS.  However, in the case we need to adjust the
   * tickIncrement because (tickCount < MIN_TICKS), it is possible that we
   * may overshoot MAX_TICKS during the correction;  hence the need to 
   * "squeeze".
   *
   */
  private double calcAutoScale(double min, double max) {
    final int MIN_TICKS = 4;
    final int MAX_TICKS= 10;
    
    double delta = max - min;
    double log10 = Math.log(delta) * LOG10E;
    
    double tickIncrement = Math.max(
            (float)Math.pow(10,(long)log10), Float.MIN_VALUE );
    int tickCount = (int)(delta / tickIncrement);
    
    // at the completion of this block of code we are guaranteed
    // that (tickCount < MAX_TICKS) -- which is the primary goal.
    if( delta >  1.0 ) {
      if( tickCount < MIN_TICKS ) {
        tickIncrement /= 10.0;
        while(tickCount < MIN_TICKS) {
          tickIncrement *= 2;
          tickCount = (int)( delta / tickIncrement ) + 1;
        }
        // squeeze
        while(tickCount > MAX_TICKS) {
          tickIncrement *= 2;
          tickCount = (int)( delta / tickIncrement ) + 1;
        }
      }
    } else { // <= 1.0
      if( tickCount < MIN_TICKS ) {
        tickIncrement /= 10.0;
        while( tickCount < MIN_TICKS ) {
          tickIncrement /= 2;
          tickCount = (int)( delta / tickIncrement ) + 1;
        }
        // squeeze
        while(tickCount > MAX_TICKS) {
          tickIncrement *= 2;
          tickCount = (int)( delta / tickIncrement ) + 1;
        }
      }
    }
    
    return tickIncrement;
  }
  
  /**
   * returns a power of 10 that can be used to do reasonable
   * roudning of decimal numbers when printing the ticks
   * on the bargraph.
   */
  private long calcRoundMultiplier(double scale) {
    long multiplier = 10;
    if(scale < 1.0) {
      while( (int)scale < 1.0 ) {
        scale /= 0.1;
        multiplier *= 10;
      }
    }
    return multiplier;
  }
  
////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////
  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("charts/bar.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

	private static final double LOG10E = 0.4342944819018;
	
  static Lexicon lex = Lexicon.make("kitPx");
  static BFont defValueFont = BFont.make(lex.getText("bargraph.value.font"));
  static BFont defScaleFont = BFont.make(lex.getText("bargraph.scale.font"));
}



