/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitpx;

import javax.baja.converters.BNumericToSimpleMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.EllipseGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

/**
 * BAnalogMeter displays a analog meter.
 *
 * @author    Andy Frank
 * @creation  27 Oct 03
 * @version   $Revision$ $Date: 5/13/2004 6:38:04 PM$
 * @since     Niagara 3.0
 */
public class BAnalogMeter
  extends BWidget
{   
  /*-
  class BAnalogMeter
  {
    properties
    {
      value: double
        -- The current value to display
        default {[ 0 ]}
      text: String
        -- The text used to display the current value.
        default {[ "" ]}
        
      startAngle: int
        -- The start angle for the meter.
        default {[ 240 ]}
      arcAngle: int
        -- The angle the extend the meter clockwise from startAngle.
        default {[ 300 ]}
      
      min: double
        -- The min value for the meter.
        default {[ 0 ]}
      max: double
        -- The max value for the meter.
        default {[ 100 ]}
      
      numDivisions: int
        -- The number of major divisions.
        default {[ 10 ]}
      numSubDivisions: int
        -- The number of minor divisions.
        default {[ 5 ]}
      showSubDivisions: boolean
        -- Are subdivisions displayed.
        default {[ true ]}
      
      valueVisible: boolean
        -- Is the current value displayed as a label.
        default {[ true ]}
      valueFont: BFont
        -- The font used to render the value.
        default {[ BFont.NULL ]}  
        
      scaleVisible: boolean
        -- Is the scale visible on the meter.
        default {[ true ]}
      scaleFont: BFont
        -- The font used to render the scale.
        default {[ BFont.NULL ]}
      
      needlePen: BPen
        -- The pen to be used when rendering the needle.
        default {[ BPen.DEFAULT ]}
      needleBrush: BBrush
        -- The color used to render the needle.
        default {[ BColor.red.toBrush() ]}
      background: BBrush
        -- The brush used to render the background.  
        default {[ BColor.make(0xcccccc).toBrush() ]}
      foreground: BBrush
        -- The brush used to render the foreground.
        default {[ BColor.black.toBrush() ]}
      
      fillCircle: boolean
        -- If true the entire circle is filled in regardless what
        -- the startAngle and arcAngle are.
        default  {[ true ]}  
        
      ranges: BNumericToSimpleMap
        -- Defines color ranges based on a set of ranges. (unimplemented)
        default {[ BNumericToSimpleMap.NULL ]}
        flags { hidden }
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitpx.BAnalogMeter(1219002400)1.0$ @*/
/* Generated Wed Mar 02 13:46:31 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * The current value to display
   * @see com.tridium.kitpx.BAnalogMeter#getValue
   * @see com.tridium.kitpx.BAnalogMeter#setValue
   */
  public static final Property value = newProperty(0, 0,null);
  
  /**
   * Get the <code>value</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#value
   */
  public double getValue() { return getDouble(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#value
   */
  public void setValue(double v) { setDouble(value,v,null); }

////////////////////////////////////////////////////////////////
// Property "text"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>text</code> property.
   * The text used to display the current value.
   * @see com.tridium.kitpx.BAnalogMeter#getText
   * @see com.tridium.kitpx.BAnalogMeter#setText
   */
  public static final Property text = newProperty(0, "",null);
  
  /**
   * Get the <code>text</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#text
   */
  public String getText() { return getString(text); }
  
  /**
   * Set the <code>text</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#text
   */
  public void setText(String v) { setString(text,v,null); }

////////////////////////////////////////////////////////////////
// Property "startAngle"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>startAngle</code> property.
   * The start angle for the meter.
   * @see com.tridium.kitpx.BAnalogMeter#getStartAngle
   * @see com.tridium.kitpx.BAnalogMeter#setStartAngle
   */
  public static final Property startAngle = newProperty(0, 240,null);
  
  /**
   * Get the <code>startAngle</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#startAngle
   */
  public int getStartAngle() { return getInt(startAngle); }
  
  /**
   * Set the <code>startAngle</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#startAngle
   */
  public void setStartAngle(int v) { setInt(startAngle,v,null); }

////////////////////////////////////////////////////////////////
// Property "arcAngle"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>arcAngle</code> property.
   * The angle the extend the meter clockwise from startAngle.
   * @see com.tridium.kitpx.BAnalogMeter#getArcAngle
   * @see com.tridium.kitpx.BAnalogMeter#setArcAngle
   */
  public static final Property arcAngle = newProperty(0, 300,null);
  
  /**
   * Get the <code>arcAngle</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#arcAngle
   */
  public int getArcAngle() { return getInt(arcAngle); }
  
  /**
   * Set the <code>arcAngle</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#arcAngle
   */
  public void setArcAngle(int v) { setInt(arcAngle,v,null); }

////////////////////////////////////////////////////////////////
// Property "min"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>min</code> property.
   * The min value for the meter.
   * @see com.tridium.kitpx.BAnalogMeter#getMin
   * @see com.tridium.kitpx.BAnalogMeter#setMin
   */
  public static final Property min = newProperty(0, 0,null);
  
  /**
   * Get the <code>min</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#min
   */
  public double getMin() { return getDouble(min); }
  
  /**
   * Set the <code>min</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#min
   */
  public void setMin(double v) { setDouble(min,v,null); }

////////////////////////////////////////////////////////////////
// Property "max"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>max</code> property.
   * The max value for the meter.
   * @see com.tridium.kitpx.BAnalogMeter#getMax
   * @see com.tridium.kitpx.BAnalogMeter#setMax
   */
  public static final Property max = newProperty(0, 100,null);
  
  /**
   * Get the <code>max</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#max
   */
  public double getMax() { return getDouble(max); }
  
  /**
   * Set the <code>max</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#max
   */
  public void setMax(double v) { setDouble(max,v,null); }

////////////////////////////////////////////////////////////////
// Property "numDivisions"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numDivisions</code> property.
   * The number of major divisions.
   * @see com.tridium.kitpx.BAnalogMeter#getNumDivisions
   * @see com.tridium.kitpx.BAnalogMeter#setNumDivisions
   */
  public static final Property numDivisions = newProperty(0, 10,null);
  
  /**
   * Get the <code>numDivisions</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#numDivisions
   */
  public int getNumDivisions() { return getInt(numDivisions); }
  
  /**
   * Set the <code>numDivisions</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#numDivisions
   */
  public void setNumDivisions(int v) { setInt(numDivisions,v,null); }

////////////////////////////////////////////////////////////////
// Property "numSubDivisions"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numSubDivisions</code> property.
   * The number of minor divisions.
   * @see com.tridium.kitpx.BAnalogMeter#getNumSubDivisions
   * @see com.tridium.kitpx.BAnalogMeter#setNumSubDivisions
   */
  public static final Property numSubDivisions = newProperty(0, 5,null);
  
  /**
   * Get the <code>numSubDivisions</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#numSubDivisions
   */
  public int getNumSubDivisions() { return getInt(numSubDivisions); }
  
  /**
   * Set the <code>numSubDivisions</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#numSubDivisions
   */
  public void setNumSubDivisions(int v) { setInt(numSubDivisions,v,null); }

////////////////////////////////////////////////////////////////
// Property "showSubDivisions"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>showSubDivisions</code> property.
   * Are subdivisions displayed.
   * @see com.tridium.kitpx.BAnalogMeter#getShowSubDivisions
   * @see com.tridium.kitpx.BAnalogMeter#setShowSubDivisions
   */
  public static final Property showSubDivisions = newProperty(0, true,null);
  
  /**
   * Get the <code>showSubDivisions</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#showSubDivisions
   */
  public boolean getShowSubDivisions() { return getBoolean(showSubDivisions); }
  
  /**
   * Set the <code>showSubDivisions</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#showSubDivisions
   */
  public void setShowSubDivisions(boolean v) { setBoolean(showSubDivisions,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueVisible"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueVisible</code> property.
   * Is the current value displayed as a label.
   * @see com.tridium.kitpx.BAnalogMeter#getValueVisible
   * @see com.tridium.kitpx.BAnalogMeter#setValueVisible
   */
  public static final Property valueVisible = newProperty(0, true,null);
  
  /**
   * Get the <code>valueVisible</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#valueVisible
   */
  public boolean getValueVisible() { return getBoolean(valueVisible); }
  
  /**
   * Set the <code>valueVisible</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#valueVisible
   */
  public void setValueVisible(boolean v) { setBoolean(valueVisible,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueFont"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueFont</code> property.
   * The font used to render the value.
   * @see com.tridium.kitpx.BAnalogMeter#getValueFont
   * @see com.tridium.kitpx.BAnalogMeter#setValueFont
   */
  public static final Property valueFont = newProperty(0, BFont.NULL,null);
  
  /**
   * Get the <code>valueFont</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#valueFont
   */
  public BFont getValueFont() { return (BFont)get(valueFont); }
  
  /**
   * Set the <code>valueFont</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#valueFont
   */
  public void setValueFont(BFont v) { set(valueFont,v,null); }

////////////////////////////////////////////////////////////////
// Property "scaleVisible"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scaleVisible</code> property.
   * Is the scale visible on the meter.
   * @see com.tridium.kitpx.BAnalogMeter#getScaleVisible
   * @see com.tridium.kitpx.BAnalogMeter#setScaleVisible
   */
  public static final Property scaleVisible = newProperty(0, true,null);
  
  /**
   * Get the <code>scaleVisible</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#scaleVisible
   */
  public boolean getScaleVisible() { return getBoolean(scaleVisible); }
  
  /**
   * Set the <code>scaleVisible</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#scaleVisible
   */
  public void setScaleVisible(boolean v) { setBoolean(scaleVisible,v,null); }

////////////////////////////////////////////////////////////////
// Property "scaleFont"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scaleFont</code> property.
   * The font used to render the scale.
   * @see com.tridium.kitpx.BAnalogMeter#getScaleFont
   * @see com.tridium.kitpx.BAnalogMeter#setScaleFont
   */
  public static final Property scaleFont = newProperty(0, BFont.NULL,null);
  
  /**
   * Get the <code>scaleFont</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#scaleFont
   */
  public BFont getScaleFont() { return (BFont)get(scaleFont); }
  
  /**
   * Set the <code>scaleFont</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#scaleFont
   */
  public void setScaleFont(BFont v) { set(scaleFont,v,null); }

////////////////////////////////////////////////////////////////
// Property "needlePen"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>needlePen</code> property.
   * The pen to be used when rendering the needle.
   * @see com.tridium.kitpx.BAnalogMeter#getNeedlePen
   * @see com.tridium.kitpx.BAnalogMeter#setNeedlePen
   */
  public static final Property needlePen = newProperty(0, BPen.DEFAULT,null);
  
  /**
   * Get the <code>needlePen</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#needlePen
   */
  public BPen getNeedlePen() { return (BPen)get(needlePen); }
  
  /**
   * Set the <code>needlePen</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#needlePen
   */
  public void setNeedlePen(BPen v) { set(needlePen,v,null); }

////////////////////////////////////////////////////////////////
// Property "needleBrush"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>needleBrush</code> property.
   * The color used to render the needle.
   * @see com.tridium.kitpx.BAnalogMeter#getNeedleBrush
   * @see com.tridium.kitpx.BAnalogMeter#setNeedleBrush
   */
  public static final Property needleBrush = newProperty(0, BColor.red.toBrush(),null);
  
  /**
   * Get the <code>needleBrush</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#needleBrush
   */
  public BBrush getNeedleBrush() { return (BBrush)get(needleBrush); }
  
  /**
   * Set the <code>needleBrush</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#needleBrush
   */
  public void setNeedleBrush(BBrush v) { set(needleBrush,v,null); }

////////////////////////////////////////////////////////////////
// Property "background"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>background</code> property.
   * The brush used to render the background.
   * @see com.tridium.kitpx.BAnalogMeter#getBackground
   * @see com.tridium.kitpx.BAnalogMeter#setBackground
   */
  public static final Property background = newProperty(0, BColor.make(0xcccccc).toBrush(),null);
  
  /**
   * Get the <code>background</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#background
   */
  public BBrush getBackground() { return (BBrush)get(background); }
  
  /**
   * Set the <code>background</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#background
   */
  public void setBackground(BBrush v) { set(background,v,null); }

////////////////////////////////////////////////////////////////
// Property "foreground"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>foreground</code> property.
   * The brush used to render the foreground.
   * @see com.tridium.kitpx.BAnalogMeter#getForeground
   * @see com.tridium.kitpx.BAnalogMeter#setForeground
   */
  public static final Property foreground = newProperty(0, BColor.black.toBrush(),null);
  
  /**
   * Get the <code>foreground</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#foreground
   */
  public BBrush getForeground() { return (BBrush)get(foreground); }
  
  /**
   * Set the <code>foreground</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#foreground
   */
  public void setForeground(BBrush v) { set(foreground,v,null); }

////////////////////////////////////////////////////////////////
// Property "fillCircle"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fillCircle</code> property.
   * If true the entire circle is filled in regardless what the startAngle and arcAngle are.
   * @see com.tridium.kitpx.BAnalogMeter#getFillCircle
   * @see com.tridium.kitpx.BAnalogMeter#setFillCircle
   */
  public static final Property fillCircle = newProperty(0, true,null);
  
  /**
   * Get the <code>fillCircle</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#fillCircle
   */
  public boolean getFillCircle() { return getBoolean(fillCircle); }
  
  /**
   * Set the <code>fillCircle</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#fillCircle
   */
  public void setFillCircle(boolean v) { setBoolean(fillCircle,v,null); }

////////////////////////////////////////////////////////////////
// Property "ranges"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ranges</code> property.
   * Defines color ranges based on a set of ranges. (unimplemented)
   * @see com.tridium.kitpx.BAnalogMeter#getRanges
   * @see com.tridium.kitpx.BAnalogMeter#setRanges
   */
  public static final Property ranges = newProperty(Flags.HIDDEN, BNumericToSimpleMap.NULL,null);
  
  /**
   * Get the <code>ranges</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#ranges
   */
  public BNumericToSimpleMap getRanges() { return (BNumericToSimpleMap)get(ranges); }
  
  /**
   * Set the <code>ranges</code> property.
   * @see com.tridium.kitpx.BAnalogMeter#ranges
   */
  public void setRanges(BNumericToSimpleMap v) { set(ranges,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAnalogMeter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
//////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BAnalogMeter()
  {
  }
  
////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////
  
  public void computePreferredSize()
  {
    setPreferredSize(100,100);
  }
  
  public void doLayout(BWidget[] kids)
  {
    double w = getWidth();
    double h = getHeight();
    
    if (getStartAngle() <= 180 && getArcAngle() <= 180 && !getFillCircle())
    {
      double temp = h * 2;
      size = Math.min(w-1, temp-1);
      
      BFont vfont = getValueFont();
      if (vfont.isNull()) vfont = defValueFont;

      BFont sfont = getScaleFont();
      if (sfont.isNull()) sfont = defScaleFont;
      
      double diff = 0;
      if (getValueVisible()) diff = vfont.getHeight() + vfont.getDescent();
      else if (getScaleVisible()) diff = sfont.getHeight();
      //size -= (diff * 2);

      if (size / 2 + diff >= h) size = (h - diff - 1) * 2;
      
      px = (w - size) / 2;
      py = (temp - size) / 2 - diff;
      cx = px + (size / 2);
      cy = py + (size / 2);
    }
    else
    {
      size = Math.min(w-1, h-1);
      px = (w - size) / 2;
      py = (h - size) / 2;
      cx = px + (size / 2);
      cy = py + (size / 2);
    }
  
    radius = size / 2d;
    
    if (getFillCircle()) geom = new EllipseGeom(px,py,size,size);
    else
    {
//      PathGeom path = new PathGeom();
//      path.moveTo(true,cx,cy);
//      path.lineTo(false,-10,20);
//      path.arcTo(false, 30,30,0,true,true,20,0);
//      geom = path;      
      geom = null;
    } 
  }

  public void paint(Graphics g)
  {
    double value = getValue();
    double sa = getStartAngle();
    double aa = getArcAngle();
    double mn = getMin();
    double mx = getMax();

    BFont vfont = getValueFont();
    if (vfont.isNull()) vfont = defValueFont;

    BFont sfont = getScaleFont();
    if (sfont.isNull()) sfont = defScaleFont;
    
    //
    // Meter Face
    //
    if (!getBackground().isNull())
    {
      g.setBrush(getBackground());
      if (geom != null) g.fill(geom);
      //g._fillArc(px,py,size,size,startAngle,-(fillCircle ? 360 : arcAngle));
  
//      for(int i=0; i<states.size(); ++i)
//      {
//        FloatState state = (FloatState)states.get(i);
//        if (state.bg.isNull()) continue;
//        g.setBrush(state.bg);
//        int minAngle = (int)(state.min / (max - min) * arcAngle);
//        int maxAngle = (int)(state.max / (max - min) * arcAngle);
//        g._fillArc(px,py,size,size,startAngle-minAngle,-(maxAngle-minAngle));
//      }
//  
//      if (states.size() > 0)
//      {
//        int temp = (int)(radius - radius * 0.95);
//        if (temp < 2) temp = 2;
//        g.setBrush(bgColor);
//        g._fillArc(px+temp,py+temp,size-(temp*2),size-(temp*2),startAngle,-(fillCircle ? 360 : arcAngle));
//      }
    }

    g.setBrush(getForeground());
    if (geom != null) g.stroke(geom);
    //g._drawArc(px,py,size-1,size-1,startAngle,-(fillCircle ? 360 : arcAngle));
    
    // This obscures min and max scale values - XOR? Position min/max differently?
    /*
    if (!fillCircle)
    {
      double minEdge = startAngle * TO_RAD;
      double maxEdge = (startAngle - arcAngle) * TO_RAD;
      
      int dx = (int)(Math.cos(minEdge) * radius);
      int dy = (int)(Math.sin(minEdge) * radius);
      g.strokeLine(cx, cy, cx+dx, cy-dy);
      
      dx = (int)(Math.cos(maxEdge) * radius);
      dy = (int)(Math.sin(maxEdge) * radius);
      g.strokeLine(cx, cy, cx+dx, cy-dy);
    }
    */
    
    //
    // Needle
    //
    double angle = sa;
    if (value <= mn) angle = sa * TO_RAD;
    else if (value >= mx) angle = (sa - aa) * TO_RAD;
    else angle = (sa - ((value - mn) / (mx - mn) * aa)) * TO_RAD;
    int dx = (int)(Math.cos(angle) * radius);
    int dy = (int)(Math.sin(angle) * radius);

    //get current pen
    BPen currentPen = g.getPen();
    
    //Issue 18919
    g.setPen(getNeedlePen());
    g.setBrush(getNeedleBrush());
    g.strokeLine(cx, cy, cx+dx, cy-dy);
    
    //restore old pen
    g.setPen(currentPen);

    //
    // Value
    //
    String s = getText();
    g.setFont(vfont);
    g.setBrush(getForeground());
    if (getValueVisible()) 
      g.drawString(s, cx - (vfont.width(s) / 2), cy + vfont.getHeight());

    //
    // Divisions
    //
    int numDiv = getNumDivisions();
    int subDiv = getNumSubDivisions();
    double subAngle = aa / numDiv;
    double dv = (mx - mn) / numDiv;
    g.setFont(sfont);

    for (int i=0; i<=numDiv; i++)
    {
      double a = (sa - (subAngle * i)) * TO_RAD;
      double cos = Math.cos(a);
      double sin = Math.sin(a);
      double tx  = cx + (int)(cos * radius);
      double ty  = cy - (int)(sin * radius);
      double tx2 = cx + (int)(cos * radius * 0.95);
      double ty2 = cy - (int)(sin * radius * 0.95);
      g.strokeLine(tx, ty, tx2, ty2);

      if (getShowSubDivisions() && i<numDiv)
      {
        double sda = subAngle  / subDiv;
        for (int j=0; j<=subDiv; j++)
        {
          double za = (sa - (subAngle * i) - (sda * j)) * TO_RAD;
          double scos = Math.cos(za);
          double ssin = Math.sin(za);
          double stx  = cx + (int)(scos * radius);
          double sty  = cy - (int)(ssin * radius);
          double stx2 = cx + (int)(scos * radius * 0.98);
          double sty2 = cy - (int)(ssin * radius * 0.98);
          g.strokeLine(stx, sty, stx2, sty2);
        }
      }

      if (getScaleVisible())
      {
        double tx3 = cx + (int)(cos * radius * 0.90);
        double ty3 = cy - (int)(sin * radius * 0.90);
        
        String str = Integer.toString((int)(mn + (dv * i)));
        if (a == 0 || a == Math.PI) ty3 += sfont.getAscent() / 2;
        else if (a == HALF_PI) ty3 += sfont.getAscent();
        else if (a > 0 && a < Math.PI) ty3 += sfont.getAscent();
        
        if (a < 0) a = -a;

        if (a == HALF_PI || a == THREE_HALF_PI) tx3 -= sfont.width(str) / 2;
        else if (a >= 0 && a < HALF_PI) tx3 -= sfont.width(str);
        else if (a > THREE_HALF_PI && a <= TWO_PI) tx3 -= sfont.width(str);
        
        g.drawString(str, tx3, ty3);
      }
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  static Lexicon lex = Lexicon.make("kitPx");
  static BFont defValueFont = BFont.make(lex.getText("analogMeter.value.font"));
  static BFont defScaleFont = BFont.make(lex.getText("analogMeter.scale.font"));
  
  private static final double TO_RAD = 2 * Math.PI / 360;  
  private static final double HALF_PI = Math.PI / 2;
  private static final double THREE_HALF_PI = 3 * Math.PI / 2;
  private static final double TWO_PI  = 2 * Math.PI;

  private double size = 0;
  private double px   = 0;
  private double py   = 0;
  private double radius = 0f;
  private double cx = 0;
  private double cy = 0;
  private IGeom geom = null;
}
