/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitLon;

import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 *   This class file specifies parameters needed by BLonReplace.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  24 Aug 07
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BReplaceParameter
  extends BStruct
{  
  /*-
  
  class BReplaceParameter
  {
    properties
    {
      servicePin: boolean
        -- Flag indicating use of service pin to identify 
        -- physical device.
        default {[ false ]}
      neuronId: BNeuronId
        -- NeuronId if different than current setting. Otherwise leave
        -- at BNeuronId.DEFAULT.
        default {[ BNeuronId.DEFAULT ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitLon.BReplaceParameter(126771819)1.0$ @*/
/* Generated Fri Aug 24 09:10:02 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "servicePin"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>servicePin</code> property.
   * Flag indicating use of service pin to identify physical
   * device.
   * @see com.tridium.kitLon.BReplaceParameter#getServicePin
   * @see com.tridium.kitLon.BReplaceParameter#setServicePin
   */
  public static final Property servicePin = newProperty(0, false,null);
  
  /**
   * Get the <code>servicePin</code> property.
   * @see com.tridium.kitLon.BReplaceParameter#servicePin
   */
  public boolean getServicePin() { return getBoolean(servicePin); }
  
  /**
   * Set the <code>servicePin</code> property.
   * @see com.tridium.kitLon.BReplaceParameter#servicePin
   */
  public void setServicePin(boolean v) { setBoolean(servicePin,v,null); }

////////////////////////////////////////////////////////////////
// Property "neuronId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>neuronId</code> property.
   * NeuronId if different than current setting. Otherwise
   * leave at BNeuronId.DEFAULT.
   * @see com.tridium.kitLon.BReplaceParameter#getNeuronId
   * @see com.tridium.kitLon.BReplaceParameter#setNeuronId
   */
  public static final Property neuronId = newProperty(0, BNeuronId.DEFAULT,null);
  
  /**
   * Get the <code>neuronId</code> property.
   * @see com.tridium.kitLon.BReplaceParameter#neuronId
   */
  public BNeuronId getNeuronId() { return (BNeuronId)get(neuronId); }
  
  /**
   * Set the <code>neuronId</code> property.
   * @see com.tridium.kitLon.BReplaceParameter#neuronId
   */
  public void setNeuronId(BNeuronId v) { set(neuronId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BReplaceParameter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * No arg constructor
  public BReplaceParameter()
  {
  }
   */

  
}
