/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitLon;

import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.local.BPseudoNvContainer;

import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonSnvtType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.sys.*;

/**
 * BLonTime provides a linkable SnvtTimeStamp source with a programmable
 * update time.
 *
 * @author    Robert Adams
 * @creation  27 April 2006
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BLonTime
  extends BPseudoNvContainer
{
  /*-
  
  class BLonTime
  {
    properties
    {
        
      updateTime: BRelTime
        default {[ BRelTime.make(10000) ]}
      
      timeStamp : BPseudoNV 
        default {[ new BPseudoNV(BLonSnvtType.SNVT_TIME_STAMP, BLonNvDirection.output) ]}
    }

    actions
    {
      timerExpired()
        flags { hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitLon.BLonTime(3876074758)1.0$ @*/
/* Generated Thu Apr 27 15:37:10 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "updateTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>updateTime</code> property.
   * @see com.tridium.kitLon.BLonTime#getUpdateTime
   * @see com.tridium.kitLon.BLonTime#setUpdateTime
   */
  public static final Property updateTime = newProperty(0, BRelTime.make(10000),null);
  
  /**
   * Get the <code>updateTime</code> property.
   * @see com.tridium.kitLon.BLonTime#updateTime
   */
  public BRelTime getUpdateTime() { return (BRelTime)get(updateTime); }
  
  /**
   * Set the <code>updateTime</code> property.
   * @see com.tridium.kitLon.BLonTime#updateTime
   */
  public void setUpdateTime(BRelTime v) { set(updateTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "timeStamp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timeStamp</code> property.
   * @see com.tridium.kitLon.BLonTime#getTimeStamp
   * @see com.tridium.kitLon.BLonTime#setTimeStamp
   */
  public static final Property timeStamp = newProperty(0, new BPseudoNV(BLonSnvtType.SNVT_TIME_STAMP, BLonNvDirection.output),null);
  
  /**
   * Get the <code>timeStamp</code> property.
   * @see com.tridium.kitLon.BLonTime#timeStamp
   */
  public BPseudoNV getTimeStamp() { return (BPseudoNV)get(timeStamp); }
  
  /**
   * Set the <code>timeStamp</code> property.
   * @see com.tridium.kitLon.BLonTime#timeStamp
   */
  public void setTimeStamp(BPseudoNV v) { set(timeStamp,v,null); }

////////////////////////////////////////////////////////////////
// Action "timerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timerExpired</code> action.
   * @see com.tridium.kitLon.BLonTime#timerExpired()
   */
  public static final Action timerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>timerExpired</code> action.
   * @see com.tridium.kitLon.BLonTime#timerExpired
   */
  public void timerExpired() { invoke(timerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonTime.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BLonTime()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
    throws Exception
  {
    super.started();
    initTimer();
  }
  
  public void stopped()
    throws Exception
  {
    super.stopped();
    if (ticket != null) ticket.cancel();
  }

  private void initTimer()
  {
    if (ticket != null) ticket.cancel();
    if(getUpdateTime().getMillis()<=0L) return;
    ticket = Clock.schedulePeriodically(this, getUpdateTime(), timerExpired, null);
  }

  /**
   * Reinitialize timer if updateTime changes
   */
  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
   
    if (!isRunning()) return;

    if (p.equals(updateTime)) initTimer();
  }

  public void doTimerExpired()
  {
    BAbsTime curr = BAbsTime.now();
    
    // Update timeStamp
    BLonData ld = getTimeStamp().copyData();
    
    ld.set("year"   , BLonFloat.make(curr.getYear  ()) );
    ld.set("month"  , BLonFloat.make(curr.getMonth ().getOrdinal() + 1) );
    ld.set("day"    , BLonFloat.make(curr.getDay   ()) );
    ld.set("hour"   , BLonFloat.make(curr.getHour  ()) );
    ld.set("minute" , BLonFloat.make(curr.getMinute()) );
    ld.set("second" , BLonFloat.make(curr.getSecond()) );
    
    getTimeStamp().updateData(ld,false); 
  }

////////////////////////////////////////////////////////////////
// Icon
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.make("module://lonworks/com/tridium/lonworks/ui/icons/nvClock.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  Clock.Ticket ticket;      // Used to manage the current timer
}
