/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitLon;

import javax.baja.lonworks.enums.BLonOccupancyEnum;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Property;
import javax.baja.sys.*;

/**
 * BLonEnumTodEvent - takes input from a Niagara EnumSchedule to update a SnvtTodEvent.
 *
 * @author Robert Adams
 * @creation 3/23/2015
 * @since Baja 1.0
 */
public class BLonEnumTodEvent
  extends BLonTodEvent
{
  public static final Property currentState = newProperty(0, new BStatusEnum(BLonOccupancyEnum.DEFAULT), null);
  public static final Property nextState = newProperty(0, new BStatusEnum(BLonOccupancyEnum.DEFAULT), null);

  /*-
  class BLonEnumTodEvent
  {
    properties
    {

    }
    actions
    {
    }

  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitLon.BLonEnumTodEvent(3591846037)1.0$ @*/
/* Generated Mon Mar 23 16:08:32 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonEnumTodEvent.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  // Called from BLonTodEvent when setting values in SnvtTodEvent
  BLonOccupancyEnum makeLonOccEnum(BStatusValue v)
  {
    BStatusEnum en = (BStatusEnum)v;
    return BLonOccupancyEnum.make(en.getValue().getOrdinal());
  }


}
