/*
 * Copyright 2008, Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitLon;

import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.enums.BBufferCountEnum;
import javax.baja.lonworks.enums.BBufferSizeEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.WriteMemRequest;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.RunnableCommand;
import com.tridium.lonworks.util.selfdoc.ReadOnlyStruct;

/**
 * BBufferParams is a utility object used to modify the Network and Application
 * buffer sizes and counts in the Neuron of the local lonworks interface. See
 * Neuron Chip Data Book Appendex A.1.  It can only be added as a child of the 
 * localLonDevice.<p>
 * When this object is first added the size and count current used is read from
 * Neuron and stored. The total memory used for these original buffer settings is
 * stored in <code>originalSize</code>.<p>
 * The sizes and counts can be changed to new settings. As they are changed the 
 * <code>currentSize</code> is updated to indicate the total memory need to implement
 * the desired setting.  This can not exceed the <code>originalSize</code> or it 
 * might make the Neuron inoperable. When the counts and sizes are as desired the 
 * <code>updateBuffers</code> action can be invoked to write these new settings to
 * the Neuron. If <code>currentSize</code> is greater than <code>originalSize</code>
 * an exception is thrown and the Neuron is not modified.
 *
 *
 * @author    Robert Adams
 * @creation  16 Sept 08
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BBufferParams
  extends BComponent
{
  /*-
  
  class BBufferParams
  {
    properties
    {
      rcvTransCnt : int  
        slotfacets {[BFacets.makeNumeric(BUnit.NULL, 0, 1, 16)]}
        default    {[ 1 ]} 
      appOutSize : BBufferSizeEnum  
        default {[ BBufferSizeEnum.DEFAULT ]}
      appInSize  : BBufferSizeEnum  
        default {[ BBufferSizeEnum.DEFAULT ]}
      netOutSize : BBufferSizeEnum  
        default {[ BBufferSizeEnum.DEFAULT ]}
      netInSize  : BBufferSizeEnum  
        default {[ BBufferSizeEnum.DEFAULT ]}
      appOutCnt  : BBufferCountEnum  
        default {[ BBufferCountEnum.DEFAULT ]}
      appInCnt   : BBufferCountEnum  
        default {[ BBufferCountEnum.DEFAULT ]}
      netOutCnt  : BBufferCountEnum  
        default {[ BBufferCountEnum.DEFAULT ]}
      netInCnt   : BBufferCountEnum  
        default {[ BBufferCountEnum.DEFAULT ]}
      priAppOutCnt  : BBufferCountEnum  
        default {[ BBufferCountEnum.DEFAULT ]}
      priNetOutCnt   : BBufferCountEnum  
        default {[ BBufferCountEnum.DEFAULT ]}
      originalSize    : int  
        flags { readonly } 
        default {[ -1 ]} 
      currentSize    : int  
        default {[ -1 ]} 
    }
    actions
    {
      updateBuffers()
        flags { async }
    }
  }  
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitLon.BBufferParams(1360297268)1.0$ @*/
/* Generated Wed Jul 09 09:44:15 EDT 2014 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "rcvTransCnt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rcvTransCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#getRcvTransCnt
   * @see com.tridium.kitLon.BBufferParams#setRcvTransCnt
   */
  public static final Property rcvTransCnt = newProperty(0, 1,BFacets.makeNumeric(BUnit.NULL, 0, 1, 16));
  
  /**
   * Get the <code>rcvTransCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#rcvTransCnt
   */
  public int getRcvTransCnt() { return getInt(rcvTransCnt); }
  
  /**
   * Set the <code>rcvTransCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#rcvTransCnt
   */
  public void setRcvTransCnt(int v) { setInt(rcvTransCnt,v,null); }

////////////////////////////////////////////////////////////////
// Property "appOutSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>appOutSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#getAppOutSize
   * @see com.tridium.kitLon.BBufferParams#setAppOutSize
   */
  public static final Property appOutSize = newProperty(0, BBufferSizeEnum.DEFAULT,null);
  
  /**
   * Get the <code>appOutSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#appOutSize
   */
  public BBufferSizeEnum getAppOutSize() { return (BBufferSizeEnum)get(appOutSize); }
  
  /**
   * Set the <code>appOutSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#appOutSize
   */
  public void setAppOutSize(BBufferSizeEnum v) { set(appOutSize,v,null); }

////////////////////////////////////////////////////////////////
// Property "appInSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>appInSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#getAppInSize
   * @see com.tridium.kitLon.BBufferParams#setAppInSize
   */
  public static final Property appInSize = newProperty(0, BBufferSizeEnum.DEFAULT,null);
  
  /**
   * Get the <code>appInSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#appInSize
   */
  public BBufferSizeEnum getAppInSize() { return (BBufferSizeEnum)get(appInSize); }
  
  /**
   * Set the <code>appInSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#appInSize
   */
  public void setAppInSize(BBufferSizeEnum v) { set(appInSize,v,null); }

////////////////////////////////////////////////////////////////
// Property "netOutSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>netOutSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#getNetOutSize
   * @see com.tridium.kitLon.BBufferParams#setNetOutSize
   */
  public static final Property netOutSize = newProperty(0, BBufferSizeEnum.DEFAULT,null);
  
  /**
   * Get the <code>netOutSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#netOutSize
   */
  public BBufferSizeEnum getNetOutSize() { return (BBufferSizeEnum)get(netOutSize); }
  
  /**
   * Set the <code>netOutSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#netOutSize
   */
  public void setNetOutSize(BBufferSizeEnum v) { set(netOutSize,v,null); }

////////////////////////////////////////////////////////////////
// Property "netInSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>netInSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#getNetInSize
   * @see com.tridium.kitLon.BBufferParams#setNetInSize
   */
  public static final Property netInSize = newProperty(0, BBufferSizeEnum.DEFAULT,null);
  
  /**
   * Get the <code>netInSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#netInSize
   */
  public BBufferSizeEnum getNetInSize() { return (BBufferSizeEnum)get(netInSize); }
  
  /**
   * Set the <code>netInSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#netInSize
   */
  public void setNetInSize(BBufferSizeEnum v) { set(netInSize,v,null); }

////////////////////////////////////////////////////////////////
// Property "appOutCnt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>appOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#getAppOutCnt
   * @see com.tridium.kitLon.BBufferParams#setAppOutCnt
   */
  public static final Property appOutCnt = newProperty(0, BBufferCountEnum.DEFAULT,null);
  
  /**
   * Get the <code>appOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#appOutCnt
   */
  public BBufferCountEnum getAppOutCnt() { return (BBufferCountEnum)get(appOutCnt); }
  
  /**
   * Set the <code>appOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#appOutCnt
   */
  public void setAppOutCnt(BBufferCountEnum v) { set(appOutCnt,v,null); }

////////////////////////////////////////////////////////////////
// Property "appInCnt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>appInCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#getAppInCnt
   * @see com.tridium.kitLon.BBufferParams#setAppInCnt
   */
  public static final Property appInCnt = newProperty(0, BBufferCountEnum.DEFAULT,null);
  
  /**
   * Get the <code>appInCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#appInCnt
   */
  public BBufferCountEnum getAppInCnt() { return (BBufferCountEnum)get(appInCnt); }
  
  /**
   * Set the <code>appInCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#appInCnt
   */
  public void setAppInCnt(BBufferCountEnum v) { set(appInCnt,v,null); }

////////////////////////////////////////////////////////////////
// Property "netOutCnt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>netOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#getNetOutCnt
   * @see com.tridium.kitLon.BBufferParams#setNetOutCnt
   */
  public static final Property netOutCnt = newProperty(0, BBufferCountEnum.DEFAULT,null);
  
  /**
   * Get the <code>netOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#netOutCnt
   */
  public BBufferCountEnum getNetOutCnt() { return (BBufferCountEnum)get(netOutCnt); }
  
  /**
   * Set the <code>netOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#netOutCnt
   */
  public void setNetOutCnt(BBufferCountEnum v) { set(netOutCnt,v,null); }

////////////////////////////////////////////////////////////////
// Property "netInCnt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>netInCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#getNetInCnt
   * @see com.tridium.kitLon.BBufferParams#setNetInCnt
   */
  public static final Property netInCnt = newProperty(0, BBufferCountEnum.DEFAULT,null);
  
  /**
   * Get the <code>netInCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#netInCnt
   */
  public BBufferCountEnum getNetInCnt() { return (BBufferCountEnum)get(netInCnt); }
  
  /**
   * Set the <code>netInCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#netInCnt
   */
  public void setNetInCnt(BBufferCountEnum v) { set(netInCnt,v,null); }

////////////////////////////////////////////////////////////////
// Property "priAppOutCnt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>priAppOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#getPriAppOutCnt
   * @see com.tridium.kitLon.BBufferParams#setPriAppOutCnt
   */
  public static final Property priAppOutCnt = newProperty(0, BBufferCountEnum.DEFAULT,null);
  
  /**
   * Get the <code>priAppOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#priAppOutCnt
   */
  public BBufferCountEnum getPriAppOutCnt() { return (BBufferCountEnum)get(priAppOutCnt); }
  
  /**
   * Set the <code>priAppOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#priAppOutCnt
   */
  public void setPriAppOutCnt(BBufferCountEnum v) { set(priAppOutCnt,v,null); }

////////////////////////////////////////////////////////////////
// Property "priNetOutCnt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>priNetOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#getPriNetOutCnt
   * @see com.tridium.kitLon.BBufferParams#setPriNetOutCnt
   */
  public static final Property priNetOutCnt = newProperty(0, BBufferCountEnum.DEFAULT,null);
  
  /**
   * Get the <code>priNetOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#priNetOutCnt
   */
  public BBufferCountEnum getPriNetOutCnt() { return (BBufferCountEnum)get(priNetOutCnt); }
  
  /**
   * Set the <code>priNetOutCnt</code> property.
   * @see com.tridium.kitLon.BBufferParams#priNetOutCnt
   */
  public void setPriNetOutCnt(BBufferCountEnum v) { set(priNetOutCnt,v,null); }

////////////////////////////////////////////////////////////////
// Property "originalSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>originalSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#getOriginalSize
   * @see com.tridium.kitLon.BBufferParams#setOriginalSize
   */
  public static final Property originalSize = newProperty(Flags.READONLY, -1,null);
  
  /**
   * Get the <code>originalSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#originalSize
   */
  public int getOriginalSize() { return getInt(originalSize); }
  
  /**
   * Set the <code>originalSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#originalSize
   */
  public void setOriginalSize(int v) { setInt(originalSize,v,null); }

////////////////////////////////////////////////////////////////
// Property "currentSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>currentSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#getCurrentSize
   * @see com.tridium.kitLon.BBufferParams#setCurrentSize
   */
  public static final Property currentSize = newProperty(0, -1,null);
  
  /**
   * Get the <code>currentSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#currentSize
   */
  public int getCurrentSize() { return getInt(currentSize); }
  
  /**
   * Set the <code>currentSize</code> property.
   * @see com.tridium.kitLon.BBufferParams#currentSize
   */
  public void setCurrentSize(int v) { setInt(currentSize,v,null); }

////////////////////////////////////////////////////////////////
// Action "updateBuffers"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>updateBuffers</code> action.
   * @see com.tridium.kitLon.BBufferParams#updateBuffers()
   */
  public static final Action updateBuffers = newAction(0,null);
  
  /**
   * Invoke the <code>updateBuffers</code> action.
   * @see com.tridium.kitLon.BBufferParams#updateBuffers
   */
  public void updateBuffers() { invoke(updateBuffers,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBufferParams.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  public BBufferParams() {}
  
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BLocalLonDevice; 
  } 
  
  public void started()
    throws Exception
  {
    super.started();
    if(getOriginalSize()<0) initParams();
  }  
  
  public void initParams()
  {
    BLonDevice dev = (BLonDevice)getParent();
    
    RunnableCommand r = new RunnableCommand(dev)
      {
        public void run() { doInitParams((BLonDevice)arg1); }
      };
      
    dev.postAsync(r);
  }

  /**
   * Route async actions
   */
  public IFuture post(Action action, BValue arg, Context cx)
  {
    if (action.equals(updateBuffers)) return postUpdateBuffers(cx);
    return super.post(action, arg, cx);
  }

  private IFuture postUpdateBuffers(Context cx)
  {
    BLonDevice dev = (BLonDevice)getParent();
    return dev.postAsync(new Invocation(this, updateBuffers, null, cx));
  }


  public void doInitParams(BLonDevice dev)
  {
    if(getOriginalSize()!=-1) return;
    
    try
    {
      ReadOnlyStruct ro = ReadOnlyStruct.make(BLocal.local, dev.lonComm(), dev.authenticate(), false);
      
      setRcvTransCnt (ro.getRcvTransCount()+1);
      setAppOutSize  (BBufferSizeEnum .make(ro.getAppBufOutSize()   ));
      setAppInSize   (BBufferSizeEnum .make(ro.getAppBufInSize()    ));
      setNetOutSize  (BBufferSizeEnum .make(ro.getNetBufOutSize()   ));
      setNetInSize   (BBufferSizeEnum .make(ro.getNetBufInSize()    ));
      setAppOutCnt   (BBufferCountEnum.make(ro.getAppBufOutCount()  ));
      setAppInCnt    (BBufferCountEnum.make(ro.getAppBufInCount()   ));
      setNetOutCnt   (BBufferCountEnum.make(ro.getNetBufOutCount()  ));
      setNetInCnt    (BBufferCountEnum.make(ro.getNetBufInCount()   ));
      setPriAppOutCnt(BBufferCountEnum.make(ro.getAppBufOutPriorityCount()  ));   
      setPriNetOutCnt(BBufferCountEnum.make(ro.getNetBufOutPriorityCount()  )); 
      
      setOriginalSize(calculateSize());
    }
    catch(Throwable e)
    {
      e.printStackTrace();
    }
  }

  public void changed(Property prop, Context context)
  {
    super.changed(prop,context);
    
    setCurrentSize(calculateSize());
  }

  public void doUpdateBuffers()
  {
    if(getCurrentSize()>getOriginalSize())
      throw new LocalizableRuntimeException("kitLon","buffercheck");
    
    byte[] data = new byte[6];

    data[0] = (byte)(getRcvTransCnt()-1 & 0x0f);
    data[1] = (byte)(((getAppOutSize  ().getOrdinal() & 0x0f)<<4) | (getAppInSize   ().getOrdinal() & 0x0f));
    data[2] = (byte)(((getNetOutSize  ().getOrdinal() & 0x0f)<<4) | (getNetInSize   ().getOrdinal() & 0x0f));
    data[3] = (byte)(((getPriNetOutCnt().getOrdinal() & 0x0f)<<4) | (getPriAppOutCnt().getOrdinal() & 0x0f));
    data[4] = (byte)(((getAppOutCnt   ().getOrdinal() & 0x0f)<<4) | (getAppInCnt    ().getOrdinal() & 0x0f));
    data[5] = (byte)(((getNetOutCnt   ().getOrdinal() & 0x0f)<<4) | (getNetInCnt    ().getOrdinal() & 0x0f));
   
    try
    {
      BLonDevice dev = (BLonDevice)getParent();

      byte[] ra = Neuron.readMemory(NetMessages.READ_ONLY_RELATIVE,dev, 0x17, 1);
      data[0] = (byte)((ra[0] & 0xf0) | (data[0] & 0x0f));

      // Attempt to write new buffer params to neuron
      WriteMemRequest writeReq = new WriteMemRequest(NetMessages.READ_ONLY_RELATIVE,
                                         0x17,
                                         data.length,
                                         NetMessages.BOTH_CS_RECALC | NetMessages.ONLY_RESET,
                                         data);
      ((BLonDevice)getParent()).lonComm().sendUnacknowledged(BLocal.local, writeReq);
    }
    catch(Throwable e)
    {
      e.printStackTrace();
    }
    
  }
  
  
  private int calculateSize()
  {
    return (getRcvTransCnt() * 13) + 
           (getAppOutSize().getSize() * getAppOutCnt().getCount()   ) + 
           (getAppInSize().getSize()  * getAppInCnt().getCount()    ) +
           (getNetOutSize().getSize() * getNetOutCnt().getCount()   ) +
           (getNetInSize().getSize()  * getNetInCnt().getCount()    ) +
           (getAppOutSize().getSize() * getPriAppOutCnt().getCount()) +
           (getNetOutSize().getSize() * getPriNetOutCnt().getCount()) ;
  }
  
  
}      
