/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStringTrim is a component that trims string.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStringTrim
  extends BComponent
  implements BIStatus
{

  /*-
  
  class BStringTrim
  {
    properties
    {
                         
      out: BStatusString
        flags { transient, summary }
        default {[ new BStatusString() ]}

      in: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStringTrim(2511549735)1.0$ @*/
/* Generated Mon May 31 10:28:36 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringTrim#getOut
   * @see com.tridium.kitControl.util.BStringTrim#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringTrim#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringTrim#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringTrim#getIn
   * @see com.tridium.kitControl.util.BStringTrim#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringTrim#in
   */
  public BStatusString getIn() { return (BStatusString)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringTrim#in
   */
  public void setIn(BStatusString v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringTrim.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStringTrim()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    getOut().setValue( calculate() );
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in)
    {
      getOut().setValue( calculate() );
      getOut().setStatus(getIn().getStatus());
    }
  }

  public String calculate()
  {
    return getIn().getValue().trim();
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
