/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStringTest is a component that converts a float to a statusNumeric.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStringTest
  extends BComponent
{
  private static String[] testTags = {"aEqualsB", "aEqualsBIgnoreCase", "aStartsWithB", "aEndsWithB", "aContainsB"};
  private static BEnumRange testRange  = BEnumRange.make(testTags);

  /*-
  
  class BStringTest
  {
    properties
    {
      
      out: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      inA: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

      inB: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      testSelect: BDynamicEnum
        default {[ BDynamicEnum.make(0, testRange) ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStringTest(592020519)1.0$ @*/
/* Generated Fri Apr 16 16:39:19 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringTest#getOut
   * @see com.tridium.kitControl.util.BStringTest#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringTest#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringTest#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringTest#getInA
   * @see com.tridium.kitControl.util.BStringTest#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringTest#inA
   */
  public BStatusString getInA() { return (BStatusString)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringTest#inA
   */
  public void setInA(BStatusString v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringTest#getInB
   * @see com.tridium.kitControl.util.BStringTest#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringTest#inB
   */
  public BStatusString getInB() { return (BStatusString)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringTest#inB
   */
  public void setInB(BStatusString v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "testSelect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>testSelect</code> property.
   * @see com.tridium.kitControl.util.BStringTest#getTestSelect
   * @see com.tridium.kitControl.util.BStringTest#setTestSelect
   */
  public static final Property testSelect = newProperty(0, BDynamicEnum.make(0, testRange),null);
  
  /**
   * Get the <code>testSelect</code> property.
   * @see com.tridium.kitControl.util.BStringTest#testSelect
   */
  public BDynamicEnum getTestSelect() { return (BDynamicEnum)get(testSelect); }
  
  /**
   * Set the <code>testSelect</code> property.
   * @see com.tridium.kitControl.util.BStringTest#testSelect
   */
  public void setTestSelect(BDynamicEnum v) { set(testSelect,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringTest.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStringTest()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    getOut().setValue( calculate() );
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == inA || p == inB || p == testSelect )
    {
      getOut().setValue( calculate() );
    }
  }

  public boolean calculate()
  {
    if(!getInA().getStatus().isValid() || !getInB().getStatus().isValid())
      return getOut().getValue();
    String inAv = getInA().getValue().trim();
    String inBv = getInB().getValue();
    switch(getTestSelect().getOrdinal())
    {
    case 0:
      return inAv.equals(inBv);
    case 1:
      return inAv.equalsIgnoreCase(inBv);
    case 2:
      return inAv.startsWith(inBv);
    case 3:
      return inAv.endsWith(inBv);
    case 4:
      return inAv.indexOf(inBv) >= 0;
    }
    return false;
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
